/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.stream;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.buffer.FastByteBuffer;
import cn.ujava.common.util.CharsetUtil;
import cn.ujava.common.util.ObjUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class FastByteArrayOutputStream
extends OutputStream {
    private final FastByteBuffer buffer;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int size) {
        this.buffer = new FastByteBuffer(size);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.append(b, off, len);
    }

    @Override
    public void write(int b) {
        this.buffer.append((byte)b);
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.buffer.reset();
    }

    public void writeTo(OutputStream out) throws IORuntimeException {
        int index = this.buffer.index();
        if (index < 0) {
            return;
        }
        try {
            for (int i = 0; i < index; ++i) {
                byte[] buf = this.buffer.array(i);
                out.write(buf);
            }
            out.write(this.buffer.array(index), 0, this.buffer.offset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        return this.buffer.toArray();
    }

    public byte[] toByteArrayZeroCopyIfPossible() {
        return this.buffer.toArrayZeroCopyIfPossible();
    }

    public String toString() {
        return this.toString(CharsetUtil.defaultCharset());
    }

    public String toString(Charset charset) {
        return new String(this.toByteArray(), ObjUtil.defaultIfNull(charset, CharsetUtil::defaultCharset));
    }
}

