/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.watch;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.func.SerBiConsumer;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.io.watch.WatchException;
import cn.ujava.common.io.watch.WatchKind;
import cn.ujava.common.io.watch.Watcher;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class WatchServer
extends Thread
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private WatchService watchService;
    protected WatchEvent.Kind<?>[] events;
    private WatchEvent.Modifier[] modifiers;
    protected boolean isClosed;
    private final Map<WatchKey, Path> watchKeyPathMap = new HashMap<WatchKey, Path>();

    public void init() throws WatchException {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new WatchException(e);
        }
        this.isClosed = false;
    }

    public void setModifiers(WatchEvent.Modifier[] modifiers) {
        this.modifiers = modifiers;
    }

    public void registerPath(Path path, int maxDepth) {
        block3: {
            WatchEvent.Kind<?>[] kinds = ArrayUtil.defaultIfEmpty(this.events, WatchKind.ALL);
            try {
                WatchKey key = ArrayUtil.isEmpty(this.modifiers) ? path.register(this.watchService, kinds) : path.register(this.watchService, kinds, this.modifiers);
                this.watchKeyPathMap.put(key, path);
                if (maxDepth > 1) {
                    Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            WatchServer.this.registerPath(dir, 0);
                            return super.postVisitDirectory(dir, exc);
                        }
                    });
                }
            }
            catch (IOException e) {
                if (e instanceof AccessDeniedException) break block3;
                throw new WatchException(e);
            }
        }
    }

    public void watch(SerBiConsumer<WatchEvent<?>, Path> action, Predicate<WatchEvent<?>> watchFilter) {
        WatchKey wk;
        try {
            wk = this.watchService.take();
        }
        catch (InterruptedException | ClosedWatchServiceException e) {
            this.close();
            return;
        }
        Path currentPath = this.watchKeyPathMap.get(wk);
        for (WatchEvent<?> event : wk.pollEvents()) {
            if (null != watchFilter && !watchFilter.test(event)) continue;
            action.accept(event, currentPath);
        }
        wk.reset();
    }

    public void watch(Watcher watcher, Predicate<WatchEvent<?>> watchFilter) {
        this.watch((WatchEvent<?> event, Path currentPath) -> {
            WatchEvent.Kind kind = event.kind();
            if (kind == WatchKind.CREATE.getValue()) {
                watcher.onCreate((WatchEvent<?>)event, (Path)currentPath);
            } else if (kind == WatchKind.MODIFY.getValue()) {
                watcher.onModify((WatchEvent<?>)event, (Path)currentPath);
            } else if (kind == WatchKind.DELETE.getValue()) {
                watcher.onDelete((WatchEvent<?>)event, (Path)currentPath);
            } else if (kind == WatchKind.OVERFLOW.getValue()) {
                watcher.onOverflow((WatchEvent<?>)event, (Path)currentPath);
            }
        }, watchFilter);
    }

    @Override
    public void close() {
        this.isClosed = true;
        IoUtil.closeQuietly(this.watchService);
    }
}

