/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.lang.loader;

import cn.ujava.common.lang.Assert;
import cn.ujava.common.lang.loader.LazyLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LazyFunLoader<T>
extends LazyLoader<T> {
    private static final long serialVersionUID = 1L;
    private Supplier<T> supplier;

    public static <T> LazyFunLoader<T> on(Supplier<T> supplier) {
        Assert.notNull(supplier, "supplier must be not null!", new Object[0]);
        return new LazyFunLoader<T>(supplier);
    }

    public LazyFunLoader(Supplier<T> supplier) {
        Assert.notNull(supplier);
        this.supplier = supplier;
    }

    @Override
    protected T init() {
        T t = this.supplier.get();
        this.supplier = null;
        return t;
    }

    public boolean isInitialize() {
        return this.supplier == null;
    }

    public void ifInitialized(Consumer<T> consumer) {
        Assert.notNull(consumer);
        if (this.isInitialize()) {
            consumer.accept(this.get());
        }
    }
}

