/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.lang.range;

import cn.ujava.common.comparator.CompareUtil;
import cn.ujava.common.lang.Opt;
import cn.ujava.common.lang.range.Bound;
import cn.ujava.common.lang.range.BoundedRange;
import java.util.Objects;

public class BoundedRangeOperation {
    public static <T extends Comparable<? super T>> BoundedRange<T> unionIfIntersected(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        if (BoundedRangeOperation.isDisjoint(boundedRange, other)) {
            return boundedRange;
        }
        return new BoundedRange<T>(CompareUtil.min(boundedRange.getLowerBound(), other.getLowerBound()), CompareUtil.max(boundedRange.getUpperBound(), other.getUpperBound()));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> span(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        return new BoundedRange<T>(CompareUtil.min(boundedRange.getLowerBound(), other.getLowerBound()), CompareUtil.max(boundedRange.getUpperBound(), other.getUpperBound()));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> gap(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        if (BoundedRangeOperation.isIntersected(boundedRange, other)) {
            return null;
        }
        return new BoundedRange(CompareUtil.min(boundedRange.getUpperBound(), other.getUpperBound()).negate(), CompareUtil.max(boundedRange.getLowerBound(), other.getLowerBound()).negate());
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> intersection(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        if (BoundedRangeOperation.isDisjoint(boundedRange, other)) {
            return null;
        }
        return new BoundedRange<T>(CompareUtil.max(boundedRange.getLowerBound(), other.getLowerBound()), CompareUtil.min(boundedRange.getUpperBound(), other.getUpperBound()));
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subGreatThan(BoundedRange<T> boundedRange, T min) {
        return Opt.ofNullable(min).filter(boundedRange).map(t -> new BoundedRange<Comparable>(Bound.greaterThan(t), boundedRange.getUpperBound())).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subAtLeast(BoundedRange<T> boundedRange, T min) {
        return Opt.ofNullable(min).filter(boundedRange).map(t -> new BoundedRange<Comparable>(Bound.atLeast(t), boundedRange.getUpperBound())).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subLessThan(BoundedRange<T> boundedRange, T max) {
        return Opt.ofNullable(max).filter(boundedRange).map(t -> new BoundedRange<Comparable>(boundedRange.getLowerBound(), Bound.lessThan(max))).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> BoundedRange<T> subAtMost(BoundedRange<T> boundedRange, T max) {
        return Opt.ofNullable(max).filter(boundedRange).map(t -> new BoundedRange<Comparable>(boundedRange.getLowerBound(), Bound.atMost(max))).orElse(boundedRange);
    }

    public static <T extends Comparable<? super T>> boolean isIntersected(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        return !BoundedRangeOperation.isDisjoint(boundedRange, other);
    }

    public static <T extends Comparable<? super T>> boolean isDisjoint(BoundedRange<T> boundedRange, BoundedRange<T> other) {
        Objects.requireNonNull(boundedRange);
        Objects.requireNonNull(other);
        return boundedRange.getLowerBound().compareTo(other.getUpperBound()) > 0 || boundedRange.getUpperBound().compareTo(other.getLowerBound()) < 0;
    }
}

