/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.map;

import cn.ujava.common.bean.BeanPath;
import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.bean.copier.CopyOptions;
import cn.ujava.common.collection.set.SetUtil;
import cn.ujava.common.convert.Convert;
import cn.ujava.common.exception.CloneException;
import cn.ujava.common.func.LambdaInfo;
import cn.ujava.common.func.LambdaUtil;
import cn.ujava.common.func.SerFunction;
import cn.ujava.common.func.SerSupplier;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.lang.getter.TypeGetter;
import cn.ujava.common.map.CustomKeyMap;
import cn.ujava.common.map.MapUtil;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Dict
extends CustomKeyMap<String, Object>
implements TypeGetter<String> {
    private static final long serialVersionUID = 6135423866861206530L;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private boolean caseInsensitive;

    public static Dict of() {
        return new Dict();
    }

    public static <T> Dict parse(T bean) {
        return Dict.of().parseBean(bean);
    }

    @SafeVarargs
    public static Dict ofEntries(Map.Entry<String, Object> ... pairs) {
        Dict dict = Dict.of();
        for (Map.Entry<String, Object> pair : pairs) {
            dict.put(pair.getKey(), pair.getValue());
        }
        return dict;
    }

    public static Dict ofKvs(Object ... keysAndValues) {
        Dict dict = Dict.of();
        String key = null;
        for (int i = 0; i < keysAndValues.length; ++i) {
            if ((i & 1) == 0) {
                key = Convert.toStr(keysAndValues[i]);
                continue;
            }
            dict.put(key, keysAndValues[i]);
        }
        return dict;
    }

    public Dict() {
        this(false);
    }

    public Dict(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dict(int initialCapacity) {
        this(initialCapacity, false);
    }

    public Dict(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dict(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public Dict(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(new LinkedHashMap(initialCapacity, loadFactor));
        this.caseInsensitive = caseInsensitive;
    }

    public Dict(Map<String, Object> m) {
        super(null == m ? new HashMap() : m);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBeanIgnoreCase(T bean) {
        BeanUtil.fillBeanWithMapIgnoreCase(this, bean, false);
        return bean;
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanUtil.fillBeanWithMap(this, bean, isToCamelCase, false);
        return bean;
    }

    public <T> T toBeanWithCamelCase(T bean) {
        BeanUtil.fillBeanWithMap(this, bean, true, false);
        return bean;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtil.toBean(this, clazz);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanUtil.toBean((Object)this, clazz, CopyOptions.of().setIgnoreCase(true));
    }

    public <T> Dict parseBean(T bean) {
        Assert.notNull(bean, "Bean must not be null", new Object[0]);
        this.putAll(BeanUtil.beanToMap(bean, new String[0]));
        return this;
    }

    public <T> Dict parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Assert.notNull(bean, "Bean must not be null", new Object[0]);
        this.putAll(BeanUtil.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dict> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = SetUtil.of(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || !Objects.equals(value = this.get(entry.getKey()), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dict filterNew(String ... keys) {
        Dict result = new Dict(keys.length, 1.0f);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public Dict removeNew(String ... keys) {
        return MapUtil.removeAny(this.clone(), keys);
    }

    public Dict set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dict setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public <P, T> T get(SerFunction<P, T> func) {
        LambdaInfo lambdaInfo = LambdaUtil.resolve(func);
        return this.get(lambdaInfo.getFieldName(), lambdaInfo.getReturnType());
    }

    public <T> T getBean(String attr) {
        return (T)this.get(attr);
    }

    public <T> T getByPath(String expression) {
        return (T)BeanPath.of(expression).get(this);
    }

    public <T> T getByPath(String expression, Type resultType) {
        return Convert.convert(resultType, this.getByPath(expression));
    }

    @Override
    public Dict clone() {
        try {
            return (Dict)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }

    @Override
    protected String customKey(Object key) {
        if (this.caseInsensitive && null != key) {
            key = ((String)key).toLowerCase();
        }
        return (String)key;
    }

    public Dict setFields(SerSupplier<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaUtil.getFieldName(f), f.get()));
        return this;
    }
}

