/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.map;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.text.StrJoiner;
import cn.ujava.common.text.StrUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public class MapJoiner {
    private final StrJoiner joiner;
    private final String keyValueSeparator;

    public static MapJoiner of(String separator, String keyValueSeparator) {
        return MapJoiner.of(StrJoiner.of(separator), keyValueSeparator);
    }

    public static MapJoiner of(StrJoiner joiner, String keyValueSeparator) {
        return new MapJoiner(joiner, keyValueSeparator);
    }

    public MapJoiner(StrJoiner joiner, String keyValueSeparator) {
        this.joiner = joiner;
        this.keyValueSeparator = keyValueSeparator;
    }

    public <K, V> MapJoiner append(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        return this.append(map.entrySet().iterator(), predicate);
    }

    public <K, V> MapJoiner append(Iterator<? extends Map.Entry<K, V>> parts, Predicate<Map.Entry<K, V>> predicate) {
        if (null == parts) {
            return this;
        }
        while (parts.hasNext()) {
            Map.Entry<K, V> entry = parts.next();
            if (null != predicate && !predicate.test(entry)) continue;
            this.joiner.append(StrJoiner.of(this.keyValueSeparator).append(entry.getKey()).append(entry.getValue()));
        }
        return this;
    }

    public MapJoiner append(String ... params) {
        if (ArrayUtil.isNotEmpty(params)) {
            this.joiner.append(StrUtil.concat(false, params));
        }
        return this;
    }

    public String toString() {
        return this.joiner.toString();
    }
}

