/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.map.multi;

import cn.ujava.common.collection.CollUtil;
import cn.ujava.common.lang.Opt;
import cn.ujava.common.map.MapWrapper;
import cn.ujava.common.map.multi.MultiValueMap;
import cn.ujava.common.util.ObjUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbsCollValueMap<K, V>
extends MapWrapper<K, Collection<V>>
implements MultiValueMap<K, V> {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_COLLECTION_INITIAL_CAPACITY = 3;

    protected AbsCollValueMap(Supplier<Map<K, Collection<V>>> mapFactory) {
        super(mapFactory);
    }

    protected AbsCollValueMap(Map<K, Collection<V>> map) {
        super(new HashMap<K, Collection<V>>(map));
    }

    protected AbsCollValueMap() {
        super(new HashMap(16));
    }

    @Override
    public boolean putAllValues(K key, Collection<V> coll) {
        if (ObjUtil.isNull(coll)) {
            return false;
        }
        return super.computeIfAbsent(key, k -> this.createCollection()).addAll(coll);
    }

    @Override
    public boolean putValue(K key, V value) {
        return super.computeIfAbsent(key, k -> this.createCollection()).add(value);
    }

    @Override
    public boolean removeValue(K key, V value) {
        return Opt.ofNullable(super.get(key)).map(t -> t.remove(value)).orElse(false);
    }

    @Override
    public boolean removeAllValues(K key, Collection<V> values) {
        if (CollUtil.isEmpty(values)) {
            return false;
        }
        Collection coll = (Collection)this.get(key);
        return ObjUtil.isNotNull(coll) && coll.removeAll(values);
    }

    @Override
    public MultiValueMap<K, V> filterAllValues(BiPredicate<K, V> filter) {
        this.entrySet().forEach((? super T e) -> {
            Object k = e.getKey();
            Collection coll = ((Collection)e.getValue()).stream().filter(v -> filter.test(k, v)).collect(Collectors.toCollection(this::createCollection));
            e.setValue(coll);
        });
        return this;
    }

    @Override
    public MultiValueMap<K, V> replaceAllValues(BiFunction<K, V, V> operate) {
        this.entrySet().forEach((? super T e) -> {
            Object k = e.getKey();
            Collection coll = ((Collection)e.getValue()).stream().map(v -> operate.apply(k, v)).collect(Collectors.toCollection(this::createCollection));
            e.setValue(coll);
        });
        return this;
    }

    protected abstract Collection<V> createCollection();
}

