/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.map.multi;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.collection.CollUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public interface MultiValueMap<K, V>
extends Map<K, Collection<V>> {
    @Override
    public Collection<V> put(K var1, Collection<V> var2);

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> var1);

    default public void putAllValues(Map<? extends K, ? extends Collection<V>> m) {
        if (CollUtil.isNotEmpty(m)) {
            m.forEach(this::putAllValues);
        }
    }

    public boolean putAllValues(K var1, Collection<V> var2);

    default public boolean putValues(K key, V ... values) {
        return ArrayUtil.isNotEmpty(values) && this.putAllValues(key, Arrays.asList(values));
    }

    public boolean putValue(K var1, V var2);

    public boolean removeValue(K var1, V var2);

    default public boolean removeValues(K key, V ... values) {
        return ArrayUtil.isNotEmpty(values) && this.removeAllValues(key, Arrays.asList(values));
    }

    public boolean removeAllValues(K var1, Collection<V> var2);

    default public MultiValueMap<K, V> filterAllValues(Predicate<V> filter) {
        return this.filterAllValues((K k, V v) -> filter.test(v));
    }

    public MultiValueMap<K, V> filterAllValues(BiPredicate<K, V> var1);

    default public MultiValueMap<K, V> replaceAllValues(UnaryOperator<V> operate) {
        return this.replaceAllValues((K k, V v) -> operate.apply(v));
    }

    public MultiValueMap<K, V> replaceAllValues(BiFunction<K, V, V> var1);

    default public V getValue(K key, int index) {
        Collection collection = (Collection)this.get(key);
        return (V)CollUtil.get(collection, index);
    }

    default public Collection<V> getValues(K key) {
        return this.getOrDefault(key, Collections.emptyList());
    }

    default public int size(K key) {
        return this.getValues(key).size();
    }

    default public void allForEach(BiConsumer<K, V> consumer) {
        this.forEach((k, coll) -> coll.forEach((? super T v) -> consumer.accept(k, v)));
    }

    default public Collection<V> allValues() {
        return this.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

