/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.net;

import cn.ujava.common.collection.CollUtil;
import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.lang.Singleton;
import cn.ujava.common.net.Ipv4Util;
import cn.ujava.common.net.MacAddressUtil;
import cn.ujava.common.net.NetUtil;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashSet;

public class Ipv6Util {
    private static volatile String localhostName;

    public static BigInteger ipv6ToBigInteger(String ipv6Str) {
        try {
            InetAddress address = InetAddress.getByName(ipv6Str);
            if (address instanceof Inet6Address) {
                return new BigInteger(1, address.getAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static String bigIntegerToIPv6(BigInteger bigInteger) {
        try {
            return InetAddress.getByAddress(bigInteger.toByteArray()).toString().substring(1);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(t -> t instanceof Inet6Address);
        return NetUtil.toIpList(localAddressList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLocalHostName() {
        if (null != localhostName) return localhostName;
        Class<Ipv4Util> clazz = Ipv4Util.class;
        synchronized (Ipv4Util.class) {
            if (null != localhostName) return localhostName;
            localhostName = NetUtil.getAddressName(Ipv6Util.getLocalhostDirectly());
            // ** MonitorExit[var0] (shouldn't be in output)
            return localhostName;
        }
    }

    public static String getLocalMacAddress() {
        return MacAddressUtil.getMacAddress(Ipv6Util.getLocalhost());
    }

    public static byte[] getLocalHardwareAddress() {
        return MacAddressUtil.getHardwareAddress(Ipv6Util.getLocalhost());
    }

    public static InetAddress getLocalhost() {
        return Singleton.get(Ipv6Util.class.getName(), Ipv6Util::getLocalhostDirectly);
    }

    public static InetAddress getLocalhostDirectly() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> address instanceof Inet6Address && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress());
        if (CollUtil.isNotEmpty(localAddressList)) {
            return CollUtil.getFirst(localAddressList);
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet6Address) {
                return localHost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int index = addr.lastIndexOf(37);
        if (index > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, index) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                throw new HutoolException(e);
            }
        }
        return address;
    }
}

