/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.net.url;

import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.net.url.RFC3986;
import cn.ujava.common.text.CharUtil;
import cn.ujava.common.util.CharsetUtil;
import java.nio.charset.Charset;

public class URLEncoder {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;

    public static String encodeAll(String url) {
        return URLEncoder.encodeAll(url, DEFAULT_CHARSET);
    }

    public static String encodeAll(String url, Charset charset) throws HutoolException {
        return RFC3986.UNRESERVED.encode(url, charset, new char[0]);
    }

    public static String encodeQuery(String url) {
        return URLEncoder.encodeQuery(url, DEFAULT_CHARSET);
    }

    public static String encodeQuery(String url, Charset charset) {
        return RFC3986.QUERY.encode(url, charset, new char[0]);
    }

    public static String encodeBlank(CharSequence urlStr) {
        if (urlStr == null) {
            return null;
        }
        int len = urlStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = urlStr.charAt(i);
            if (CharUtil.isBlankChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

