/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text.placeholder.template;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.text.placeholder.StrTemplate;
import cn.ujava.common.text.placeholder.segment.LiteralSegment;
import cn.ujava.common.text.placeholder.segment.SinglePlaceholderSegment;
import cn.ujava.common.text.placeholder.segment.StrTemplateSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;

public class SinglePlaceholderStrTemplate
extends StrTemplate {
    public static final String DEFAULT_PLACEHOLDER = "{}";
    protected String placeholder;

    protected SinglePlaceholderStrTemplate(String template, int features, String placeholder, char escape, String defaultValue, UnaryOperator<String> defaultValueHandler) {
        super(template, escape, defaultValue, defaultValueHandler, features);
        Assert.notEmpty(placeholder);
        this.placeholder = placeholder;
        this.afterInit();
    }

    @Override
    protected List<StrTemplateSegment> parseSegments(String template) {
        int placeholderLength = this.placeholder.length();
        int strPatternLength = template.length();
        int handledPosition = 0;
        boolean lastIsLiteralSegment = false;
        SinglePlaceholderSegment singlePlaceholderSegment = SinglePlaceholderSegment.newInstance(this.placeholder);
        ArrayList<StrTemplateSegment> segments = null;
        while (true) {
            int delimIndex;
            if ((delimIndex = template.indexOf(this.placeholder, handledPosition)) == -1) {
                if (handledPosition == 0) {
                    return Collections.singletonList(new LiteralSegment(template));
                }
                if (handledPosition < strPatternLength) {
                    this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition));
                }
                return segments;
            }
            if (segments == null) {
                segments = new ArrayList<StrTemplateSegment>();
            }
            if (delimIndex > 0 && template.charAt(delimIndex - 1) == this.escape) {
                if (delimIndex > 1 && template.charAt(delimIndex - 2) == this.escape) {
                    this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition, delimIndex - 1));
                    segments.add(singlePlaceholderSegment);
                    lastIsLiteralSegment = false;
                    handledPosition = delimIndex + placeholderLength;
                    continue;
                }
                this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition, delimIndex - 1) + this.placeholder.charAt(0));
                lastIsLiteralSegment = true;
                handledPosition = delimIndex + 1;
                continue;
            }
            this.addLiteralSegment(lastIsLiteralSegment, segments, template.substring(handledPosition, delimIndex));
            segments.add(singlePlaceholderSegment);
            lastIsLiteralSegment = false;
            handledPosition = delimIndex + placeholderLength;
        }
    }

    public String format(Object ... args) {
        return this.formatArray(args);
    }

    public String formatArray(Object array) {
        return this.formatArray(ArrayUtil.wrap(array));
    }

    public String formatArray(Object[] array) {
        if (array == null) {
            return this.getTemplate();
        }
        return this.format(Arrays.asList(array));
    }

    public String format(Iterable<?> iterable) {
        return super.formatSequence(iterable);
    }

    public String[] matchesToArray(String str) {
        return this.matches(str).toArray(new String[0]);
    }

    public List<String> matches(String str) {
        return super.matchesSequence(str);
    }

    public static Builder builder(String template) {
        return new Builder(template);
    }

    public static class Builder
    extends StrTemplate.AbstractBuilder<Builder, SinglePlaceholderStrTemplate> {
        protected String placeholder;

        protected Builder(String template) {
            super(template);
        }

        public Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        @Override
        protected SinglePlaceholderStrTemplate buildInstance() {
            if (this.placeholder == null) {
                this.placeholder = SinglePlaceholderStrTemplate.DEFAULT_PLACEHOLDER;
            }
            return new SinglePlaceholderStrTemplate(this.template, this.features, this.placeholder, this.escape, this.defaultValue, this.defaultValueHandler);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

