/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.thread;

import cn.ujava.common.exception.ExceptionUtil;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.stream.StreamUtil;
import cn.ujava.common.thread.ThreadException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AsyncUtil {
    public static void waitAll(CompletableFuture<?> ... tasks) {
        try {
            CompletableFuture.allOf(tasks).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ThreadException(e);
        }
    }

    public static <T> T waitAny(CompletableFuture<?> ... tasks) {
        try {
            return (T)CompletableFuture.anyOf(tasks).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ThreadException(e);
        }
    }

    public static <T> T get(CompletableFuture<T> task) {
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ThreadException(e);
        }
    }

    public static <T> List<T> allOfGet(List<CompletableFuture<T>> tasks) {
        Assert.notEmpty(tasks);
        return AsyncUtil.allOfGet(tasks, null);
    }

    @SafeVarargs
    public static <T> List<T> allOfGet(CompletableFuture<T> ... tasks) {
        Assert.notEmpty(tasks);
        return AsyncUtil.allOfGet(Arrays.asList(tasks), null);
    }

    public static <T> List<T> allOfGet(CompletableFuture<T>[] tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncUtil.allOfGet(Arrays.asList(tasks), eHandler);
    }

    public static <T> List<T> allOfGet(List<CompletableFuture<T>> tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncUtil.execute(tasks, eHandler, false);
    }

    @SafeVarargs
    public static <T> List<T> parallelAllOfGet(CompletableFuture<T> ... tasks) {
        Assert.notEmpty(tasks);
        return AsyncUtil.parallelAllOfGet(Arrays.asList(tasks), null);
    }

    public static <T> List<T> parallelAllOfGet(List<CompletableFuture<T>> tasks) {
        Assert.notEmpty(tasks);
        return AsyncUtil.parallelAllOfGet(tasks, null);
    }

    public static <T> List<T> parallelAllOfGet(CompletableFuture<T>[] tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncUtil.parallelAllOfGet(Arrays.asList(tasks), eHandler);
    }

    public static <T> List<T> parallelAllOfGet(List<CompletableFuture<T>> tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncUtil.execute(tasks, eHandler, true);
    }

    private static <T> List<T> execute(List<CompletableFuture<T>> tasks, Function<Exception, T> eHandler, boolean isParallel) {
        return StreamUtil.of(tasks, isParallel).map(e -> {
            try {
                return e.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                if (eHandler != null) {
                    return eHandler.apply(ex);
                }
                throw ExceptionUtil.wrapRuntime(ex);
            }
        }).collect(Collectors.toList());
    }
}

