/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.tree.hierarchy;

import cn.ujava.common.collection.CollUtil;
import cn.ujava.common.tree.hierarchy.HierarchyIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class HierarchyUtil {
    public static <H, R> R traverseByBreadthFirst(H hierarchy, Predicate<? super H> filter, HierarchyIterator<H, R> hierarchyIterator) {
        return HierarchyUtil.scanHierarchies(hierarchy, filter, hierarchyIterator, Collection::addAll);
    }

    public static <H, R> R traverseByBreadthFirst(H hierarchy, HierarchyIterator<H, R> hierarchyIterator) {
        return HierarchyUtil.traverseByBreadthFirst(hierarchy, h -> true, hierarchyIterator);
    }

    public static <H, R> R traverseByDepthFirst(H hierarchy, Predicate<? super H> filter, HierarchyIterator<H, R> hierarchyIterator) {
        return HierarchyUtil.scanHierarchies(hierarchy, filter, hierarchyIterator, (queue, hierarchies) -> {
            int index = 0;
            for (Object h : hierarchies) {
                queue.add(index++, h);
            }
        });
    }

    public static <H, R> R traverseByDepthFirst(H hierarchy, HierarchyIterator<H, R> hierarchyIterator) {
        return HierarchyUtil.traverseByDepthFirst(hierarchy, h -> true, hierarchyIterator);
    }

    private static <H, R> R scanHierarchies(H hierarchy, Predicate<? super H> filter, HierarchyIterator<H, R> hierarchyIterator, BiConsumer<List<H>, Collection<? extends H>> appender) {
        Objects.requireNonNull(hierarchy);
        Objects.requireNonNull(filter);
        Objects.requireNonNull(hierarchyIterator);
        LinkedList<H> queue = new LinkedList<H>();
        HashSet accessed = new HashSet();
        queue.add(hierarchy);
        while (!queue.isEmpty()) {
            Object curr = queue.removeFirst();
            if (!accessed.add(curr) || !filter.test(curr)) continue;
            if (hierarchyIterator.isBreak(curr)) {
                return hierarchyIterator.getResult();
            }
            Collection<H> nextHierarchies = hierarchyIterator.nextHierarchies(hierarchyIterator.getResult(), curr);
            if (CollUtil.isEmpty(nextHierarchies)) continue;
            appender.accept(queue, nextHierarchies);
        }
        return hierarchyIterator.getResult();
    }
}

