/*
 * Decompiled with CFR 0.152.
 */
package com.loy.e.basic.data.service;

import com.loy.e.basic.data.domain.entity.DictionaryEntity;
import com.loy.e.basic.data.domain.entity.I18nEntity;
import com.loy.e.basic.data.repository.DictionaryRepository;
import com.loy.e.basic.data.repository.I18nRepository;
import com.loy.e.common.annotation.Author;
import com.loy.e.common.vo.KN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Author(author="Loy Fu", website="http://www.17jee.com", contact="qq\u7fa4 540553957")
@Transactional
@RestController
public class DictionaryServiceImpl {
    protected final Log logger = LogFactory.getLog(DictionaryServiceImpl.class);
    @Autowired
    DictionaryRepository dictionaryRepository;
    @Autowired
    I18nRepository i18nRepository;

    @RequestMapping(value={"**/dict"}, method={RequestMethod.GET, RequestMethod.POST})
    public List<KN> getByGroupId(String groupId, String lang) {
        if (StringUtils.isBlank((String)groupId)) {
            this.logger.warn((Object)"Dictionary parent id is null");
            return null;
        }
        List<DictionaryEntity> list = this.dictionaryRepository.findByParentId(groupId);
        ArrayList<KN> result = null;
        if (list != null) {
            result = new ArrayList<KN>();
            for (DictionaryEntity dictionaryEntity : list) {
                KN kn = new KN();
                String i18nKey = dictionaryEntity.getI18nKey();
                I18nEntity i18nEntity = this.i18nRepository.findByKeyAndLang(i18nKey, lang);
                if (i18nEntity != null) {
                    kn.setName(i18nEntity.getValue());
                } else {
                    kn.setName(dictionaryEntity.getName());
                }
                kn.setId((String)((Object)dictionaryEntity.getId()));
                result.add(kn);
            }
        }
        return result;
    }

    @RequestMapping(value={"**/dicts"}, method={RequestMethod.GET, RequestMethod.POST})
    public Map<String, List<KN>> getByGroupIds(String groups, String lang) {
        String[] groupIdArr;
        HashMap<String, List<KN>> result = new HashMap<String, List<KN>>();
        if (StringUtils.isBlank((String)groups)) {
            this.logger.warn((Object)"Dictionary parent ids is null");
            return null;
        }
        for (String groupId : groupIdArr = groups.split(",")) {
            List<KN> list = this.getByGroupId(groupId, lang);
            result.put(groupId, list);
        }
        return result;
    }
}

