/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.options.ExternalIpListOptions;
import com.abiquo.apiclient.domain.options.VirtualApplianceListOptions;
import com.abiquo.apiclient.domain.options.VirtualDatacenterListOptions;
import com.abiquo.apiclient.domain.options.VirtualMachineListOptions;
import com.abiquo.model.enumerator.NetworkType;
import com.abiquo.model.transport.AcceptedRequestDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateDto;
import com.abiquo.server.core.cloud.VirtualApplianceDto;
import com.abiquo.server.core.cloud.VirtualApplianceState;
import com.abiquo.server.core.cloud.VirtualAppliancesDto;
import com.abiquo.server.core.cloud.VirtualDatacenterDto;
import com.abiquo.server.core.cloud.VirtualDatacentersDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineState;
import com.abiquo.server.core.cloud.VirtualMachineStateDto;
import com.abiquo.server.core.cloud.VirtualMachineTaskDto;
import com.abiquo.server.core.cloud.VirtualMachinesDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpsDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworkDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationsDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.infrastructure.storage.TiersDto;
import com.abiquo.server.core.infrastructure.storage.VolumeManagementDto;
import com.abiquo.server.core.task.TaskDto;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.concurrent.TimeUnit;

public class CloudApi {
    private final RestClient client;

    CloudApi(RestClient client) {
        this.client = (RestClient)Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
    }

    public VirtualDatacenterDto getVirtualDatacenter(String id) {
        return this.client.get("/cloud/virtualdatacenters/" + id, "application/vnd.abiquo.virtualdatacenter+json", VirtualDatacenterDto.class);
    }

    public Iterable<VirtualDatacenterDto> listVirtualDatacenters() {
        return this.client.list("/cloud/virtualdatacenters", "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Iterable<VirtualDatacenterDto> listVirtualDatacenters(VirtualDatacenterListOptions options) {
        return this.client.list("/cloud/virtualdatacenters", options.queryParams(), "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Iterable<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("externalips").getHref(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Iterable<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc, ExternalIpListOptions options) {
        return this.client.list(vdc.searchLink("externalips").getHref(), options.queryParams(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Iterable<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public Iterable<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc, VirtualApplianceListOptions options) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), options.queryParams(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public VirtualApplianceDto getVirtualAppliance(String idVdc, String idVapp) {
        return this.client.get(String.format("%s/%s/virtualappliances/%s", "/cloud/virtualdatacenters", idVdc, idVapp), "application/vnd.abiquo.virtualappliance+json", VirtualApplianceDto.class);
    }

    public Iterable<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public Iterable<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp, VirtualMachineListOptions options) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public VLANNetworkDto getPrivateNetwork(VirtualDatacenterDto vdc, String idNetwork) {
        return this.client.get(vdc.searchLink("privatenetworks").getHref() + "/" + idNetwork, "application/vnd.abiquo.vlan+json", VLANNetworkDto.class);
    }

    public Iterable<VMNetworkConfigurationDto> listNetworkConfigurations(VirtualMachineDto vm) {
        return this.client.list(vm.searchLink("configurations").getHref(), "application/vnd.abiquo.virtualmachinenetworkconfigurations+json", VMNetworkConfigurationsDto.class);
    }

    public VirtualMachineDto getVirtualMachine(VirtualApplianceDto vapp, String idVm) {
        return this.client.get(vapp.searchLink("virtualmachines").getHref() + "/" + idVm, "application/vnd.abiquo.virtualmachine+json", VirtualMachineDto.class);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, String vlanAddress, String vlanGateway, String vlanName) {
        Preconditions.checkArgument((location instanceof DatacenterDto || location instanceof PublicCloudRegionDto ? 1 : 0) != 0);
        String mt = location instanceof DatacenterDto ? "application/vnd.abiquo.datacenter+json" : "application/vnd.abiquo.publiccloudregion+json";
        VirtualDatacenterDto vdc = new VirtualDatacenterDto();
        vdc.setName(name);
        vdc.setHypervisorType(type);
        vdc.addLink(Links.create("enterprise", enterprise.getEditLink().getHref(), "application/vnd.abiquo.enterprise+json"));
        vdc.addLink(Links.create("location", location.searchLink("self").getHref(), mt));
        VLANNetworkDto vlan = new VLANNetworkDto();
        vlan.setAddress(vlanAddress);
        vlan.setGateway(vlanGateway);
        vlan.setMask(Integer.valueOf(24));
        vlan.setName(vlanName);
        vlan.setType(NetworkType.INTERNAL);
        vdc.setVlan(vlan);
        return this.client.post("/cloud/virtualdatacenters", "application/vnd.abiquo.virtualdatacenter+json", "application/vnd.abiquo.virtualdatacenter+json", (SingleResourceTransportDto)vdc, VirtualDatacenterDto.class);
    }

    public VirtualApplianceDto createVirtualAppliance(VirtualDatacenterDto vdc, String name) {
        VirtualApplianceDto vapp = new VirtualApplianceDto();
        vapp.setName(name);
        return this.client.post(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliance+json", "application/vnd.abiquo.virtualappliance+json", (SingleResourceTransportDto)vapp, VirtualApplianceDto.class);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.addLink(Links.create("virtualmachinetemplate", template.getEditLink().getHref(), "application/vnd.abiquo.virtualmachinetemplate+json"));
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public VirtualMachineDto deploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deploy(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto deploy(VirtualMachineDto vm, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        this.client.post(vm.searchLink("deploy").getHref() + "?force=" + forceDeploy, "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (!refreshed.getState().isDeployed()) {
            throw new RuntimeException("Deploy virtual machine operation failed");
        }
        return refreshed;
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        this.client.post(vapp.searchLink("deploy").getHref() + "?force=" + forceDeploy, "application/vnd.abiquo.acceptedrequest+json", new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualApplianceDto refreshed = this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
        if (VirtualApplianceState.DEPLOYED != refreshed.getState()) {
            throw new RuntimeException("Deploy virtual appliance operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto undeploy(VirtualMachineDto vm, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        this.client.post(vm.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (refreshed.getState().isDeployed()) {
            throw new RuntimeException("Undeploy virtual machine operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto undeploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeploy(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        this.client.post(vapp.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualApplianceDto refreshed = this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
        if (VirtualApplianceState.NOT_DEPLOYED != refreshed.getState()) {
            throw new RuntimeException("Undeploy virtual appliance operation failed");
        }
        return refreshed;
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto powerState(VirtualMachineDto vm, VirtualMachineState state, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineStateDto vmState = new VirtualMachineStateDto();
        vmState.setState(state);
        this.client.put(vm.searchLink("state").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinestate+json", (SingleResourceTransportDto)vmState, new TypeToken<AcceptedRequestDto<String>>(){
            private static final long serialVersionUID = -6348281615419377868L;
        });
        VirtualMachineDto refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
        if (state != refreshed.getState()) {
            throw new RuntimeException("Virtual machine power state '" + state.name() + "' operation failed");
        }
        return refreshed;
    }

    public VirtualMachineDto editVirtualMachine(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineDto refreshed = null;
        if (vm.getState().isDeployed()) {
            this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, new TypeToken<AcceptedRequestDto<String>>(){
                private static final long serialVersionUID = -6348281615419377868L;
            });
            refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
            if (VirtualMachineState.OFF != refreshed.getState()) {
                throw new RuntimeException("Virtual machine reconfigure operation failed");
            }
        } else {
            this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm);
            refreshed = this.client.refresh(vm);
        }
        return refreshed;
    }

    public VolumeManagementDto getVolume(VirtualDatacenterDto vdc, String idVolume) {
        return this.client.get(vdc.searchLink("volumes").getHref() + "/" + idVolume, "application/vnd.abiquo.volume+json", VolumeManagementDto.class);
    }

    public VolumeManagementDto createVolume(VirtualDatacenterDto vdc, String name, long sizeInMb, TierDto tier) {
        VolumeManagementDto dto = new VolumeManagementDto();
        dto.setName(name);
        dto.setSizeInMB(sizeInMb);
        dto.addLink(Links.create("tier", tier.searchLink("self").getHref(), "application/vnd.abiquo.tier+json"));
        return this.client.post(vdc.searchLink("volumes").getHref(), "application/vnd.abiquo.volume+json", "application/vnd.abiquo.volume+json", (SingleResourceTransportDto)dto, VolumeManagementDto.class);
    }

    public TaskDto getTask(VirtualMachineDto vm, String idTask) {
        return this.client.get(vm.searchLink("tasks").getHref() + "/" + idTask, "application/vnd.abiquo.task+json", TaskDto.class);
    }

    public Iterable<TierDto> listTiers(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("tiers").getHref(), "application/vnd.abiquo.tiers+json", TiersDto.class);
    }
}

