/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.domain.options;

import java.util.Map;

import com.abiquo.apiclient.domain.options.ListOptions.BaseOptionsBuilder;

public abstract class AllowedLocationsListOptions extends BaseOptions
{

    protected AllowedLocationsListOptions(final Map<String, Object> queryParams)
    {
        super(queryParams);
    }

    public static AllowedBuilder< ? > builder()
    {
        return new Builder();
    }

    public static class Builder extends AllowedBuilder<Builder>
    {
        @Override
        protected Builder self()
        {
            return this;
        }

        @Override
        public AllowedLocationsListOptions build()
        {
            return build();
        }
    }

    public static abstract class AllowedBuilder<T extends AllowedBuilder<T>> extends
        BaseOptionsBuilder<T>
    {
        private int idEnterprise;

        private boolean inScope;

        private boolean allEnterprises;

        public T allEnterprises(final boolean allEnterprises)
        {
            this.allEnterprises = allEnterprises;
            return self();
        }

        public T idEnterprise(final int idEnterprise)
        {
            this.idEnterprise = idEnterprise;
            return self();
        }

        public T inScope(final boolean inScope)
        {
            this.inScope = inScope;
            return self();
        }

        @Override
        protected Map<String, Object> buildParameters()
        {
            Map<String, Object> params = super.buildParameters();
            putIfPresent("idEnterprise", idEnterprise, params);
            putIfPresent("inscope", inScope, params);
            putIfPresent("allEnterprises", allEnterprises, params);
            return params;
        }
    }
}
