/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient;

import com.abiquo.model.rest.RESTLink;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateDto;
import com.abiquo.server.core.enterprise.ScopeDto;

public class TemplateUtils
{
    public static boolean inScope(final VirtualMachineTemplateDto vmt, final ScopeDto scope)
    {
        for (RESTLink link : vmt.getLinks())
        {
            if (link.getRel().equals("scope") && link.getTitle().equals(scope.getName()))
            {
                return true;
            }
        }
        return false;
    }
}
