/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.amtransport;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
@XmlRootElement(name = "disk")
public class DiskDto implements Serializable
{
    private static final long serialVersionUID = -6497304928401087355L;

    public static final String MEDIA_TYPE = "application/vnd.abiquo.diskrequest+xml";

    private String label;

    private int sequence;

    /** Disk file (.vmdk) path relative to the repository mount point. */
    private String diskFilePath;

    private String diskFileFormat;

    /** Disk file (.vmdk) size in Bytes. */
    private Long diskFileSize;

    private Long requiredHDInMB;

    private String diskControllerType;

    private String diskController;

    private String virtualMachineTemplateUrl;

    public String getVirtualMachineTemplateUrl()
    {
        return virtualMachineTemplateUrl;
    }

    public String getDiskController()
    {
        return diskController;
    }

    public String getDiskControllerType()
    {
        return diskControllerType;
    }

    public String getDiskFileFormat()
    {
        return diskFileFormat;
    }

    public String getDiskFilePath()
    {
        return diskFilePath;
    }

    public Long getDiskFileSize()
    {
        return diskFileSize;
    }

    public String getLabel()
    {
        return label;
    }

    public Long getRequiredHDInMB()
    {
        return requiredHDInMB;
    }

    public int getSequence()
    {
        return sequence;
    }

    public void setDiskController(final String diskController)
    {
        this.diskController = diskController;
    }

    public void setDiskControllerType(final String diskControllerType)
    {
        this.diskControllerType = diskControllerType;
    }

    public void setDiskFileFormat(final String diskFileFormat)
    {
        this.diskFileFormat = diskFileFormat;
    }

    public void setDiskFilePath(final String diskFilePath)
    {
        this.diskFilePath = diskFilePath;
    }

    public void setDiskFileSize(final Long diskFileSize)
    {
        this.diskFileSize = diskFileSize;
    }

    public void setLabel(final String label)
    {
        this.label = label;
    }

    public void setRequiredHDInMB(final Long requiredHDInMB)
    {
        this.requiredHDInMB = requiredHDInMB;
    }

    public void setSequence(final int sequence)
    {
        this.sequence = sequence;
    }

    public void setVirtualMachineTemplateUrl(final String virtualMachineTemplateUrl)
    {
        this.virtualMachineTemplateUrl = virtualMachineTemplateUrl;
    }
}
