/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.domain.options;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class BaseOptions {
    private static final Pattern URL_ENCODED_PATTERN = Pattern.compile(".*%[a-fA-F0-9][a-fA-F0-9].*");
    private final Map<String, Object> queryParams;

    public Map<String, Object> queryParams() {
        return this.queryParams;
    }

    protected BaseOptions(Map<String, Object> queryParams) {
        this.queryParams = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(queryParams, (Object)"queryParams cannot be null")));
    }

    protected static void putIfPresent(String key, Object value, Map<String, Object> map) {
        if (value != null) {
            map.put(key, BaseOptions.urlEncode(value.toString()));
        }
    }

    public static boolean isUrlEncoded(String in) {
        return URL_ENCODED_PATTERN.matcher(in).matches();
    }

    public static String urlEncode(String value) {
        if (BaseOptions.isUrlEncoded(value)) {
            return value;
        }
        try {
            String encoded = URLEncoder.encode(value, "UTF-8");
            encoded = encoded.replace("+", "%20");
            encoded = encoded.replace("*", "%2A");
            return encoded;
        }
        catch (UnsupportedEncodingException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

