/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.amtransport;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * The materialization of an {@link TemplateDefinition} of a given {@link Datacenter} and
 * Enterprise.
 */
@XmlType
@XmlRootElement(name = "template")
public class TemplateDto implements Serializable
{
    public static final String MEDIA_TYPE = "application/vnd.abiquo.template+xml";

    private static final long serialVersionUID = 2906353463644232742L;

    /** Identify the enterprise repository. */
    private Integer enterpriseRepositoryId;

    /** OVF download url. */
    private String url;

    private String name;

    private String ethernetDriverType;

    private String osType;

    private String categoryName;

    private Integer requiredCpu;

    private Long requiredRamInMB;

    private String description;

    private String osVersion;

    private String iconUrl;

    private String loginPassword;

    private String loginUser;

    private String basePath;

    private List<DiskDto> disks = new LinkedList<>();

    public String getBasePath()
    {
        return basePath;
    }

    public String getCategoryName()
    {
        return categoryName;
    }

    public String getDescription()
    {
        return description;
    }

    public List<DiskDto> getDisks()
    {
        return disks;
    }

    public Integer getEnterpriseRepositoryId()
    {
        return enterpriseRepositoryId;
    }

    public String getEthernetDriverType()
    {
        return ethernetDriverType;
    }

    public String getIconUrl()
    {
        return iconUrl;
    }

    public String getLoginPassword()
    {
        return loginPassword;
    }

    public String getLoginUser()
    {
        return loginUser;
    }

    public String getName()
    {
        return name;
    }

    public String getOsType()
    {
        return osType;
    }

    public String getOsVersion()
    {
        return osVersion;
    }

    public Integer getRequiredCpu()
    {
        return requiredCpu;
    }

    public Long getRequiredRamInMB()
    {
        return requiredRamInMB;
    }

    public String getUrl()
    {
        return url;
    }

    public void setBasePath(final String basePath)
    {
        this.basePath = basePath;
    }

    public void setCategoryName(final String categoryName)
    {
        this.categoryName = categoryName;
    }

    public void setDescription(final String description)
    {
        this.description = description;
    }

    public void setDisks(final List<DiskDto> disks)
    {
        this.disks = disks;
    }

    public void setEnterpriseRepositoryId(final Integer enterpriseRepositoryId)
    {
        this.enterpriseRepositoryId = enterpriseRepositoryId;
    }

    public void setEthernetDriverType(final String ethernetDriverType)
    {
        this.ethernetDriverType = ethernetDriverType;
    }

    public void setIconUrl(final String iconUrl)
    {
        this.iconUrl = iconUrl;
    }

    public void setLoginPassword(final String loginPassword)
    {
        this.loginPassword = loginPassword;
    }

    public void setLoginUser(final String loginUser)
    {
        this.loginUser = loginUser;
    }

    public void setName(final String name)
    {
        this.name = name;
    }

    public void setOsType(final String osType)
    {
        this.osType = osType;
    }

    public void setOsVersion(final String osVersion)
    {
        this.osVersion = osVersion;
    }

    public void setRequiredCpu(final Integer requiredCpu)
    {
        this.requiredCpu = requiredCpu;
    }

    public void setRequiredRamInMB(final Long requiredRamInMB)
    {
        this.requiredRamInMB = requiredRamInMB;
    }

    public void setUrl(final String url)
    {
        this.url = url;
    }
}
