/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.domain.exception;

import static java.util.Comparator.comparing;

import java.util.Optional;

import com.abiquo.model.rest.RESTLink;
import com.abiquo.server.core.asynctask.AsyncJobDto;
import com.abiquo.server.core.asynctask.AsyncTaskDto;

public class AsyncTaskFailedException extends Exception
{
    private static final long serialVersionUID = 2416588786698499247L;

    private static final String NotAvailable = "not-available";

    private final String taskLink;

    private final String message;

    private final String code;

    public AsyncTaskFailedException(final AsyncTaskDto asyncTaskDto)
    {
        Optional<AsyncJobDto> failedJob = asyncTaskDto.getJobs().getCollection().stream() //
            .sorted(comparing(AsyncJobDto::getSequence).reversed()) //
            .findFirst();

        if (failedJob.isPresent())
        {
            code = failedJob.get().getErrorCode();
            message = failedJob.get().getErrorMessage();
        }
        else
        {
            code = NotAvailable;
            message = NotAvailable;
        }

        RESTLink selfLink = asyncTaskDto.searchLink("self");

        if (selfLink != null)
        {
            taskLink = selfLink.getHref();
        }
        else
        {
            taskLink = NotAvailable;
        }
    }

    public String getTaskLink()
    {
        return taskLink;
    }

    @Override
    public String getMessage()
    {
        return message;
    }

    public String getCode()
    {
        return code;
    }
}
