/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.domain.options;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

import com.abiquo.apiclient.domain.options.ListOptions.BaseOptionsBuilder;

public class EventListOptions extends BaseOptions
{
    private static String dateToISO8601String(final Date date)
    {
        SimpleDateFormat sdf;
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    protected EventListOptions(final Map<String, Object> queryParams)
    {
        super(queryParams);
    }

    public static Builder builder()
    {
        return new Builder();
    }

    public static class Builder extends BaseOptionsBuilder<Builder>
    {
        private String datefrom;

        private String dateto;

        private String entitytype;

        private String actiontype;

        private String entityname;

        private String severity;

        private String enterprisename;

        private String username;

        private String context;

        public Builder datefrom(final Date datefrom)
        {
            this.datefrom = dateToISO8601String(datefrom);
            return self();
        }

        public Builder dateto(final Date dateto)
        {
            this.dateto = dateToISO8601String(dateto);
            return self();
        }

        public Builder entitytype(final String entitytype)
        {
            this.entitytype = entitytype;
            return self();
        }

        public Builder actiontype(final String actiontype)
        {
            this.actiontype = actiontype;
            return self();
        }

        public Builder entityname(final String entityname)
        {
            this.entityname = entityname;
            return self();
        }

        public Builder severity(final String severity)
        {
            this.severity = severity;
            return self();
        }

        public Builder enterprisename(final String enterprisename)
        {
            this.enterprisename = enterprisename;
            return self();
        }

        public Builder context(final String context)
        {
            this.context = context;
            return self();
        }

        public Builder username(final String username)
        {
            this.username = username;
            return self();
        }

        @Override
        protected Map<String, Object> buildParameters()
        {
            Map<String, Object> params = super.buildParameters();
            putIfPresent("datefrom", datefrom, params);
            putIfPresent("dateto", dateto, params);
            putIfPresent("entitytype", entitytype, params);
            putIfPresent("actiontype", actiontype, params);
            putIfPresent("entityname", entityname, params);
            putIfPresent("severity", severity, params);
            putIfPresent("enterprisename", enterprisename, params);
            putIfPresent("username", username, params);
            putIfPresent("context", context, params);
            return params;
        }

        @Override
        public EventListOptions build()
        {
            return new EventListOptions(buildParameters());
        }

        @Override
        protected Builder self()
        {
            return this;
        }
    }
}
