/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.options.ListOptions;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.cloud.DeviceTypeDto;
import com.abiquo.server.core.cloud.DeviceTypesDto;
import com.abiquo.server.core.cloud.HardwareProfileFamilyDto;
import com.abiquo.server.core.cloud.HardwareProfileTypeDto;
import com.abiquo.server.core.cloud.HypervisorTypeDto;
import com.abiquo.server.core.cloud.HypervisorTypesDto;
import com.abiquo.server.core.cloud.RegionDto;
import com.abiquo.server.core.cloud.RegionsDto;
import com.abiquo.server.core.enterprise.PrivilegeDto;
import com.abiquo.server.core.enterprise.PrivilegesDto;
import com.abiquo.server.core.infrastructure.LocationDto;
import com.abiquo.server.core.pricing.CostCodeDto;
import com.abiquo.server.core.pricing.CostCodesDto;
import com.abiquo.server.core.pricing.CurrenciesDto;
import com.abiquo.server.core.pricing.CurrencyDto;
import com.abiquo.server.core.pricing.PricingTemplateDto;
import com.abiquo.server.core.pricing.PricingTemplatesDto;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ConfigApi {
    private final RestClient client;

    ConfigApi(RestClient client) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
    }

    public HypervisorTypeDto getHypervisorType(String type) {
        return this.client.get(String.format("%s/%s", "/config/hypervisortypes", type), "application/vnd.abiquo.hypervisortype+json", HypervisorTypeDto.class);
    }

    public HypervisorTypeDto getHypervisorType(LocationDto location) {
        return this.client.get(location.searchLink("hypervisortype").getHref(), "application/vnd.abiquo.hypervisortype+json", HypervisorTypeDto.class);
    }

    public Stream<HypervisorTypeDto> getHypervisorTypes() {
        return this.client.list("/config/hypervisortypes", "application/vnd.abiquo.hypervisortypes+json", HypervisorTypesDto.class);
    }

    public DeviceTypeDto getDeviceType(String type) {
        return this.client.get(String.format("%s/%s", "/config/devicetypes", type), "application/vnd.abiquo.devicetype+json", DeviceTypeDto.class);
    }

    public Stream<DeviceTypeDto> getDeviceTypes() {
        return this.client.list("/config/devicetypes", "application/vnd.abiquo.devicetypes+json", DeviceTypesDto.class);
    }

    public Stream<RegionDto> getRegions(String hypervisorType) {
        return this.client.list(this.getHypervisorType(hypervisorType).searchLink("regions").getHref(), "application/vnd.abiquo.regions+json", RegionsDto.class);
    }

    public Optional<RegionDto> getRegion(String hypervisorType, String region) {
        return this.getRegions(hypervisorType).filter(r -> r.getProviderId().equals(region)).findFirst();
    }

    public Stream<RegionDto> getDynamicRegions(String hypervisorType, String identity, String credential, String endpoint) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Abiquo-PCR-Identity", identity);
        headers.put("X-Abiquo-PCR-Credential", credential);
        headers.put("X-Abiquo-PCR-Endpoint", endpoint);
        return this.client.list(this.getHypervisorType(hypervisorType).searchLink("regions").getHref(), "application/vnd.abiquo.regions+json", RegionsDto.class, headers);
    }

    public Optional<RegionDto> getDynamicRegion(String hypervisorType, String region, String identity, String credential, String endpoint) {
        return this.getDynamicRegions(hypervisorType, identity, credential, endpoint).filter(r -> r.getName().equals(region)).findFirst();
    }

    public CostCodeDto createCostcode(CostCodeDto costCode) {
        return this.client.post("/config/costcodes", "application/vnd.abiquo.costcode+json; version=5.2", "application/vnd.abiquo.costcode+json; version=5.2", (SingleResourceTransportDto)costCode, CostCodeDto.class);
    }

    public Stream<CostCodeDto> listCostcodes(ListOptions options) {
        return this.client.list("/config/costcodes", options.queryParams(), "application/vnd.abiquo.costcodes+json", CostCodesDto.class);
    }

    public Stream<PrivilegeDto> listPrivileges() {
        return this.client.list("/config/privileges", "application/vnd.abiquo.privileges+json", PrivilegesDto.class);
    }

    public PricingTemplateDto createPricingTemplate(PricingTemplateDto pricingTemplate) {
        return this.client.post("/config/pricingtemplates", "application/vnd.abiquo.pricingtemplate+json", "application/vnd.abiquo.pricingtemplate+json", (SingleResourceTransportDto)pricingTemplate, PricingTemplateDto.class);
    }

    public Stream<PricingTemplateDto> listPricingTemplates() {
        return this.client.list("/config/pricingtemplates", "application/vnd.abiquo.pricingtemplates+json", PricingTemplatesDto.class);
    }

    public Stream<CurrencyDto> listCurrencies() {
        return this.client.list("/config/currencies", "application/vnd.abiquo.currencies+json", CurrenciesDto.class);
    }

    public HardwareProfileFamilyDto createHardwareProfileFamily(String name, String description) {
        HardwareProfileFamilyDto hardwareProfileFamilyDto = new HardwareProfileFamilyDto();
        hardwareProfileFamilyDto.setName(name);
        hardwareProfileFamilyDto.setDescription(description);
        return this.client.post("/config/hardwareprofilefamilies", "application/vnd.abiquo.hardwareprofilefamily+json", "application/vnd.abiquo.hardwareprofilefamily+json", (SingleResourceTransportDto)hardwareProfileFamilyDto, HardwareProfileFamilyDto.class);
    }

    public HardwareProfileTypeDto createHardwareProfileType(HardwareProfileFamilyDto hardwareProfileFamilyDto, String name, String description) {
        HardwareProfileTypeDto dto = new HardwareProfileTypeDto();
        dto.setName(name);
        dto.setDescription(description);
        return this.client.post(hardwareProfileFamilyDto.searchLink("hardwareprofiletypes").getHref(), "application/vnd.abiquo.hardwareprofiletype+json", "application/vnd.abiquo.hardwareprofiletype+json", (SingleResourceTransportDto)dto, HardwareProfileTypeDto.class);
    }
}

