/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.ApiClient;
import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.options.EnterpriseListOptions;
import com.abiquo.apiclient.domain.options.UserListOptions;
import com.abiquo.model.enumerator.AuthType;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.appslibrary.DatacenterRepositoriesDto;
import com.abiquo.server.core.appslibrary.DatacenterRepositoryDto;
import com.abiquo.server.core.asynctask.AsyncTaskDto;
import com.abiquo.server.core.cloud.CreateAccountDto;
import com.abiquo.server.core.cloud.HypervisorTypeDto;
import com.abiquo.server.core.cloud.VirtualDatacenterDto;
import com.abiquo.server.core.cloud.VirtualDatacentersDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.enterprise.EnterprisePropertiesDto;
import com.abiquo.server.core.enterprise.EnterprisesDto;
import com.abiquo.server.core.enterprise.PrivilegeDto;
import com.abiquo.server.core.enterprise.PrivilegesDto;
import com.abiquo.server.core.enterprise.RoleDto;
import com.abiquo.server.core.enterprise.RolesDto;
import com.abiquo.server.core.enterprise.ScopeDto;
import com.abiquo.server.core.enterprise.ScopesDto;
import com.abiquo.server.core.enterprise.UserDto;
import com.abiquo.server.core.enterprise.UsersDto;
import com.abiquo.server.core.infrastructure.PublicCloudCredentialsDto;
import com.abiquo.server.core.infrastructure.PublicCloudCredentialsListDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class EnterpriseApi {
    private final RestClient client;

    EnterpriseApi(RestClient client) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
    }

    public EnterpriseDto createEnterprise(String name) {
        EnterpriseDto enterprise = new EnterpriseDto();
        enterprise.setName(name);
        return this.client.post("/admin/enterprises", "application/vnd.abiquo.enterprise+json", "application/vnd.abiquo.enterprise+json", (SingleResourceTransportDto)enterprise, EnterpriseDto.class);
    }

    public EnterpriseDto createEnterprise(EnterpriseDto dto) {
        return this.client.post("/admin/enterprises", "application/vnd.abiquo.enterprise+json", "application/vnd.abiquo.enterprise+json", (SingleResourceTransportDto)dto, EnterpriseDto.class);
    }

    public EnterpriseDto editEnterprise(EnterpriseDto enterprise) {
        return this.client.put(enterprise.getEditLink().getHref(), "application/vnd.abiquo.enterprise+json", "application/vnd.abiquo.enterprise+json", (SingleResourceTransportDto)enterprise, EnterpriseDto.class);
    }

    public PublicCloudCredentialsDto addPublicCloudCredentials(EnterpriseDto enterprise, PublicCloudCredentialsDto credentials) {
        return this.client.post(String.format("%s/%s/credentials/", "/admin/enterprises", enterprise.getId()), "application/vnd.abiquo.publiccloudcredentials+json", "application/vnd.abiquo.publiccloudcredentials+json", (SingleResourceTransportDto)credentials, PublicCloudCredentialsDto.class);
    }

    public PublicCloudCredentialsDto addPublicCloudCredentials(ApiClient api, EnterpriseDto enterprise, String type, String access, String key) {
        HypervisorTypeDto hypervisorType = api.getConfigApi().getHypervisorType(type);
        PublicCloudCredentialsDto publicCloudCredentials = new PublicCloudCredentialsDto();
        publicCloudCredentials.setAccess(access);
        publicCloudCredentials.setKey(key);
        publicCloudCredentials.addLink(Links.withRel("hypervisortype", Links.editOrSelf((SingleResourceTransportDto)hypervisorType)));
        return api.getEnterpriseApi().addPublicCloudCredentials(enterprise, publicCloudCredentials);
    }

    public PublicCloudCredentialsListDto listPublicCloudCredentials(EnterpriseDto enterprise) {
        return this.client.get(enterprise.searchLink("credentials"), PublicCloudCredentialsListDto.class);
    }

    public AsyncTaskDto addPublicCloudCredentialsFromCreateAccount(EnterpriseDto enterprise, CreateAccountDto createAccount, Optional<PublicCloudRegionDto> region, HypervisorTypeDto hypervisorType) {
        if (region.isPresent()) {
            createAccount.addLink(Links.withRel("publiccloudregion", Links.editOrSelf((SingleResourceTransportDto)region.get())));
        }
        createAccount.addLink(Links.withRel("hypervisortype", Links.editOrSelf((SingleResourceTransportDto)hypervisorType)));
        return this.client.post(enterprise.searchLink("credentials").getHref(), "application/vnd.abiquo.asynctask+json", "application/vnd.abiquo.createaccount+json", (SingleResourceTransportDto)createAccount, AsyncTaskDto.class);
    }

    public EnterpriseDto getEnterprise(String id) {
        return this.client.get("/admin/enterprises/" + id, "application/vnd.abiquo.enterprise+json", EnterpriseDto.class);
    }

    public Stream<EnterpriseDto> listEnterprises() {
        return this.client.list("/admin/enterprises", "application/vnd.abiquo.enterprises+json", EnterprisesDto.class);
    }

    public Stream<EnterpriseDto> listEnterprises(EnterpriseListOptions options) {
        return this.client.list("/admin/enterprises", options.queryParams(), "application/vnd.abiquo.enterprises+json", EnterprisesDto.class);
    }

    public ScopeDto createScope(String name) {
        ScopeDto scope = new ScopeDto();
        scope.setName(name);
        scope.setAutomaticAddDatacenter(true);
        scope.setAutomaticAddEnterprise(true);
        return this.client.post("/admin/scopes", "application/vnd.abiquo.scope+json", "application/vnd.abiquo.scope+json", (SingleResourceTransportDto)scope, ScopeDto.class);
    }

    public void deleteUser(UserDto user) {
        this.client.delete((SingleResourceTransportDto)user);
    }

    public void deleteScope(ScopeDto scope) {
        this.client.delete((SingleResourceTransportDto)scope);
    }

    public UserDto editUser(UserDto user) {
        return this.client.edit(user);
    }

    public UserDto createUser(String name, String surname, String nick, String password, String email, String description, boolean active, String locale, AuthType authType, String publicSshKey, List<Integer> availableVirtualDatacentersIds, EnterpriseDto enterprise, RoleDto role, Optional<ScopeDto> scope) {
        UserDto user = new UserDto();
        user.setName(name);
        user.setSurname(surname);
        user.setNick(nick);
        user.setPassword(password);
        user.setEmail(email);
        user.setDescription(description);
        user.setActive(active);
        user.setLocale(locale);
        user.setAuthType(authType.toString());
        user.setPublicSshKey(publicSshKey);
        user.setAvailableVirtualDatacenters(Joiner.on((String)",").skipNulls().join(availableVirtualDatacentersIds));
        user.addLink(Links.create("role", role.getEditLink().getHref(), role.getEditLink().getType()));
        if (scope.isPresent()) {
            user.addLink(Links.withRel("scope", scope.get().getEditLink()));
        }
        return this.client.post(enterprise.searchLink("users").getHref(), "application/vnd.abiquo.user+json", "application/vnd.abiquo.user+json", (SingleResourceTransportDto)user, UserDto.class);
    }

    public UserDto getCurrentUser() {
        return this.client.get("/login", "application/vnd.abiquo.user+json", UserDto.class);
    }

    public Stream<UserDto> listUsers(EnterpriseDto enterprise) {
        return this.client.list(enterprise.searchLink("users").getHref(), enterprise.searchLink("users").getType(), UsersDto.class);
    }

    public Stream<UserDto> listUsers(EnterpriseDto enterprise, UserListOptions options) {
        return this.client.list(enterprise.searchLink("users").getHref(), options.queryParams(), enterprise.searchLink("users").getType(), UsersDto.class);
    }

    public Stream<RoleDto> listRoles() {
        return this.client.list("/admin/roles", "application/vnd.abiquo.roles+json", RolesDto.class);
    }

    public Stream<PrivilegeDto> listPrivileges(RoleDto role) {
        return this.client.list(role.searchLink("privileges"), PrivilegesDto.class);
    }

    public Stream<ScopeDto> listScopes() {
        return this.client.list("/admin/scopes", "application/vnd.abiquo.scopes+json", ScopesDto.class);
    }

    public Stream<DatacenterRepositoryDto> listDatacenterRepositories(EnterpriseDto enterprise) {
        return this.client.list(enterprise.searchLink("datacenterrepositories"), DatacenterRepositoriesDto.class);
    }

    public EnterprisePropertiesDto getEnterpriseProperties(EnterpriseDto enterprise) {
        return this.client.get(enterprise.searchLink("properties").getHref(), "application/vnd.abiquo.enterpriseproperties+json", EnterprisePropertiesDto.class);
    }

    public String getEnterpriseProperty(EnterpriseDto enterprise, String key) {
        EnterprisePropertiesDto entProp = this.client.get(enterprise.searchLink("properties").getHref(), "application/vnd.abiquo.enterpriseproperties+json; version=5.2", EnterprisePropertiesDto.class);
        return entProp.getProperties().stream().filter(p -> key.equals(p.getPropertyKey())).findAny().map(EnterprisePropertiesDto.Property::getPropertyValue).orElse(null);
    }

    public EnterprisePropertiesDto addEnterpriseProperties(EnterpriseDto enterprise, EnterprisePropertiesDto properties) {
        EnterprisePropertiesDto prop = this.getEnterpriseProperties(enterprise);
        prop.getProperties().addAll(properties.getProperties());
        return this.client.put(prop.searchLink("edit").getHref(), "application/vnd.abiquo.enterpriseproperties+json", "application/vnd.abiquo.enterpriseproperties+json", (SingleResourceTransportDto)prop, EnterprisePropertiesDto.class);
    }

    public EnterprisePropertiesDto deleteEnterpriseProperties(EnterpriseDto enterprise, List<String> keys) {
        EnterprisePropertiesDto prop = this.getEnterpriseProperties(enterprise);
        for (String key : keys) {
            prop.getProperties().removeIf(p -> key.equals(p.getPropertyKey()));
        }
        return this.client.put(prop.searchLink("edit").getHref(), "application/vnd.abiquo.enterpriseproperties+json; version=5.2", "application/vnd.abiquo.enterpriseproperties+json; version=5.2", (SingleResourceTransportDto)prop, EnterprisePropertiesDto.class);
    }

    public Stream<PrivilegeDto> listAllPrivileges() {
        return this.client.list("/config/privileges", "application/vnd.abiquo.privileges+json", PrivilegesDto.class);
    }

    public Stream<RoleDto> listRolesFromEnterprise(EnterpriseDto ent) {
        Integer entId = ent.getId();
        return this.client.list("/admin/roles?identerprise=" + entId, "application/vnd.abiquo.roles+json", RolesDto.class);
    }

    public Stream<VirtualDatacenterDto> listVirtualDatacenters(EnterpriseDto enterprise) {
        RESTLink vdcsLink = enterprise.searchLink("cloud/virtualdatacenters");
        return this.client.list(vdcsLink.getHref(), "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }
}

