/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.exception.HttpException;
import com.abiquo.apiclient.domain.options.DatacenterListOptions;
import com.abiquo.apiclient.domain.options.NatIPsListOptions;
import com.abiquo.apiclient.domain.options.PublicCloudRegionListOptions;
import com.abiquo.apiclient.domain.options.VirtualMachineInfrastructureListOptions;
import com.abiquo.model.enumerator.NetworkType;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.LinksDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.cloud.DeviceDto;
import com.abiquo.server.core.cloud.DeviceTypeDto;
import com.abiquo.server.core.cloud.HardwareProfileDto;
import com.abiquo.server.core.cloud.HardwareProfilesDto;
import com.abiquo.server.core.cloud.NatIpDto;
import com.abiquo.server.core.cloud.NatIpsDto;
import com.abiquo.server.core.cloud.NatNetworkDto;
import com.abiquo.server.core.cloud.NatNetworksDto;
import com.abiquo.server.core.cloud.RegionDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineFlatDto;
import com.abiquo.server.core.cloud.VirtualMachinesDto;
import com.abiquo.server.core.enterprise.DatacenterLimitsDto;
import com.abiquo.server.core.enterprise.DatacentersLimitsDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.enterprise.PrivilegeDto;
import com.abiquo.server.core.enterprise.PrivilegesDto;
import com.abiquo.server.core.enterprise.RoleDto;
import com.abiquo.server.core.enterprise.RolesDto;
import com.abiquo.server.core.infrastructure.ClusterDto;
import com.abiquo.server.core.infrastructure.ClustersDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.DatacentersDto;
import com.abiquo.server.core.infrastructure.DatastoreDto;
import com.abiquo.server.core.infrastructure.DatastoreTierDto;
import com.abiquo.server.core.infrastructure.DatastoreTiersDto;
import com.abiquo.server.core.infrastructure.LocationDto;
import com.abiquo.server.core.infrastructure.MachineDto;
import com.abiquo.server.core.infrastructure.MachinesDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionsDto;
import com.abiquo.server.core.infrastructure.RackDto;
import com.abiquo.server.core.infrastructure.RacksDto;
import com.abiquo.server.core.infrastructure.RemoteServiceDto;
import com.abiquo.server.core.infrastructure.RemoteServicesDto;
import com.abiquo.server.core.infrastructure.network.IpsBulkCreationDto;
import com.abiquo.server.core.infrastructure.network.NetworkServiceTypeDto;
import com.abiquo.server.core.infrastructure.network.NetworkServiceTypesDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworkDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworksDto;
import com.abiquo.server.core.infrastructure.storage.StorageDeviceDto;
import com.abiquo.server.core.infrastructure.storage.StorageDevicesDto;
import com.abiquo.server.core.infrastructure.storage.StoragePoolDto;
import com.abiquo.server.core.infrastructure.storage.StoragePoolsDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.infrastructure.storage.TiersDto;
import com.abiquo.server.core.scheduler.DatastoreLoadRuleDto;
import com.abiquo.server.core.scheduler.MachineLoadRuleDto;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InfrastructureApi {
    private final RestClient client;

    InfrastructureApi(RestClient client) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
    }

    public Stream<DatacenterDto> listDatacenters() {
        return this.client.list("/admin/datacenters", "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Stream<DatacenterDto> listDatacenters(DatacenterListOptions options) {
        return this.client.list("/admin/datacenters", options.queryParams(), "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Stream<RackDto> listRacks(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("racks").getHref(), "application/vnd.abiquo.racks+json", RacksDto.class);
    }

    public Stream<DatacenterLimitsDto> listLimits(EnterpriseDto enterprise) {
        return this.client.list(enterprise.searchLink("limits"), DatacentersLimitsDto.class);
    }

    public DatacenterLimitsDto getEnterpriseLimitsForDatacenter(EnterpriseDto enterprise, DatacenterDto datacenter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("datacenter", datacenter.getId());
        return (DatacenterLimitsDto)this.client.get(enterprise.searchLink("limits").getHref(), params, "application/vnd.abiquo.limits+json", DatacentersLimitsDto.class).getCollection().get(0);
    }

    public Stream<VLANNetworkDto> listExternalNetworks(DatacenterLimitsDto limits) {
        return this.client.list(limits.searchLink("externalnetworks").getHref(), "application/vnd.abiquo.vlans+json", VLANNetworksDto.class);
    }

    public DatacenterDto createDatacenter(String name, String location, List<RemoteServiceDto> remoteServices) {
        DatacenterDto datacenter = new DatacenterDto();
        List existentRSs = this.listRemoteServices().collect(Collectors.toList());
        RemoteServicesDto remoteServicesDto = new RemoteServicesDto();
        remoteServicesDto.addAll(remoteServices);
        for (RemoteServiceDto rs : remoteServices) {
            Optional<RemoteServiceDto> exRS = existentRSs.stream().filter(remserv -> remserv.getType().equals((Object)rs.getType()) && remserv.getType().isReusable()).findFirst();
            if (!exRS.isPresent()) continue;
            datacenter.addLink(Links.withRel("remoteservice", Links.editOrSelf((SingleResourceTransportDto)exRS.get())));
            remoteServicesDto.getCollection().remove(rs);
        }
        datacenter.setName(name);
        datacenter.setLocation(location);
        datacenter.setRemoteServices(remoteServicesDto);
        return this.client.post("/admin/datacenters", "application/vnd.abiquo.datacenter+json", "application/vnd.abiquo.datacenter+json", (SingleResourceTransportDto)datacenter, DatacenterDto.class);
    }

    public PublicCloudRegionDto createPublicCloudRegion(String name, RegionDto region, List<RemoteServiceDto> remoteServices) {
        PublicCloudRegionDto publicCloudRegion = new PublicCloudRegionDto();
        List existentRSs = this.listRemoteServices().collect(Collectors.toList());
        RemoteServicesDto remoteServicesDto = new RemoteServicesDto();
        remoteServicesDto.addAll(remoteServices);
        for (RemoteServiceDto rs : remoteServices) {
            Optional<RemoteServiceDto> exRS = existentRSs.stream().filter(remserv -> remserv.getType().equals((Object)rs.getType())).findFirst();
            if (!exRS.isPresent()) continue;
            publicCloudRegion.addLink(Links.withRel("remoteservice", Links.editOrSelf((SingleResourceTransportDto)exRS.get())));
            remoteServicesDto.getCollection().remove(rs);
        }
        publicCloudRegion.setName(name);
        publicCloudRegion.setRemoteServices(remoteServicesDto);
        publicCloudRegion.addLink(Links.withRel("region", Links.editOrSelf((SingleResourceTransportDto)region)));
        return this.client.post("/admin/publiccloudregions", "application/vnd.abiquo.publiccloudregion+json", "application/vnd.abiquo.publiccloudregion+json", (SingleResourceTransportDto)publicCloudRegion, PublicCloudRegionDto.class);
    }

    public PublicCloudRegionDto createPublicCloudDynamicRegion(String name, RegionDto region, List<RemoteServiceDto> remoteServices, String identity, String credential, String endpoint) {
        PublicCloudRegionDto publicCloudRegion = new PublicCloudRegionDto();
        List existentRSs = this.listRemoteServices().collect(Collectors.toList());
        RemoteServicesDto remoteServicesDto = new RemoteServicesDto();
        remoteServicesDto.addAll(remoteServices);
        for (RemoteServiceDto rs : remoteServices) {
            Optional<RemoteServiceDto> exRS = existentRSs.stream().filter(remserv -> remserv.getType().equals((Object)rs.getType())).findFirst();
            if (!exRS.isPresent()) continue;
            publicCloudRegion.addLink(Links.withRel("remoteservice", Links.editOrSelf((SingleResourceTransportDto)exRS.get())));
            remoteServicesDto.getCollection().remove(rs);
        }
        publicCloudRegion.setName(name);
        publicCloudRegion.setRemoteServices(remoteServicesDto);
        publicCloudRegion.addLink(Links.withRel("region", Links.editOrSelf((SingleResourceTransportDto)region)));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Abiquo-PCR-Identity", identity);
        headers.put("X-Abiquo-PCR-Credential", credential);
        headers.put("X-Abiquo-PCR-Endpoint", endpoint);
        return this.client.post("/admin/publiccloudregions", "application/vnd.abiquo.publiccloudregion+json", "application/vnd.abiquo.publiccloudregion+json", (SingleResourceTransportDto)publicCloudRegion, PublicCloudRegionDto.class, headers);
    }

    public Stream<RemoteServiceDto> listRemoteServices(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("remoteservices"), RemoteServicesDto.class);
    }

    public Stream<RemoteServiceDto> listRemoteServices() {
        return this.client.list("/admin/remoteservices", "application/vnd.abiquo.remoteservices+json", RemoteServicesDto.class);
    }

    public RackDto createRack(DatacenterDto datacenter, String name) {
        RackDto rack = new RackDto();
        rack.setName(name);
        return this.client.post(datacenter.searchLink("racks").getHref(), "application/vnd.abiquo.rack+json", "application/vnd.abiquo.rack+json", (SingleResourceTransportDto)rack, RackDto.class);
    }

    @Deprecated
    public void addDatacenterToEnterprise(EnterpriseDto enterprise, DatacenterDto datacenter) {
        this.addLocationToEnterprise(enterprise, (LocationDto)datacenter);
    }

    @Deprecated
    public void addPublicCloudRegionToEnterprise(EnterpriseDto enterprise, PublicCloudRegionDto pcr) {
        this.addLocationToEnterprise(enterprise, (LocationDto)pcr);
    }

    public DatacenterLimitsDto addLocationToEnterprise(EnterpriseDto enterprise, LocationDto location) {
        RESTLink editlink = location.getEditLink();
        DatacenterLimitsDto limits = new DatacenterLimitsDto();
        limits.addLink(Links.create("location", editlink.getHref(), editlink.getType()));
        return this.client.post(enterprise.searchLink("limits").getHref(), "application/vnd.abiquo.limit+json", "application/vnd.abiquo.limit+json", (SingleResourceTransportDto)limits, DatacenterLimitsDto.class);
    }

    public MachinesDto discoverMachines(DatacenterDto datacenter, String type, String ip, String user, String password) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("hypervisor", type);
        queryParams.put("ip", ip);
        queryParams.put("user", user);
        queryParams.put("password", password);
        return this.client.get(datacenter.searchLink("discover").getHref(), queryParams, "application/vnd.abiquo.machines+json", MachinesDto.class);
    }

    public MachinesDto discoverManagedMachines(DatacenterDto datacenter, String type, String ip, String managerIp, String managerUser, String managerPassword) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("hypervisor", type);
        queryParams.put("ip", ip);
        queryParams.put("managerip", managerIp);
        queryParams.put("manageruser", managerUser);
        queryParams.put("managerpassword", managerPassword);
        return this.client.get(datacenter.searchLink("discover").getHref(), queryParams, "application/vnd.abiquo.machines+json", MachinesDto.class);
    }

    public MachineDto createMachine(RackDto rack, MachineDto machine) {
        return this.client.post(rack.searchLink("machines").getHref(), "application/vnd.abiquo.machine+json", "application/vnd.abiquo.machine+json", (SingleResourceTransportDto)machine, MachineDto.class);
    }

    public Stream<NetworkServiceTypeDto> listNetworkServiceTypes(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("networkservicetypes").getHref(), "application/vnd.abiquo.networkservicetypes+json", NetworkServiceTypesDto.class);
    }

    public MachineLoadRuleDto createDatacenterLoadLevelRule(DatacenterDto datacenter, int cpuLoadPercentage, int ramLoadPercentage) {
        return this.createLoadLevelRule(Links.create("datacenter", datacenter.getEditLink().getHref(), datacenter.getEditLink().getType()), cpuLoadPercentage, ramLoadPercentage);
    }

    public MachineLoadRuleDto createRackLoadLevelRule(RackDto rack, int cpuLoadPercentage, int ramLoadPercentage) {
        return this.createLoadLevelRule(Links.create("rack", rack.getEditLink().getHref(), rack.getEditLink().getType()), cpuLoadPercentage, ramLoadPercentage);
    }

    public MachineLoadRuleDto createMachineLoadLevelRule(MachineDto machine, int cpuLoadPercentage, int ramLoadPercentage) {
        return this.createLoadLevelRule(Links.create("machine", machine.getEditLink().getHref(), machine.getEditLink().getType()), cpuLoadPercentage, ramLoadPercentage);
    }

    private MachineLoadRuleDto createLoadLevelRule(RESTLink targetLink, int cpuLoadPercentage, int ramLoadPercentage) {
        MachineLoadRuleDto rule = new MachineLoadRuleDto();
        rule.setCpuLoadPercentage(Integer.valueOf(cpuLoadPercentage));
        rule.setRamLoadPercentage(Integer.valueOf(ramLoadPercentage));
        rule.addLink(targetLink);
        return this.client.post("/admin/rules/machineLoadLevel", "application/vnd.abiquo.machineloadrule+json", "application/vnd.abiquo.machineloadrule+json", (SingleResourceTransportDto)rule, MachineLoadRuleDto.class);
    }

    public DatastoreLoadRuleDto createDatacenterLoadLevelStorageRule(DatacenterDto datacenter, int storageLoadPercentage) {
        return this.createLoadLevelRule(Links.create("datacenter", datacenter.getEditLink().getHref(), datacenter.getEditLink().getType()), storageLoadPercentage);
    }

    public DatastoreLoadRuleDto createDatastoreTierLoadLevelStorageRule(DatastoreTierDto datastoreTier, int storageLoadPercentage) {
        return this.createLoadLevelRule(Links.create("datastoretier", datastoreTier.getEditLink().getHref(), datastoreTier.getEditLink().getType()), storageLoadPercentage);
    }

    public DatastoreLoadRuleDto createDatastoreLoadLevelStorageRule(DatastoreDto datastore, int storageLoadPercentage) {
        return this.createLoadLevelRule(Links.create("datastore", datastore.getEditLink().getHref(), datastore.getEditLink().getType()), storageLoadPercentage);
    }

    private DatastoreLoadRuleDto createLoadLevelRule(RESTLink targetLink, int storageLoadPercentage) {
        DatastoreLoadRuleDto rule = new DatastoreLoadRuleDto();
        rule.setStorageLoadPercentage(Integer.valueOf(storageLoadPercentage));
        rule.addLink(targetLink);
        return this.client.post("/admin/rules/datastoreloadlevel", "application/vnd.abiquo.datastoreloadrule+json", "application/vnd.abiquo.datastoreloadrule+json", (SingleResourceTransportDto)rule, DatastoreLoadRuleDto.class);
    }

    public Stream<StorageDeviceDto> listDevices(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("devices").getHref(), "application/vnd.abiquo.storagedevices+json", StorageDevicesDto.class);
    }

    public Stream<StoragePoolDto> listPools(StorageDeviceDto device) {
        return this.client.list(device.searchLink("pools").getHref(), "application/vnd.abiquo.storagepools+json", StoragePoolsDto.class);
    }

    public Stream<StoragePoolDto> listRemotePools(StorageDeviceDto device) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("sync", true);
        return this.client.list(device.searchLink("pools").getHref(), queryParams, "application/vnd.abiquo.storagepools+json", StoragePoolsDto.class);
    }

    public StorageDeviceDto createStorageDevice(DatacenterDto datacenter, String name, String technology, String managementIp, int managementPort, String serviceIp, int servicePort, String username, String password) {
        StorageDeviceDto device = new StorageDeviceDto();
        device.addLink(Links.create("datacenter", datacenter.getEditLink().getHref(), datacenter.getEditLink().getType()));
        device.setName(name);
        device.setStorageTechnology(technology);
        device.setManagementIp(managementIp);
        device.setManagementPort(managementPort);
        device.setServiceIp(serviceIp);
        device.setServicePort(servicePort);
        device.setUsername(username);
        device.setPassword(password);
        return this.client.post(datacenter.searchLink("devices").getHref(), "application/vnd.abiquo.storagedevice+json", "application/vnd.abiquo.storagedevice+json", (SingleResourceTransportDto)device, StorageDeviceDto.class);
    }

    public StoragePoolDto createPool(DatacenterDto datacenter, StorageDeviceDto storageDevice, String pool, String tierName) {
        StoragePoolDto storagePool = this.listRemotePools(storageDevice).filter(stPool -> stPool.getName().equals(pool)).findFirst().orElseThrow(() -> new HttpException(404, "Storage pool not found"));
        TierDto tier = this.listTiers(datacenter).filter(t -> t.getName().equals(tierName)).findFirst().orElseThrow(() -> new HttpException(404, "Tier not found"));
        storagePool.setEnabled(true);
        storagePool.addLink(Links.create("tier", tier.getEditLink().getHref(), tier.getEditLink().getType()));
        return this.client.post(storageDevice.searchLink("pools").getHref(), "application/vnd.abiquo.storagepool+json", "application/vnd.abiquo.storagepool+json", (SingleResourceTransportDto)storagePool, StoragePoolDto.class);
    }

    public VLANNetworkDto createExternalNetwork(DatacenterDto datacenter, NetworkServiceTypeDto nst, EnterpriseDto enterprise, String name, String address, String gateway, int mask, int tag, Optional<DeviceDto> optDevice) {
        return this.createInfrastructureNetwork(datacenter, nst, enterprise, name, address, gateway, mask, tag, optDevice, NetworkType.EXTERNAL);
    }

    public VLANNetworkDto createUnmanagedNetwork(DatacenterDto datacenter, NetworkServiceTypeDto nst, EnterpriseDto enterprise, String name, String address, String gateway, int mask, int tag, Optional<DeviceDto> optDevice) {
        return this.createInfrastructureNetwork(datacenter, nst, enterprise, name, address, gateway, mask, tag, optDevice, NetworkType.UNMANAGED);
    }

    private VLANNetworkDto createInfrastructureNetwork(DatacenterDto datacenter, NetworkServiceTypeDto nst, EnterpriseDto enterprise, String name, String address, String gateway, int mask, int tag, Optional<DeviceDto> optDevice, NetworkType type) {
        VLANNetworkDto vlan = new VLANNetworkDto();
        vlan.addLink(Links.create("enterprise", enterprise.getEditLink().getHref(), enterprise.getEditLink().getType()));
        vlan.addLink(Links.create("networkservicetype", nst.getEditLink().getHref(), nst.getEditLink().getType()));
        vlan.setAddress(address);
        vlan.setName(name);
        vlan.setType(type);
        vlan.setMask(Integer.valueOf(mask));
        vlan.setTag(Integer.valueOf(tag));
        vlan.setGateway(gateway);
        vlan.setUnmanaged(Boolean.valueOf(NetworkType.UNMANAGED == type));
        String url = datacenter.searchLink("network").getHref();
        if (optDevice.isPresent()) {
            RESTLink deviceEdit = optDevice.get().getEditLink();
            vlan.addLink(Links.create("device", deviceEdit.getHref(), deviceEdit.getType()));
        }
        return this.client.post(url, "application/vnd.abiquo.vlan+json", "application/vnd.abiquo.vlan+json", (SingleResourceTransportDto)vlan, VLANNetworkDto.class);
    }

    public Stream<TierDto> listTiers(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("tiers").getHref(), "application/vnd.abiquo.tiers+json", TiersDto.class);
    }

    public Stream<PublicCloudRegionDto> listPublicCloudRegions(PublicCloudRegionListOptions options) {
        return this.client.list("/admin/publiccloudregions", options.queryParams(), "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Stream<PublicCloudRegionDto> listPublicCloudRegions() {
        return this.client.list("/admin/publiccloudregions", "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Stream<MachineDto> listMachines(RackDto rack) {
        return this.client.list(rack.searchLink("machines").getHref(), "application/vnd.abiquo.machines+json", MachinesDto.class);
    }

    public Stream<VirtualMachineDto> listInfrastructureVirtualMachines(MachineDto machine) {
        return this.client.list(machine.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public Stream<VirtualMachineDto> listInfrastructureVirtualMachines(MachineDto machine, VirtualMachineInfrastructureListOptions options) {
        return this.client.list(machine.searchLink("virtualmachines").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public VirtualMachineFlatDto getVirtualMachineFlat(VirtualMachineDto vm, VirtualMachineInfrastructureListOptions options) {
        return this.client.get(vm.searchLink("virtualmachine").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachineflat+json", VirtualMachineFlatDto.class);
    }

    public Stream<ClusterDto> listClusters(RackDto rack) {
        return this.client.list(rack.searchLink("clusters").getHref(), "application/vnd.abiquo.clusters+json", ClustersDto.class);
    }

    public DeviceDto createDevice(DatacenterDto dc, DeviceTypeDto deviceType, String name, String endpoint, String user, String password, boolean vdcDefault) {
        DeviceDto device = new DeviceDto();
        device.addLink(Links.withRel("devicetype", Links.editOrSelf((SingleResourceTransportDto)deviceType)));
        device.setName(name);
        device.setEndpoint(endpoint);
        device.setUser(user);
        device.setPassword(password);
        device.setVdcDefault(vdcDefault);
        return this.client.post(dc.searchLink("devices", "devices").getHref(), "application/vnd.abiquo.device+json", "application/vnd.abiquo.device+json", (SingleResourceTransportDto)device, DeviceDto.class);
    }

    public NatNetworkDto createNatNetwork(DatacenterDto dc, String name, String cidr, DeviceDto device) {
        NatNetworkDto nat = new NatNetworkDto();
        nat.setName(name);
        nat.setCidr(cidr);
        nat.addLink(Links.create("device", device.getEditLink().getHref(), device.getEditLink().getType()));
        return this.client.post(dc.searchLink("natnetworks").getHref(), "application/vnd.abiquo.natnetwork+json", "application/vnd.abiquo.natnetwork+json", (SingleResourceTransportDto)nat, NatNetworkDto.class);
    }

    public Stream<NatNetworkDto> listNatNetworks(DatacenterDto dc) {
        return this.client.list(dc.searchLink("natnetworks").getHref(), "application/vnd.abiquo.natnetworks+json", NatNetworksDto.class);
    }

    public NatNetworkDto editNatNetwork(NatNetworkDto natNw) {
        return this.client.edit(natNw);
    }

    public void deleteNatNetwork(NatNetworkDto natNw) {
        this.client.delete((SingleResourceTransportDto)natNw);
    }

    public RoleDto createRole(String name, boolean blocked, String ... externalRoles) {
        RoleDto role = new RoleDto();
        Arrays.stream(externalRoles).forEach(role.getExternalRoles()::add);
        role.setName(name);
        role.setBlocked(blocked);
        return this.client.post("/admin/roles", "application/vnd.abiquo.role+json", "application/vnd.abiquo.role+json", (SingleResourceTransportDto)role, RoleDto.class);
    }

    public Stream<RoleDto> listRoles() {
        return this.client.list("/admin/roles", "application/vnd.abiquo.roles+json", RolesDto.class);
    }

    public void deleteRole(RoleDto role) {
        this.client.delete((SingleResourceTransportDto)role);
    }

    public RoleDto getRole(int roleId) {
        return this.client.get("/admin/roles/" + roleId, "application/vnd.abiquo.role+json", RoleDto.class);
    }

    public RoleDto editRole(RoleDto role) {
        return this.client.edit(role);
    }

    public LinksDto listPrivilegeLinksOfARole(RoleDto role) {
        return this.client.get(role.searchLink("privileges").getHref(), "application/vnd.abiquo.links+json", LinksDto.class);
    }

    public Stream<PrivilegeDto> listPrivilegesOfARole(RoleDto role) {
        return this.client.list(role.searchLink("privileges").getHref(), "application/vnd.abiquo.privileges+json", PrivilegesDto.class);
    }

    public NatIpDto createNatIp(NatNetworkDto natNetwork, String ip) {
        NatIpDto natIP = new NatIpDto();
        natIP.setIp(ip);
        return this.client.post(natNetwork.searchLink("ips").getHref(), "application/vnd.abiquo.natip+json", "application/vnd.abiquo.natip+json", (SingleResourceTransportDto)natIP, NatIpDto.class);
    }

    public IpsBulkCreationDto createMultipleNatIps(NatNetworkDto natNetwork, String startingIP, int numips) {
        IpsBulkCreationDto natIPs = new IpsBulkCreationDto();
        natIPs.setIp(startingIP);
        natIPs.setNumips(numips);
        return this.client.post(natNetwork.searchLink("ips").getHref(), "application/vnd.abiquo.natips+json", "application/vnd.abiquo.ipsbulkcreation+json", (SingleResourceTransportDto)natIPs, IpsBulkCreationDto.class);
    }

    public Stream<NatIpDto> listNatIPs(NatNetworkDto natNw) {
        return this.client.list(natNw.searchLink("ips").getHref(), "application/vnd.abiquo.natips+json", NatIpsDto.class);
    }

    public Stream<NatIpDto> listNatIPs(NatNetworkDto natNw, NatIPsListOptions options) {
        return this.client.list(natNw.searchLink("ips").getHref(), options.queryParams(), "application/vnd.abiquo.natips+json", NatIpsDto.class);
    }

    public void deleteNatIp(NatIpDto natIP) {
        this.client.delete((SingleResourceTransportDto)natIP);
    }

    public HardwareProfileDto createHardwareProfile(DatacenterDto datacenter, HardwareProfileDto hardwareProfile) {
        return this.client.post(datacenter.searchLink("hardwareprofiles").getHref(), "application/vnd.abiquo.hardwareprofile+json", "application/vnd.abiquo.hardwareprofile+json", (SingleResourceTransportDto)hardwareProfile, HardwareProfileDto.class);
    }

    public Stream<HardwareProfileDto> listHardwareProfiles(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("hardwareprofiles"), HardwareProfilesDto.class);
    }

    public Stream<DatastoreTierDto> listDatastoreTiers(DatacenterDto datacenter) {
        return this.client.list(datacenter.searchLink("datastoretiers"), DatastoreTiersDto.class);
    }
}

