/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.auth;

import static java.util.Objects.requireNonNull;

import com.google.common.net.HttpHeaders;
import com.squareup.okhttp.Request;

/**
 * Token based Authentication.
 *
 * @author Ignasi Barrera
 */
public class TokenAuthentication implements Authentication
{
    /**
     * Name of the header in the HTTP responses that carries the renewed authentication token.
     */
    public static final String AUTH_HEADER = "X-Abiquo-Token";

    private final String token;

    // Use the static factory method
    private TokenAuthentication(final String token)
    {
        this.token = requireNonNull(token, "token cannot be null");
    }

    public static TokenAuthentication token(final String token)
    {
        return new TokenAuthentication(token);
    }

    @Override
    public Request authenticate(final Request unauthenticated)
    {
        return unauthenticated.newBuilder().addHeader(HttpHeaders.AUTHORIZATION, "Token " + token)
            .build();
    }

}
