/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.domain.exception;

import java.util.function.Predicate;

import com.abiquo.model.transport.error.ErrorDto;
import com.abiquo.model.transport.error.ErrorsDto;

public class AbiquoException extends HttpException
{
    private static final long serialVersionUID = 3417635717730170489L;

    private final ErrorsDto errors;

    public AbiquoException(final int code, final ErrorDto error)
    {
        super(code, error.toString());
        this.errors = new ErrorsDto();
        this.errors.add(error);
    }

    public AbiquoException(final int code, final ErrorsDto errors)
    {
        super(code, errors.toString());
        this.errors = errors;
    }

    public ErrorsDto getErrors()
    {
        return errors;
    }

    public boolean hasError(final String code)
    {
        return errors.getCollection().stream().anyMatch(sameCode(code));
    }

    public ErrorDto getError(final String code)
    {
        return errors.getCollection().stream().filter(sameCode(code)).findFirst()
            .orElseThrow(() -> new HttpException(404, "Error with code " + code + "not found"));
    }

    public ErrorDto firstError()
    {
        return errors.getCollection().get(0);
    }

    private static Predicate<ErrorDto> sameCode(final String code)
    {
        return new Predicate<ErrorDto>()
        {
            @Override
            public boolean test(final ErrorDto input)
            {
                return input.getCode().equals(code);
            }
        };
    }
}
