/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.ApiClient;
import com.abiquo.apiclient.AsyncTaskUtils;
import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.Links;
import com.abiquo.apiclient.domain.exception.AsyncTaskFailedException;
import com.abiquo.apiclient.domain.options.AllowedDatacenterListOptions;
import com.abiquo.apiclient.domain.options.AllowedPublicCloudRegionListOptions;
import com.abiquo.apiclient.domain.options.EventListOptions;
import com.abiquo.apiclient.domain.options.ExternalIpListOptions;
import com.abiquo.apiclient.domain.options.ListOptions;
import com.abiquo.apiclient.domain.options.VirtualApplianceListOptions;
import com.abiquo.apiclient.domain.options.VirtualDatacenterListOptions;
import com.abiquo.apiclient.domain.options.VirtualMachineListOptions;
import com.abiquo.model.enumerator.NetworkType;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.AcceptedRequestDto;
import com.abiquo.model.transport.LinksDto;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.appslibrary.VirtualMachineTemplateDto;
import com.abiquo.server.core.asynctask.AsyncTaskDto;
import com.abiquo.server.core.cloud.AddressRangesDto;
import com.abiquo.server.core.cloud.AvailabilitySetDto;
import com.abiquo.server.core.cloud.AvailabilityZoneDto;
import com.abiquo.server.core.cloud.AvailabilityZonesDto;
import com.abiquo.server.core.cloud.DeviceDto;
import com.abiquo.server.core.cloud.DevicesDto;
import com.abiquo.server.core.cloud.FirewallPoliciesDto;
import com.abiquo.server.core.cloud.FirewallPolicyDto;
import com.abiquo.server.core.cloud.FirewallRulesDto;
import com.abiquo.server.core.cloud.HardwareProfileDto;
import com.abiquo.server.core.cloud.HealthCheckDto;
import com.abiquo.server.core.cloud.HealthChecksDto;
import com.abiquo.server.core.cloud.HypervisorTypeDto;
import com.abiquo.server.core.cloud.IPSecVPNDto;
import com.abiquo.server.core.cloud.IPSecVPNsDto;
import com.abiquo.server.core.cloud.LoadBalancerAddressDto;
import com.abiquo.server.core.cloud.LoadBalancerAddressesDto;
import com.abiquo.server.core.cloud.LoadBalancerDto;
import com.abiquo.server.core.cloud.LoadBalancersDto;
import com.abiquo.server.core.cloud.NatIpDto;
import com.abiquo.server.core.cloud.NatIpsDto;
import com.abiquo.server.core.cloud.NatNetworkDto;
import com.abiquo.server.core.cloud.NatNetworksDto;
import com.abiquo.server.core.cloud.RegionDto;
import com.abiquo.server.core.cloud.RoutingRuleDto;
import com.abiquo.server.core.cloud.RoutingRulesDto;
import com.abiquo.server.core.cloud.SSLCertificateDto;
import com.abiquo.server.core.cloud.SyncVirtualDatacenterDto;
import com.abiquo.server.core.cloud.VPNTunnelStatusDto;
import com.abiquo.server.core.cloud.VirtualApplianceDto;
import com.abiquo.server.core.cloud.VirtualApplianceState;
import com.abiquo.server.core.cloud.VirtualAppliancesDto;
import com.abiquo.server.core.cloud.VirtualDatacenterDto;
import com.abiquo.server.core.cloud.VirtualDatacentersDto;
import com.abiquo.server.core.cloud.VirtualMachineDto;
import com.abiquo.server.core.cloud.VirtualMachineState;
import com.abiquo.server.core.cloud.VirtualMachineStateDto;
import com.abiquo.server.core.cloud.VirtualMachineTaskDto;
import com.abiquo.server.core.cloud.VirtualMachinesDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlanDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlanFlatDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlansDto;
import com.abiquo.server.core.cloud.actionplan.ActionPlansFlatDto;
import com.abiquo.server.core.cloud.loadbalancer.ConditionalActionDto;
import com.abiquo.server.core.cloud.loadbalancer.ConditionalActionsDto;
import com.abiquo.server.core.cloud.loadbalancer.TargetDto;
import com.abiquo.server.core.cloud.loadbalancer.TargetGroupDto;
import com.abiquo.server.core.cloud.loadbalancer.TargetGroupsDto;
import com.abiquo.server.core.cloud.loadbalancer.TargetsDto;
import com.abiquo.server.core.cloud.resourcegroup.ResourceGroupDto;
import com.abiquo.server.core.cloud.resourcegroup.ResourceGroupsDto;
import com.abiquo.server.core.enterprise.EnterpriseDto;
import com.abiquo.server.core.event.EventDto;
import com.abiquo.server.core.event.EventsDto;
import com.abiquo.server.core.infrastructure.DatacenterDto;
import com.abiquo.server.core.infrastructure.DatacentersDto;
import com.abiquo.server.core.infrastructure.LocationDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionDto;
import com.abiquo.server.core.infrastructure.PublicCloudRegionsDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpDto;
import com.abiquo.server.core.infrastructure.network.ExternalIpsDto;
import com.abiquo.server.core.infrastructure.network.GlobalNetworkDto;
import com.abiquo.server.core.infrastructure.network.GlobalNetworksDto;
import com.abiquo.server.core.infrastructure.network.GlobalSubnetDto;
import com.abiquo.server.core.infrastructure.network.GlobalSubnetsDto;
import com.abiquo.server.core.infrastructure.network.IpsBulkCreationDto;
import com.abiquo.server.core.infrastructure.network.NicsDto;
import com.abiquo.server.core.infrastructure.network.PublicIpDto;
import com.abiquo.server.core.infrastructure.network.PublicIpsDto;
import com.abiquo.server.core.infrastructure.network.VLANNetworkDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationDto;
import com.abiquo.server.core.infrastructure.network.VMNetworkConfigurationsDto;
import com.abiquo.server.core.infrastructure.storage.DiskManagementDto;
import com.abiquo.server.core.infrastructure.storage.DisksManagementDto;
import com.abiquo.server.core.infrastructure.storage.TierDto;
import com.abiquo.server.core.infrastructure.storage.TiersDto;
import com.abiquo.server.core.infrastructure.storage.VolumeManagementDto;
import com.abiquo.server.core.infrastructure.storage.VolumesManagementDto;
import com.abiquo.server.core.task.TaskDto;
import com.abiquo.server.core.task.TaskState;
import com.abiquo.server.core.task.TasksDto;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CloudApi {
    private final RestClient client;

    CloudApi(RestClient client) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
    }

    public VirtualDatacenterDto getVirtualDatacenter(int id) {
        return this.client.get("/cloud/virtualdatacenters/" + id, "application/vnd.abiquo.virtualdatacenter+json", VirtualDatacenterDto.class);
    }

    public VirtualDatacenterDto editVirtualDatacenter(VirtualDatacenterDto vdc) {
        return this.client.edit(vdc);
    }

    public Stream<DatacenterDto> listAllowedDatacenters() {
        return this.client.list("/cloud/locations", "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Stream<DatacenterDto> listAllowedDatacenters(AllowedDatacenterListOptions options) {
        return this.client.list("/cloud/locations", options.queryParams(), "application/vnd.abiquo.datacenters+json", DatacentersDto.class);
    }

    public Stream<EventDto> listEvents() {
        return this.client.list("/events", "application/vnd.abiquo.events+json", EventsDto.class);
    }

    public Stream<EventDto> listEvents(EventListOptions options) {
        return this.client.list("/events", options.queryParams(), "application/vnd.abiquo.events+json", EventsDto.class);
    }

    public Stream<PublicCloudRegionDto> listAllowedPublicCloudRegions() {
        return this.client.list("/cloud/locations", "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Stream<PublicCloudRegionDto> listAllowedPublicCloudRegions(AllowedPublicCloudRegionListOptions options) {
        return this.client.list("/cloud/locations", options.queryParams(), "application/vnd.abiquo.publiccloudregions+json", PublicCloudRegionsDto.class);
    }

    public Stream<AvailabilityZoneDto> listAvailabiltyZones(PublicCloudRegionDto pcrLocation) {
        RESTLink restLink = pcrLocation.searchLink("availabilityzones");
        if (restLink == null) {
            return Stream.empty();
        }
        return this.client.list(restLink.getHref(), "application/vnd.abiquo.availabilityzones+json", AvailabilityZonesDto.class);
    }

    public Stream<VirtualDatacenterDto> listVirtualDatacenters() {
        return this.client.list("/cloud/virtualdatacenters", "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Stream<VirtualDatacenterDto> listVirtualDatacenters(VirtualDatacenterListOptions options) {
        return this.client.list("/cloud/virtualdatacenters", options.queryParams(), "application/vnd.abiquo.virtualdatacenters+json", VirtualDatacentersDto.class);
    }

    public Stream<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("externalips").getHref(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Stream<ExternalIpDto> listExternalIps(VirtualDatacenterDto vdc, ExternalIpListOptions options) {
        return this.client.list(vdc.searchLink("externalips").getHref(), options.queryParams(), "application/vnd.abiquo.externalips+json", ExternalIpsDto.class);
    }

    public Stream<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public Stream<VirtualApplianceDto> listVirtualAppliances(VirtualDatacenterDto vdc, VirtualApplianceListOptions options) {
        return this.client.list(vdc.searchLink("virtualappliances").getHref(), options.queryParams(), "application/vnd.abiquo.virtualappliances+json", VirtualAppliancesDto.class);
    }

    public VirtualApplianceDto getVirtualAppliance(int idVdc, int idVapp) {
        return this.client.get(String.format("%s/%s/virtualappliances/%s", "/cloud/virtualdatacenters", idVdc, idVapp), "application/vnd.abiquo.virtualappliance+json", VirtualApplianceDto.class);
    }

    public Stream<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public Stream<VirtualMachineDto> listVirtualMachines(VirtualApplianceDto vapp, VirtualMachineListOptions options) {
        return this.client.list(vapp.searchLink("virtualmachines").getHref(), options.queryParams(), "application/vnd.abiquo.virtualmachines+json", VirtualMachinesDto.class);
    }

    public VLANNetworkDto getPrivateNetwork(VirtualDatacenterDto vdc, int idNetwork) {
        return this.client.get(vdc.searchLink("privatenetworks").getHref() + "/" + idNetwork, "application/vnd.abiquo.vlan+json", VLANNetworkDto.class);
    }

    public VLANNetworkDto createPrivateNetwork(VirtualDatacenterDto vdc, VLANNetworkDto privateNetwork) {
        return this.client.post(vdc.searchLink("privatenetworks").getHref(), "application/vnd.abiquo.vlan+json", "application/vnd.abiquo.vlan+json", (SingleResourceTransportDto)privateNetwork, VLANNetworkDto.class);
    }

    public Stream<VMNetworkConfigurationDto> listNetworkConfigurations(VirtualMachineDto vm) {
        return this.client.list(vm.searchLink("configurations").getHref(), "application/vnd.abiquo.virtualmachinenetworkconfigurations+json", VMNetworkConfigurationsDto.class);
    }

    public VirtualMachineDto getVirtualMachine(VirtualApplianceDto vapp, int idVm) {
        return this.client.get(vapp.searchLink("virtualmachines").getHref() + "/" + idVm, "application/vnd.abiquo.virtualmachine+json", VirtualMachineDto.class);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, String vlanAddress, String vlanGateway, String vlanName, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        VLANNetworkDto vlan = new VLANNetworkDto();
        vlan.setAddress(vlanAddress);
        vlan.setGateway(vlanGateway);
        vlan.setMask(Integer.valueOf(24));
        vlan.setName(vlanName);
        vlan.setType(NetworkType.INTERNAL);
        return this.createVirtualDatacenter(location, enterprise, name, type, vlan, pollInterval, maxWait, timeUnit);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, VLANNetworkDto vlan, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        return this.createVirtualDatacenter(location, enterprise, name, type, vlan, Optional.empty(), pollInterval, maxWait, timeUnit);
    }

    public VirtualDatacenterDto createVirtualDatacenter(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, VLANNetworkDto vlan, Optional<AddressRangesDto> addressRanges, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        return this.createVirtualDatacenterWithResourceGroup(location, enterprise, name, type, vlan, addressRanges, null, pollInterval, maxWait, timeUnit);
    }

    public VirtualDatacenterDto createVirtualDatacenterWithResourceGroup(SingleResourceTransportDto location, EnterpriseDto enterprise, String name, String type, VLANNetworkDto vlan, Optional<AddressRangesDto> addressRanges, ResourceGroupDto resourceGroup, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        Preconditions.checkArgument((location instanceof DatacenterDto || location instanceof PublicCloudRegionDto ? 1 : 0) != 0);
        String mt = location instanceof DatacenterDto ? "application/vnd.abiquo.datacenter+json" : "application/vnd.abiquo.publiccloudregion+json";
        VirtualDatacenterDto vdc = new VirtualDatacenterDto();
        vdc.setName(name);
        vdc.setHypervisorType(type);
        vdc.setVlan(vlan);
        addressRanges.ifPresent(arg_0 -> ((VirtualDatacenterDto)vdc).setAddressRanges(arg_0));
        vdc.addLink(Links.create("enterprise", enterprise.getEditLink().getHref(), "application/vnd.abiquo.enterprise+json"));
        RESTLink locationLink = Optional.ofNullable(location.searchLink("location")).orElseGet(() -> location.searchLink("self"));
        vdc.addLink(Links.create("location", locationLink.getHref(), mt, "datacenter"));
        this.addResourceGroupLink((SingleResourceTransportDto)vdc, resourceGroup);
        AsyncTaskDto task = this.client.post("/cloud/virtualdatacenters", "application/vnd.abiquo.asynctask+json", "application/vnd.abiquo.virtualdatacenter+json", (SingleResourceTransportDto)vdc, AsyncTaskDto.class);
        task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task)) {
            throw new AsyncTaskFailedException(task);
        }
        return this.client.get(task.searchLink("owner"), VirtualDatacenterDto.class);
    }

    public void deleteVirtualDatacenter(SingleResourceTransportDto vdc, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        AsyncTaskDto task = this.client.delete(vdc, "application/vnd.abiquo.asynctask+json", AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
    }

    public PublicIpDto createPublicIp(PublicCloudRegionDto location) {
        return this.createPublicIp(location, new PublicIpDto());
    }

    public PublicIpDto createPublicIp(PublicCloudRegionDto location, ResourceGroupDto resourceGroup) {
        PublicIpDto ip = new PublicIpDto();
        this.addResourceGroupLink((SingleResourceTransportDto)ip, resourceGroup);
        return this.createPublicIp(location, ip);
    }

    public PublicIpDto createPublicIp(PublicCloudRegionDto location, String floatingIpType) {
        PublicIpDto publicIpDto = new PublicIpDto();
        publicIpDto.setFloatingIpType(floatingIpType);
        return this.createPublicIp(location, publicIpDto);
    }

    public PublicIpDto createPublicIp(PublicCloudRegionDto location, PublicIpDto publicIpDto) {
        return this.client.post(location.searchLink("ips").getHref(), "application/vnd.abiquo.publicip+json", "application/vnd.abiquo.publicip+json", (SingleResourceTransportDto)publicIpDto, PublicIpDto.class);
    }

    public void createMultipleIPsExternalNetwork(VLANNetworkDto extNetDto, String starterIP, int nIPs) {
        IpsBulkCreationDto ipsConf = new IpsBulkCreationDto();
        ipsConf.setIp(starterIP);
        ipsConf.setAvailable(true);
        ipsConf.setNumips(nIPs);
        this.client.post(extNetDto.searchLink("ips").getHref(), "application/vnd.abiquo.externalips+json", "application/vnd.abiquo.ipsbulkcreation+json", (SingleResourceTransportDto)ipsConf, ExternalIpsDto.class);
    }

    public PublicIpDto addPublicIpToVirtualDatacenter(PublicIpDto publicip, VirtualDatacenterDto vdc) {
        return this.client.put(vdc.searchLink("purchased").getHref() + "/" + publicip.getId(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public PublicIpDto releasePublicIpFromVirtualDatacenter(PublicIpDto publicip, VirtualDatacenterDto vdc) {
        return this.client.put(vdc.searchLink("topurchase").getHref() + "/" + publicip.getId(), "application/vnd.abiquo.publicip+json", PublicIpDto.class);
    }

    public VirtualMachineDto assignPublicIpToVirtualMachine(PublicIpDto ip, VirtualDatacenterDto vdc, VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        int nics = (int)vm.getLinks().stream().filter(Links.isNic()).count();
        RESTLink nicLink = Links.create("nic" + nics, vdc.searchLink("purchased").getHref() + "/" + ip.getId(), "application/vnd.abiquo.publicip+json");
        vm.addLink(nicLink);
        return this.editVirtualMachineCheckTask(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto assignAvailabilitySetToVirtualMachine(AvailabilitySetDto availabilitySet, VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        vm.modifyLink("availabilityset", availabilitySet.getEditLink().getHref());
        return this.editVirtualMachineCheckTask(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto createVirtualAppliance(VirtualDatacenterDto vdc, String name) {
        VirtualApplianceDto vapp = new VirtualApplianceDto();
        vapp.setName(name);
        return this.client.post(vdc.searchLink("virtualappliances").getHref(), "application/vnd.abiquo.virtualappliance+json", "application/vnd.abiquo.virtualappliance+json", (SingleResourceTransportDto)vapp, VirtualApplianceDto.class);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineDto vm, VirtualApplianceDto vapp) {
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.addLink(Links.withRel("virtualmachinetemplate", template.getEditLink()));
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    private VirtualMachineDto createVirtualMachineWithOtherRelations(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, Optional<FirewallPolicyDto> fw, Optional<HardwareProfileDto> hp, Optional<AvailabilitySetDto> availabiltySet, String name, ResourceGroupDto resourceGroup) {
        VirtualMachineDto vm = new VirtualMachineDto();
        vm.setVdrpEnabled(Boolean.TRUE);
        vm.setName(name);
        vm.addLink(Links.withRel("virtualmachinetemplate", template.getEditLink()));
        hp.ifPresent(hwp -> vm.addLink(Links.withRel("hardwareprofile", Links.editOrSelf((SingleResourceTransportDto)hwp))));
        fw.ifPresent(fwp -> vm.addLink(Links.withRel("firewall", fwp.getEditLink())));
        availabiltySet.ifPresent(as -> vm.addLink(Links.withRel("availabilityset", as.getEditLink())));
        this.addResourceGroupLink((SingleResourceTransportDto)vm, resourceGroup);
        return this.client.post(vapp.searchLink("virtualmachines").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public VirtualMachineDto createVirtualMachineWithFirewall(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, FirewallPolicyDto fw, HardwareProfileDto hp) {
        return this.createVirtualMachineWithFirewallAndLabel(template, vapp, fw, hp, null);
    }

    public VirtualMachineDto createVirtualMachineWithFirewallAndLabel(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, FirewallPolicyDto fw, HardwareProfileDto hp, String label) {
        return this.createVirtualMachineWithOtherRelations(template, vapp, Optional.of(fw), Optional.of(hp), Optional.empty(), label, null);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, HardwareProfileDto hp, Optional<AvailabilitySetDto> availabilitySet) {
        return this.createVirtualMachineWithLabel(template, vapp, hp, availabilitySet, null);
    }

    public VirtualMachineDto createVirtualMachineWithLabel(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, HardwareProfileDto hp, Optional<AvailabilitySetDto> availabiltySet, String label) {
        return this.createVirtualMachineWithLabelAndResourceGroup(template, vapp, hp, availabiltySet, label, null);
    }

    public VirtualMachineDto createVirtualMachineWithLabelAndResourceGroup(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, HardwareProfileDto hp, Optional<AvailabilitySetDto> availabiltySet, String label, ResourceGroupDto resourceGroup) {
        return this.createVirtualMachineWithOtherRelations(template, vapp, Optional.empty(), Optional.of(hp), availabiltySet, label, resourceGroup);
    }

    public VirtualMachineDto createVirtualMachine(VirtualMachineTemplateDto template, VirtualApplianceDto vapp, HardwareProfileDto hp) {
        return this.createVirtualMachine(template, vapp, hp, Optional.empty());
    }

    public VirtualMachineDto deploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deployCheckTask(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto deployCheckTask(VirtualMachineDto vm, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        if (vm.getState().isDeployed()) {
            return vm;
        }
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vm.searchLink("deploy").getHref(), Collections.singletonMap("force", forceDeploy), "application/vnd.abiquo.acceptedrequest+json", ApiClient.ACCEPTED_REQUEST_TYPE);
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Deploy virtual machine task finished unsuccessfully");
        }
        return this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.deploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto deploy(VirtualApplianceDto vapp, boolean forceDeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vapp.searchLink("deploy").getHref(), Collections.singletonMap("force", forceDeploy), "application/vnd.abiquo.acceptedrequest+json", ApiClient.ACCEPTED_REQUEST_TYPE);
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Deploy virtual appliance operation failed");
        }
        return this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto undeployCheckTask(VirtualMachineDto vm, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        if (!vm.getState().isDeployed()) {
            return vm;
        }
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vm.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, ApiClient.ACCEPTED_REQUEST_TYPE);
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Undeploy virtual machine operation failed");
        }
        return this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto undeploy(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeployCheckTask(vm, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, boolean forceUndeploy, int pollInterval, int maxWait, TimeUnit timeUnit) {
        if (vapp.getState().equals((Object)VirtualApplianceState.NOT_DEPLOYED)) {
            return vapp;
        }
        VirtualMachineTaskDto virtualMachineTask = new VirtualMachineTaskDto();
        virtualMachineTask.setForceUndeploy(forceUndeploy);
        AcceptedRequestDto<String> acceptedRequest = this.client.post(vapp.searchLink("undeploy").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinetask+json", (SingleResourceTransportDto)virtualMachineTask, ApiClient.ACCEPTED_REQUEST_TYPE);
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Undeploy virtual appliance operation failed");
        }
        VirtualApplianceDto refreshed = this.client.waitUntilUnlocked(vapp, pollInterval, maxWait, timeUnit);
        if (VirtualApplianceState.NOT_DEPLOYED != refreshed.getState() && VirtualApplianceState.EMPTY != refreshed.getState()) {
            throw new RuntimeException("Undeploy virtual appliance operation failed");
        }
        return refreshed;
    }

    public VirtualApplianceDto undeploy(VirtualApplianceDto vapp, int pollInterval, int maxWait, TimeUnit timeUnit) {
        return this.undeploy(vapp, false, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto powerState(VirtualMachineDto vm, VirtualMachineState state, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineStateDto vmState = new VirtualMachineStateDto();
        vmState.setState(state);
        AcceptedRequestDto<String> acceptedRequest = this.client.put(vm.searchLink("state").getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachinestate+json", (SingleResourceTransportDto)vmState, ApiClient.ACCEPTED_REQUEST_TYPE);
        TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
        if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
            throw new RuntimeException("Virtual machine power state '" + state.name() + "' operation failed");
        }
        return this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto editVirtualMachineCheckTask(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        VirtualMachineDto refreshed = null;
        VirtualMachineState originalState = vm.getState();
        if (vm.getState().isDeployed()) {
            AcceptedRequestDto<String> acceptedRequest = this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm, ApiClient.ACCEPTED_REQUEST_TYPE);
            TaskDto task = this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
            if (TaskState.FINISHED_SUCCESSFULLY != task.getState()) {
                throw new RuntimeException("Virtual machine reconfigure operation failed");
            }
            refreshed = this.client.waitUntilUnlocked(vm, pollInterval, maxWait, timeUnit);
            if (originalState != refreshed.getState()) {
                throw new RuntimeException("Virtual machine reconfigure operation failed: " + refreshed.getState());
            }
        } else {
            this.client.put(vm.getEditLink().getHref(), "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.virtualmachine+json", (SingleResourceTransportDto)vm);
            refreshed = this.client.refresh(vm);
        }
        return refreshed;
    }

    public VolumeManagementDto getVolume(VirtualDatacenterDto vdc, int idVolume) {
        return this.client.get(vdc.searchLink("volumes").getHref() + "/" + idVolume, "application/vnd.abiquo.volume+json", VolumeManagementDto.class);
    }

    public VolumeManagementDto createVolume(VirtualDatacenterDto vdc, String name, long sizeInMb, TierDto tier) {
        return this.createVolume(vdc, name, sizeInMb, tier, Optional.empty());
    }

    public VolumeManagementDto createVolume(VirtualDatacenterDto vdc, String name, long sizeInMb, TierDto tier, Optional<AvailabilityZoneDto> availabilityZone) {
        return this.createVolumeWithResourceGroup(vdc, name, sizeInMb, tier, availabilityZone, null);
    }

    public VolumeManagementDto createVolumeWithResourceGroup(VirtualDatacenterDto vdc, String name, long sizeInMb, TierDto tier, Optional<AvailabilityZoneDto> availabilityZone, ResourceGroupDto resourceGroup) {
        VolumeManagementDto dto = new VolumeManagementDto();
        dto.setName(name);
        dto.setSizeInMB(sizeInMb);
        dto.addLink(Links.create("tier", Links.editOrSelf((SingleResourceTransportDto)tier).getHref(), "application/vnd.abiquo.tier+json"));
        availabilityZone.ifPresent(availabilityZoneDto -> dto.addLink(Links.create("availabilityzone", Links.editOrSelf((SingleResourceTransportDto)availabilityZoneDto).getHref(), "application/vnd.abiquo.availabilityzone+json")));
        this.addResourceGroupLink((SingleResourceTransportDto)dto, resourceGroup);
        return this.client.post(vdc.searchLink("volumes").getHref(), "application/vnd.abiquo.volume+json", "application/vnd.abiquo.volume+json", (SingleResourceTransportDto)dto, VolumeManagementDto.class);
    }

    public TaskDto getTask(VirtualMachineDto vm, String idTask) {
        return this.client.get(vm.searchLink("tasks").getHref() + "/" + idTask, "application/vnd.abiquo.task+json", TaskDto.class);
    }

    public Stream<TierDto> listTiers(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("tiers").getHref(), "application/vnd.abiquo.tiers+json", TiersDto.class);
    }

    public Stream<DeviceDto> listDevices(LocationDto location) {
        for (RESTLink link : location.getLinks()) {
            if (!link.getRel().equals("devices") || !link.getType().equals("application/vnd.abiquo.devices+json")) continue;
            return this.client.list(link.getHref(), "application/vnd.abiquo.devices+json", DevicesDto.class);
        }
        return Stream.empty();
    }

    public Stream<VolumeManagementDto> listVolumes(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("volumes").getHref(), "application/vnd.abiquo.volumes+json", VolumesManagementDto.class);
    }

    public Stream<VolumeManagementDto> listVolumesWithAvailability(VirtualDatacenterDto vdc, Boolean availability) {
        return this.client.list(vdc.searchLink("volumes").getHref() + "?available=" + availability.toString(), "application/vnd.abiquo.volumes+json", VolumesManagementDto.class);
    }

    public Stream<DeviceDto> listDevicesInLocation(LocationDto location) {
        for (RESTLink link : location.getLinks()) {
            if (!link.getRel().equals("devices") || !link.getType().equals("application/vnd.abiquo.devices+json") || !link.getHref().contains("/locations/")) continue;
            return this.client.list(link.getHref(), "application/vnd.abiquo.devices+json", DevicesDto.class);
        }
        return Stream.empty();
    }

    public Stream<LoadBalancerDto> listLoadBalancers(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancers+json", LoadBalancersDto.class);
    }

    public Stream<LoadBalancerDto> listLoadBalancers(DeviceDto lbd) {
        return this.client.list(lbd.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancers+json", LoadBalancersDto.class);
    }

    public LoadBalancerDto getLoadBalacer(DeviceDto device, int idLoadBalancer) {
        return this.client.get(device.searchLink("loadbalancers").getHref() + "/" + idLoadBalancer, "application/vnd.abiquo.loadbalancer+json", LoadBalancerDto.class);
    }

    public void deleteLoadBalancer(LoadBalancerDto lbd) {
        this.client.delete((SingleResourceTransportDto)lbd);
    }

    public LoadBalancerDto editLoadBalancer(LoadBalancerDto lbd) {
        return this.client.edit(lbd);
    }

    public LoadBalancerDto createLoadBalancer(DeviceDto device, String name, String algorithm, List<RoutingRuleDto> routingRules, List<HealthCheckDto> healthChecks, List<LoadBalancerAddressDto> lbAddresses, List<FirewallPolicyDto> firewalls, Optional<VirtualDatacenterDto> vdc, Optional<VLANNetworkDto> network) {
        return this.createLoadBalancer(device, name, null, algorithm, routingRules, healthChecks, lbAddresses, firewalls, vdc, network.isPresent() ? Collections.singletonList(network.get()) : null, null);
    }

    public LoadBalancerDto createLoadBalancer(DeviceDto device, String name, String type, String algorithm, List<RoutingRuleDto> routingRules, List<HealthCheckDto> healthChecks, List<LoadBalancerAddressDto> lbAddresses, List<FirewallPolicyDto> firewalls, Optional<VirtualDatacenterDto> vdc, List<VLANNetworkDto> networks, ResourceGroupDto resourceGroupDto) {
        LoadBalancerDto lbd = new LoadBalancerDto();
        lbd.setName(name);
        lbd.setAlgorithm(algorithm);
        lbd.setType(type);
        lbd.setHealthChecks(new HealthChecksDto());
        lbd.setRoutingRules(new RoutingRulesDto());
        lbd.setLoadBalancerAddresses(new LoadBalancerAddressesDto());
        lbd.getHealthChecks().addAll(healthChecks);
        lbd.getRoutingRules().addAll(routingRules);
        lbd.getLoadBalancerAddresses().addAll(lbAddresses);
        if (vdc.isPresent()) {
            lbd.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)vdc.get())));
        }
        if (networks != null && !networks.isEmpty()) {
            networks.forEach(network -> {
                Preconditions.checkArgument((network.getType() == NetworkType.INTERNAL ? 1 : 0) != 0, (Object)"Only internal networks can be assigned to a load balancer");
                lbd.addLink(Links.withRel("privatenetwork", Links.editOrSelf((SingleResourceTransportDto)network)));
            });
        }
        for (FirewallPolicyDto fw : firewalls) {
            lbd.addLink(Links.withRel("firewall", Links.editOrSelf((SingleResourceTransportDto)fw)));
        }
        this.addResourceGroupLink((SingleResourceTransportDto)lbd, resourceGroupDto);
        return this.client.post(device.searchLink("loadbalancers").getHref(), "application/vnd.abiquo.loadbalancer+json", "application/vnd.abiquo.loadbalancer+json", (SingleResourceTransportDto)lbd, LoadBalancerDto.class);
    }

    private void addResourceGroupLink(SingleResourceTransportDto dto, ResourceGroupDto resourceGroupDto) {
        if (resourceGroupDto != null) {
            dto.addLink(Links.withRel("resourcegroup", Links.editOrSelf((SingleResourceTransportDto)resourceGroupDto)));
        }
    }

    public HealthCheckDto createHealthCheck(LoadBalancerDto lbd, String name, String protocol, long intervalInMs, long timeoutInMs, Integer attemps, Integer port, String path) {
        HealthCheckDto healthCheck = new HealthCheckDto();
        healthCheck.setName(name);
        healthCheck.setProtocol(protocol);
        healthCheck.setIntervalInMs(intervalInMs);
        healthCheck.setTimeoutInMs(timeoutInMs);
        healthCheck.setAttempts(attemps.intValue());
        healthCheck.setPort(port.intValue());
        healthCheck.setPath(path);
        return this.client.post(lbd.searchLink("healthchecks").getHref(), "application/vnd.abiquo.healthcheck+json", "application/vnd.abiquo.healthcheck+json", (SingleResourceTransportDto)healthCheck, HealthCheckDto.class);
    }

    public RoutingRuleDto createRoutingRule(LoadBalancerDto lbd, String protocolIn, String protocolOut, int portIn, int portOut, SSLCertificateDto sslCertificate) {
        RoutingRuleDto routingRule = new RoutingRuleDto();
        routingRule.setPortIn(Integer.valueOf(portIn));
        routingRule.setPortOut(Integer.valueOf(portOut));
        routingRule.setProtocolIn(protocolIn);
        routingRule.setProtocolOut(protocolOut);
        if (sslCertificate != null) {
            routingRule.setSslCertificate(sslCertificate);
        }
        return this.client.post(lbd.searchLink("routingrules").getHref(), "application/vnd.abiquo.routingrule+json", "application/vnd.abiquo.routingrule+json", (SingleResourceTransportDto)routingRule, RoutingRuleDto.class);
    }

    public Stream<RoutingRuleDto> listRoutingRules(LoadBalancerDto lbd) {
        return this.client.list(lbd.searchLink("routingrules").getHref(), "application/vnd.abiquo.routingrules+json", RoutingRulesDto.class);
    }

    public Stream<HealthCheckDto> listHealthChecks(LoadBalancerDto lbd) {
        return this.client.list(lbd.searchLink("healthchecks").getHref(), "application/vnd.abiquo.healthchecks+json", HealthChecksDto.class);
    }

    public RoutingRulesDto editRoutingRules(RoutingRulesDto routingRules) {
        for (RoutingRuleDto routingRule : routingRules.getCollection()) {
            this.editRoutingRule(routingRule);
        }
        return routingRules;
    }

    public HealthChecksDto editHealthChecks(HealthChecksDto healthChecks) {
        for (HealthCheckDto healthCheck : healthChecks.getCollection()) {
            this.editHealthCheck(healthCheck);
        }
        return healthChecks;
    }

    public void deleteRoutingRule(RoutingRuleDto routingRule) {
        this.client.delete((SingleResourceTransportDto)routingRule);
    }

    public void deleteHealthCheck(HealthCheckDto healthCheck) {
        this.client.delete((SingleResourceTransportDto)healthCheck);
    }

    public RoutingRuleDto editRoutingRule(RoutingRuleDto routingRule) {
        return this.client.edit(routingRule);
    }

    public HealthCheckDto editHealthCheck(HealthCheckDto healthCheck) {
        return this.client.edit(healthCheck);
    }

    public RoutingRuleDto getRoutingRule(LoadBalancerDto lbd, int idRoutingRule) {
        return this.client.get(lbd.searchLink("routingrules").getHref() + "/" + idRoutingRule, "application/vnd.abiquo.routingrule+json", RoutingRuleDto.class);
    }

    public HealthCheckDto getHealthCheck(LoadBalancerDto lbd, int idHealthCheck) {
        return this.client.get(lbd.searchLink("healthchecks").getHref() + "/" + idHealthCheck, "application/vnd.abiquo.healthcheck+json", HealthCheckDto.class);
    }

    public Stream<ConditionalActionDto> listConditionalActions(RoutingRuleDto routingRule) {
        return this.client.list(routingRule.searchLink("conditionalactions").getHref(), "application/vnd.abiquo.conditionalactions+json", ConditionalActionsDto.class);
    }

    public ConditionalActionDto editConditionalAction(ConditionalActionDto conditionalAction) {
        return this.client.edit(conditionalAction);
    }

    public FirewallPolicyDto createFirewallPolicy(String name, String description, DeviceDto firewallDevice, Optional<VirtualDatacenterDto> optVdc, boolean isVdcDefault) {
        return this.createFirewallPolicyWithResourceGroup(name, description, firewallDevice, optVdc, isVdcDefault, null);
    }

    public FirewallPolicyDto createFirewallPolicyWithResourceGroup(String name, String description, DeviceDto firewallDevice, Optional<VirtualDatacenterDto> optVdc, boolean isVdcDefault, ResourceGroupDto resourceGroup) {
        FirewallPolicyDto firewall = new FirewallPolicyDto();
        firewall.setName(name);
        firewall.setDescription(description);
        if (optVdc.isPresent()) {
            firewall.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)optVdc.get())));
            firewall.setVdcDefault(isVdcDefault);
        }
        this.addResourceGroupLink((SingleResourceTransportDto)firewall, resourceGroup);
        return this.client.post(firewallDevice.searchLink("firewalls").getHref(), "application/vnd.abiquo.firewallpolicy+json", "application/vnd.abiquo.firewallpolicy+json", (SingleResourceTransportDto)firewall, FirewallPolicyDto.class);
    }

    public Stream<FirewallPolicyDto> listFirewallPolicies(DeviceDto device) {
        return this.client.list(device.searchLink("firewalls").getHref(), "application/vnd.abiquo.firewallpolicies+json", FirewallPoliciesDto.class);
    }

    public Stream<FirewallPolicyDto> listFirewallPolicies(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("firewalls").getHref(), "application/vnd.abiquo.firewallpolicies+json", FirewallPoliciesDto.class);
    }

    public FirewallPolicyDto makeThisFirewallPolicyDefaultForVirtualDatacenter(FirewallPolicyDto fw) {
        return this.client.put(fw.searchLink("defaultfirewallpolicy").getHref(), "application/vnd.abiquo.firewallpolicy+json", FirewallPolicyDto.class);
    }

    public void deleteFirewallPolicies(FirewallPolicyDto firewall) {
        this.client.delete((SingleResourceTransportDto)firewall);
    }

    public FirewallRulesDto addFirewallRules(FirewallPolicyDto firewall, FirewallRulesDto rules) {
        return this.client.put(firewall.searchLink("rules").getHref(), "application/vnd.abiquo.firewallrules+json", "application/vnd.abiquo.firewallrules+json", (SingleResourceTransportDto)rules, FirewallRulesDto.class);
    }

    public VirtualMachineDto addFirewallToVirtualMachine(FirewallPolicyDto firewall, VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        vm.addLink(Links.withRel("firewall", Links.editOrSelf((SingleResourceTransportDto)firewall)));
        return this.editVirtualMachineCheckTask(vm, pollInterval, maxWait, timeUnit);
    }

    public NicsDto getNics(VirtualMachineDto vm) {
        return this.client.get(vm.searchLink("nics").getHref(), "application/vnd.abiquo.nics+json", NicsDto.class);
    }

    public VirtualMachineDto cloneVirtualMachine(VirtualMachineDto vm) {
        return this.client.post(vm.searchLink("clone").getHref(), "application/vnd.abiquo.virtualmachine+json", "application/vnd.abiquo.virtualmachinecloneoptions+json", (SingleResourceTransportDto)vm, VirtualMachineDto.class);
    }

    public IPSecVPNDto createIPSecVPN(VirtualDatacenterDto vdc, String name, String remoteEndpoint, String encryptionAlgorithm, boolean perfectForwardSecrecyEnabled, String dhGroup, String authentication, Set<String> remoteNetworks, String presharedKey, Optional<RESTLink> localEndpoint, Optional<Set<VLANNetworkDto>> localNetworks, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        IPSecVPNDto vpnIPSec = new IPSecVPNDto();
        vpnIPSec.setName(name);
        vpnIPSec.setRemoteEndpoint(remoteEndpoint);
        vpnIPSec.setEncryptionAlgorithm(encryptionAlgorithm);
        vpnIPSec.setPerfectForwardSecrecyEnabled(perfectForwardSecrecyEnabled);
        vpnIPSec.setDhGroup(dhGroup);
        vpnIPSec.setAuthentication(authentication);
        vpnIPSec.setRemoteNetworks(remoteNetworks);
        vpnIPSec.setPresharedKey(presharedKey);
        vpnIPSec.addLink(Links.withRel("localnetwork", vdc.getVlan().getEditLink()));
        if (localEndpoint.isPresent()) {
            vpnIPSec.addLink(Links.withRel("localendpoint", localEndpoint.get()));
        }
        if (localNetworks.isPresent()) {
            for (VLANNetworkDto vlan : localNetworks.get()) {
                vpnIPSec.addLink(Links.withRel("localnetwork", vlan.getEditLink()));
            }
        }
        AsyncTaskDto task = this.client.post(vdc.searchLink("vpns").getHref(), "application/vnd.abiquo.asynctask+json", "application/vnd.abiquo.vpnipsec+json", (SingleResourceTransportDto)vpnIPSec, AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
        return this.client.get(task.searchLink("owner"), IPSecVPNDto.class);
    }

    public Stream<IPSecVPNDto> listIPSecVPN(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.searchLink("vpns").getHref(), "application/vnd.abiquo.vpnsipsec+json", IPSecVPNsDto.class);
    }

    public IPSecVPNDto getIPSecVPN(int idVdc, int idVpn) {
        return this.client.get(String.format("%s/%s/vpns/%s", "/cloud/virtualdatacenters", idVdc, idVpn), "application/vnd.abiquo.vpnipsec+json", IPSecVPNDto.class);
    }

    public void deleteIPSecVPN(SingleResourceTransportDto vpn, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        AsyncTaskDto task = this.client.delete(vpn, "application/vnd.abiquo.asynctask+json", AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
    }

    public IPSecVPNDto editIPSecVPNDto(IPSecVPNDto vpn, long pollInterval, long maxWait, TimeUnit timeUnit) throws TimeoutException, AsyncTaskFailedException {
        RESTLink link = vpn.getEditLink();
        AsyncTaskDto task = this.client.put(link.getHref(), "application/vnd.abiquo.asynctask+json", "application/vnd.abiquo.vpnipsec+json", (SingleResourceTransportDto)vpn, AsyncTaskDto.class);
        if (!AsyncTaskUtils.hasFinishedSuccesfully(task = this.client.waitForAsyncTaskFinalization(task, pollInterval, maxWait, timeUnit))) {
            throw new AsyncTaskFailedException(task);
        }
        return this.client.get(task.searchLink("owner"), IPSecVPNDto.class);
    }

    public VPNTunnelStatusDto checkTunnelStatusOfAnIPSecVPN(IPSecVPNDto vpn) {
        return this.client.get(vpn.searchLink("status"), VPNTunnelStatusDto.class);
    }

    public Stream<NatNetworkDto> listNatNetworksInADevice(DeviceDto device) {
        return this.client.list(device.searchLink("natnetworks").getHref(), "application/vnd.abiquo.natnetworks+json", NatNetworksDto.class);
    }

    public Stream<NatIpDto> listNatIPsInVirtualDatacenter(VirtualDatacenterDto vdc) {
        return this.client.list(vdc.getEditLink().getHref() + "/action/natips", "application/vnd.abiquo.natips+json", NatIpsDto.class);
    }

    public NatIpDto assignNatIPToVirtualDatacenter(NatNetworkDto natNW, VirtualDatacenterDto vdc) {
        LinksDto links = new LinksDto();
        links.addLink(Links.create("virtualdatacenter", vdc.getEditLink().getHref(), vdc.getEditLink().getType()));
        return this.client.post(natNW.searchLink("ips").getHref(), "application/vnd.abiquo.natip+json", "application/vnd.abiquo.links+json", (SingleResourceTransportDto)links, NatIpDto.class);
    }

    public Stream<FirewallPolicyDto> syncFirewallPolicies(VirtualDatacenterDto vdc) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("source", "REMOTE");
        return this.client.list(vdc.searchLink("firewalls").getHref(), queryParams, "application/vnd.abiquo.firewallpolicies+json", FirewallPoliciesDto.class);
    }

    public VirtualMachineDto assignIpToVirtualMachine(VirtualMachineDto vm, VLANNetworkDto vlan, int pollInterval, int maxWait, TimeUnit timeUnit) {
        int nics = (int)vm.getLinks().stream().filter(Links.isNic()).count();
        RESTLink ipLink = Links.create("nic" + nics, vlan.searchLink("ips").getHref(), "application/vnd.abiquo.privateip+json", "newIP");
        vm.addLink(ipLink);
        return this.editVirtualMachineCheckTask(vm, pollInterval, maxWait, timeUnit);
    }

    public void syncVirtualDatacenter(ApiClient api, VirtualDatacenterDto vdc, int syncVDCPollInterval, int syncVDCWaitTime, TimeUnit syncVDCTimeUnit) {
        SyncVirtualDatacenterDto sync = new SyncVirtualDatacenterDto();
        sync.addLink(vdc.searchLink("location"));
        sync.setProviderId(vdc.getProviderId());
        AcceptedRequestDto accepted = api.getClient().post("/cloud/virtualdatacenters", "application/vnd.abiquo.acceptedrequest+json", "application/vnd.abiquo.syncvirtualdatacenter+json", (SingleResourceTransportDto)sync, AcceptedRequestDto.class);
        RESTLink taskLink = accepted.searchLink("status");
        TaskDto task = api.getClient().get(taskLink, TaskDto.class);
        this.client.waitForTask(task, syncVDCPollInterval, syncVDCWaitTime, syncVDCTimeUnit);
    }

    public DiskManagementDto createHardDisk(VirtualDatacenterDto vdc, DiskManagementDto disk) {
        return this.client.post(vdc.searchLink("disks").getHref(), "application/vnd.abiquo.harddisk+json", "application/vnd.abiquo.harddisk+json", (SingleResourceTransportDto)disk, DiskManagementDto.class);
    }

    public Stream<DiskManagementDto> listHardDisks(VirtualMachineDto vm) {
        return this.client.list(vm.searchLink("harddisks"), DisksManagementDto.class);
    }

    public VirtualMachineDto detachVolume(VirtualMachineDto vm, VolumeManagementDto vol) {
        return this.detachVolume(vm, vol, 5, 300, TimeUnit.SECONDS);
    }

    public VirtualMachineDto detachVolume(VirtualMachineDto vm, VolumeManagementDto vol, int pollInterval, int maxWait, TimeUnit timeUnit) {
        vm.getLinks().stream().filter(l -> "application/vnd.abiquo.volume+json".equals(l.getType()) && l.getHref().equals(vol.getEditLink().getHref())).findFirst().ifPresent(vm.getLinks()::remove);
        return this.editVirtualMachineCheckTask(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto detachAllExternalIPs(VirtualMachineDto vm) {
        return this.detachAllExternalIPs(vm, 5, 300, TimeUnit.SECONDS);
    }

    public VirtualMachineDto detachAllExternalIPs(VirtualMachineDto vm, int pollInterval, int maxWait, TimeUnit timeUnit) {
        vm.getLinks().removeIf(l -> l.getType().equals("application/vnd.abiquo.externalip+json") || l.getRel().equals("network_configuration"));
        return this.editVirtualMachineCheckTask(vm, pollInterval, maxWait, timeUnit);
    }

    public VirtualMachineDto attachVolume(VirtualMachineDto vm, VolumeManagementDto vol) {
        return this.attachVolume(vm, vol, 5, 300, TimeUnit.SECONDS);
    }

    public VirtualMachineDto attachVolume(VirtualMachineDto vm, VolumeManagementDto vol, int pollInterval, int maxWait, TimeUnit timeUnit) {
        List disks = StreamSupport.stream(vm.getLinks().spliterator(), false).filter(l -> l.getRel().startsWith("disk")).collect(Collectors.toList());
        int diskNumber = disks.size();
        vm.addLink(Links.withRel("disk" + diskNumber, Links.editOrSelf((SingleResourceTransportDto)vol)));
        return this.editVirtualMachineCheckTask(vm, pollInterval, maxWait, timeUnit);
    }

    public ActionPlanDto createActionPlan(ActionPlanDto ap) {
        return this.client.post("/cloud/actionplans", "application/vnd.abiquo.actionplan+json", "application/vnd.abiquo.actionplan+json", (SingleResourceTransportDto)ap, ActionPlanDto.class);
    }

    public Stream<ActionPlanDto> listActionPlans() {
        return this.client.list("/cloud/actionplans", "application/vnd.abiquo.actionplans+json", ActionPlansDto.class);
    }

    public Stream<ActionPlanFlatDto> listActionPlansFlat() {
        return this.client.list("/cloud/actionplans", "application/vnd.abiquo.actionplansflat+json", ActionPlansFlatDto.class);
    }

    public ActionPlanDto editActionPlan(ActionPlanDto ap) {
        return this.client.edit(ap);
    }

    public void deleteActionPlan(ActionPlanDto ap) {
        this.client.delete((SingleResourceTransportDto)ap);
    }

    public Stream<TaskDto> listTasksInActionPlan(ActionPlanDto ap) {
        return this.client.list(ap.getEditLink().getHref() + "tasks", "application/vnd.abiquo.tasks+json", TasksDto.class);
    }

    public TaskDto executeActionPlanAndGetTask(ActionPlanDto ap, int pollInterval, int maxWait, TimeUnit timeUnit) {
        AcceptedRequestDto<String> acceptedRequest = this.client.post(ap.getEditLink().getHref() + "/action/execute", "application/vnd.abiquo.acceptedrequest+json", ApiClient.ACCEPTED_REQUEST_TYPE);
        return this.client.waitForTask(acceptedRequest, pollInterval, maxWait, timeUnit);
    }

    public AvailabilitySetDto createAvailabilitySet(PublicCloudRegionDto location, VirtualDatacenterDto vdc, String name) {
        return this.createAvailabilitySetWithResourceGroup(location, vdc, name, null);
    }

    public AvailabilitySetDto createAvailabilitySetWithResourceGroup(PublicCloudRegionDto location, VirtualDatacenterDto vdc, String name, ResourceGroupDto resourceGroup) {
        AvailabilitySetDto dto = new AvailabilitySetDto();
        dto.setName(name);
        dto.setFaultDomains(2);
        dto.setUpdateDomains(5);
        dto.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)vdc)));
        this.addResourceGroupLink((SingleResourceTransportDto)dto, resourceGroup);
        return this.client.post(location.searchLink("availabilitysets").getHref(), "application/vnd.abiquo.availabilityset+json", "application/vnd.abiquo.availabilityset+json", (SingleResourceTransportDto)dto, AvailabilitySetDto.class);
    }

    public void makeVlanDefault(VirtualDatacenterDto vdc, VLANNetworkDto vlan) {
        LinksDto links = new LinksDto();
        links.addLink(Links.withRel(vlan.getType().getRel(), vlan.getEditLink()));
        this.client.putAction(vdc.getEditLink().getHref() + "/action/defaultvlan", "application/vnd.abiquo.links+json; version=5.2", (SingleResourceTransportDto)links);
    }

    public void makeGlobalSubnetDefault(VirtualDatacenterDto vdc, GlobalSubnetDto subnet) {
        LinksDto links = new LinksDto();
        links.addLink(Links.withRel("globalsubnet", Links.editOrSelf((SingleResourceTransportDto)subnet)));
        this.client.putAction(vdc.getEditLink().getHref() + "/action/defaultglobalsubnet", "application/vnd.abiquo.links+json; version=5.2", (SingleResourceTransportDto)links);
    }

    public void createResourceGroup(String resourceGroupName, EnterpriseDto enterprise, RegionDto region) {
        ResourceGroupDto dto = new ResourceGroupDto();
        dto.setName(resourceGroupName);
        dto.addLink(Links.withRel("enterprise", Links.editOrSelf((SingleResourceTransportDto)enterprise)));
        dto.addLink(Links.withRel("region", Links.editOrSelf((SingleResourceTransportDto)region)));
        this.client.post("/cloud/resourcegroups", "application/vnd.abiquo.resourcegroup+json", "application/vnd.abiquo.resourcegroup+json", (SingleResourceTransportDto)dto, ResourceGroupDto.class);
    }

    public List<ResourceGroupDto> listResourceGroups(EnterpriseDto enterprise, HypervisorTypeDto plugin) {
        ListOptions options = ((ListOptions.Builder)ListOptions.builder().limit(0)).build();
        LinksDto links = new LinksDto();
        links.addLink(Links.withRel("enterprise", Links.editOrSelf((SingleResourceTransportDto)enterprise)));
        links.addLink(Links.withRel("hypervisortype", Links.editOrSelf((SingleResourceTransportDto)plugin)));
        return this.client.put("/cloud/resourcegroups", options.queryParams(), "application/vnd.abiquo.resourcegroups+json", "application/vnd.abiquo.links+json", (SingleResourceTransportDto)links, ResourceGroupsDto.class).getCollection();
    }

    public GlobalNetworkDto createGlobalNetwork(String name, EnterpriseDto enterprise, HypervisorTypeDto plugin) {
        GlobalNetworkDto dto = new GlobalNetworkDto();
        dto.setName(name);
        dto.addLink(Links.withRel("enterprise", Links.editOrSelf((SingleResourceTransportDto)enterprise)));
        dto.addLink(Links.withRel("hypervisortype", Links.editOrSelf((SingleResourceTransportDto)plugin)));
        return this.client.post("/cloud/globalnetworks", "application/vnd.abiquo.globalnetwork+json", "application/vnd.abiquo.globalnetwork+json", (SingleResourceTransportDto)dto, GlobalNetworkDto.class);
    }

    public List<GlobalNetworkDto> listGlobalNetworks(EnterpriseDto enterprise, HypervisorTypeDto plugin) {
        ListOptions options = ((ListOptions.Builder)ListOptions.builder().limit(0)).build();
        LinksDto links = new LinksDto();
        links.addLink(Links.withRel("enterprise", Links.editOrSelf((SingleResourceTransportDto)enterprise)));
        links.addLink(Links.withRel("hypervisortype", Links.editOrSelf((SingleResourceTransportDto)plugin)));
        return this.client.post("/cloud/globalnetworks", options.queryParams(), "application/vnd.abiquo.globalnetworks+json", "application/vnd.abiquo.links+json", (SingleResourceTransportDto)links, GlobalNetworksDto.class).getCollection();
    }

    public void deleteGlobalNetwork(GlobalNetworkDto gn) {
        this.client.delete((SingleResourceTransportDto)gn);
    }

    public GlobalSubnetDto createGlobalSubnet(String name, String cidr, PublicCloudRegionDto location, GlobalNetworkDto globalNetwork, VirtualDatacenterDto vdcDto) {
        GlobalSubnetDto dto = new GlobalSubnetDto();
        dto.setName(name);
        dto.setCidr(cidr);
        dto.addLink(Links.withRel("globalnetwork", Links.editOrSelf((SingleResourceTransportDto)globalNetwork)));
        dto.addLink(Links.withRel("virtualdatacenter", Links.editOrSelf((SingleResourceTransportDto)vdcDto)));
        return this.client.post(location.searchLink("globalsubnets").getHref(), "application/vnd.abiquo.globalsubnet+json", "application/vnd.abiquo.globalsubnet+json", (SingleResourceTransportDto)dto, GlobalSubnetDto.class);
    }

    public List<GlobalSubnetDto> listGlobalSubnets(GlobalNetworkDto gn) {
        ListOptions options = ((ListOptions.Builder)ListOptions.builder().limit(0)).build();
        return this.client.get(gn.searchLink("globalsubnets").getHref(), options.queryParams(), "application/vnd.abiquo.globalsubnets+json", GlobalSubnetsDto.class).getCollection();
    }

    public void deleteGlobalSubnet(GlobalSubnetDto subnet) {
        this.client.delete((SingleResourceTransportDto)subnet);
    }

    public List<PublicIpDto> listPublicIPsOfLocation(LocationDto pcrLocation) {
        return this.client.get(pcrLocation.searchLink("ips").getHref(), "application/vnd.abiquo.publicips+json", PublicIpsDto.class).getCollection();
    }

    public List<TargetGroupDto> listTargetGroups(DeviceDto device) {
        return this.client.get(device.searchLink("targetgroups"), TargetGroupsDto.class).getCollection();
    }

    public List<TargetGroupDto> listTargetGroups(VirtualDatacenterDto vdc) {
        return this.client.get(vdc.searchLink("targetgroups"), TargetGroupsDto.class).getCollection();
    }

    public TargetGroupDto createTargetGroup(DeviceDto device, TargetGroupDto targetGroup) {
        return this.client.post(device.searchLink("targetgroups").getHref(), "application/vnd.abiquo.targetgroup+json", "application/vnd.abiquo.targetgroup+json", (SingleResourceTransportDto)targetGroup, TargetGroupDto.class);
    }

    public TargetGroupDto editTargetGroup(TargetGroupDto targetGroup) {
        return this.client.edit(targetGroup);
    }

    public void deleteTargetGroup(TargetGroupDto targetGoup) {
        this.client.delete((SingleResourceTransportDto)targetGoup);
    }

    public List<TargetDto> updateTargetGroupTargets(TargetGroupDto targetGroup, List<TargetDto> newTargets) {
        TargetsDto dto = new TargetsDto();
        dto.getCollection().addAll(newTargets);
        return this.client.put(targetGroup.searchLink("targets").getHref(), "application/vnd.abiquo.targets+json", "application/vnd.abiquo.targets+json", (SingleResourceTransportDto)dto, TargetsDto.class).getCollection();
    }
}

