/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient;

import com.abiquo.apiclient.RestClient;
import com.abiquo.apiclient.domain.exception.HttpException;
import com.abiquo.model.rest.RESTLink;
import com.abiquo.model.transport.SingleResourceTransportDto;
import com.abiquo.server.core.cloud.metric.MetricDto;
import com.abiquo.server.core.cloud.metric.MetricMetadataDto;
import com.abiquo.server.core.cloud.metric.MetricsMetadataDto;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.Period;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MetricsApi {
    private static final String StartRelativeQueryParam = "startrelative";
    private static final String StartAbsoluteQueryParam = "startabsolute";
    private static final String EndAbsoluteQueryParam = "endabsolute";
    private static final String GranularityQueryParam = "granularity";
    private static final String StatisticQueryParam = "statistic";
    private final RestClient client;

    MetricsApi(RestClient client) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
    }

    public List<MetricMetadataDto> listMetricMetadata(SingleResourceTransportDto dto) {
        RESTLink link = dto.searchLink("metricsmetadata");
        if (link == null) {
            return Collections.emptyList();
        }
        return this.client.get(link, MetricsMetadataDto.class).getCollection();
    }

    public Optional<MetricMetadataDto> findMetricMetadata(SingleResourceTransportDto dto, String metricName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)metricName) ? 1 : 0) != 0, (Object)"metric name cannot be null or empty");
        RESTLink metricsMetadataLink = dto.searchLink("metricsmetadata");
        if (metricsMetadataLink == null) {
            return Optional.empty();
        }
        try {
            RESTLink metadataLink = new RESTLink();
            metadataLink.setType("application/vnd.abiquo.metricmetadata+json");
            metadataLink.setHref(MetricsApi.AppendSegmentToPath(metricsMetadataLink.getHref(), metricName));
            return Optional.ofNullable(this.client.get(metadataLink, MetricMetadataDto.class));
        }
        catch (HttpException httpException) {
            if (400 == httpException.getCode()) {
                return Optional.empty();
            }
            throw httpException;
        }
    }

    public MetricDto getMetricStatistic(MetricMetadataDto metricMetadataDto) {
        return this.getMetricStatistic(metricMetadataDto, new QueryMetricBuilder().build());
    }

    public MetricDto getMetricStatistic(MetricMetadataDto metricMetadataDto, QueryMetric query) {
        HashMap<String, Object> params = new HashMap<String, Object>(query.getDimensions());
        query.getStatisticType().ifPresent(statistic -> params.put(StatisticQueryParam, statistic.getParameter()));
        query.getGranularitySeconds().ifPresent(granularity -> params.put(GranularityQueryParam, String.valueOf(granularity)));
        query.getStartRelative().ifPresent(duration -> params.put(StartRelativeQueryParam, duration));
        query.getStartAbsolute().ifPresent(start -> params.put(StartAbsoluteQueryParam, start));
        query.getEndAbsolute().ifPresent(end -> params.put(EndAbsoluteQueryParam, end));
        RESTLink link = metricMetadataDto.searchLink("metric");
        return this.client.get(link.getHref(), params, link.getType(), MetricDto.class);
    }

    private static String AppendSegmentToPath(String path, String segment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"path cannot be null or empty");
        if (path.charAt(path.length() - 1) == '/') {
            return path + segment;
        }
        return path + "/" + segment;
    }

    public static class QueryMetricBuilder {
        private Long granularityAmount = null;
        private TimeUnit granularityUnit = null;
        private StatisticType statisticType = null;
        private Period startRelative = null;
        private Date startAbsolute = null;
        private Date endAbsolute = null;
        private Map<String, String> dimensions = new HashMap<String, String>();

        public QueryMetric build() {
            Long granularityInSeconds = null;
            if (this.granularityAmount != null && this.granularityUnit != null) {
                granularityInSeconds = this.granularityUnit.toSeconds(this.granularityAmount);
            }
            this.dimensions.remove(MetricsApi.StartRelativeQueryParam);
            this.dimensions.remove(MetricsApi.StartAbsoluteQueryParam);
            this.dimensions.remove(MetricsApi.EndAbsoluteQueryParam);
            this.dimensions.remove(MetricsApi.GranularityQueryParam);
            this.dimensions.remove(MetricsApi.StatisticQueryParam);
            return new QueryMetric(this.statisticType, this.dimensions, this.startRelative, this.startAbsolute, this.endAbsolute, granularityInSeconds);
        }

        public QueryMetricBuilder withStatisticType(StatisticType statisticType) {
            this.statisticType = statisticType;
            return this;
        }

        public QueryMetricBuilder withGranularity(long amount, TimeUnit unit) {
            if (unit.toSeconds(amount) < 60L) {
                throw new IllegalArgumentException("Aggregator granularity should be >= 60 seconds");
            }
            this.granularityAmount = amount;
            this.granularityUnit = unit;
            return this;
        }

        public QueryMetricBuilder withDimensions(Map<String, String> dimensions) {
            this.dimensions.putAll(dimensions);
            return this;
        }

        public QueryMetricBuilder withRelativeStartTime(Period period) {
            this.startRelative = period;
            this.startAbsolute = null;
            this.endAbsolute = null;
            return this;
        }

        public QueryMetricBuilder withAbsoluteStartTime(Date date) {
            this.startAbsolute = date;
            this.endAbsolute = null;
            this.startRelative = null;
            return this;
        }

        public QueryMetricBuilder withAbsoluteTimeRange(Date start, Date end) {
            this.startAbsolute = start;
            this.endAbsolute = end;
            this.startRelative = null;
            return this;
        }
    }

    public static class QueryMetric {
        private final Optional<Long> granularitySeconds;
        private final Optional<StatisticType> statisticType;
        private final Optional<String> startRelative;
        private final Optional<Long> startAbsolute;
        private final Optional<Long> endAbsolute;
        private final Map<String, String> dimensions;

        QueryMetric(StatisticType statisticType, Map<String, String> dimensions, Period startRelative, Date startAbsolute, Date endAbsolute, Long granularity) {
            this.statisticType = Optional.ofNullable(statisticType);
            this.dimensions = dimensions;
            this.granularitySeconds = Optional.ofNullable(granularity);
            this.startRelative = Optional.ofNullable(startRelative).map(Period::toString);
            this.startAbsolute = Optional.ofNullable(startAbsolute).map(Date::getTime);
            this.endAbsolute = Optional.ofNullable(endAbsolute).map(Date::getTime);
        }

        public Optional<Long> getGranularitySeconds() {
            return this.granularitySeconds;
        }

        public Map<String, String> getDimensions() {
            return this.dimensions;
        }

        public Optional<StatisticType> getStatisticType() {
            return this.statisticType;
        }

        public Optional<String> getStartRelative() {
            return this.startRelative;
        }

        public Optional<Long> getStartAbsolute() {
            return this.startAbsolute;
        }

        public Optional<Long> getEndAbsolute() {
            return this.endAbsolute;
        }
    }

    public static enum StatisticType {
        Average("average"),
        Maximum("maximum"),
        Minimum("minimum"),
        Sum("sum"),
        Count("count"),
        Dev("dev");

        private final String queryParameterValue;

        private StatisticType(String queryParameterValue) {
            this.queryParameterValue = queryParameterValue;
        }

        public String getParameter() {
            return this.queryParameterValue;
        }
    }
}

