/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.auth;

import com.abiquo.apiclient.auth.Authentication;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import oauth.signpost.AbstractOAuthConsumer;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.http.HttpRequest;
import okio.Buffer;
import okio.BufferedSink;

public class OAuthAuthentication
implements Authentication {
    private final OAuthConsumer oauthConsumer;

    private OAuthAuthentication(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        this.oauthConsumer = new OkHttpOAuthConsumer(Objects.requireNonNull(consumerKey, "consumerKey cannot be null"), Objects.requireNonNull(consumerSecret, "consumerSecret cannot be null"), Objects.requireNonNull(accessToken, "accessToken cannot be null"), Objects.requireNonNull(accessTokenSecret, "accessTokenSecret cannot be null"));
    }

    public static OAuthAuthentication oauth(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        return new OAuthAuthentication(consumerKey, consumerSecret, accessToken, accessTokenSecret);
    }

    @Override
    public boolean allowAbiquoToken() {
        return false;
    }

    @Override
    public Request authenticate(Request unauthenticated) {
        try {
            return (Request)this.oauthConsumer.sign((Object)unauthenticated).unwrap();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected error signing the request", ex);
        }
    }

    private static class OkHttpRequestAdapter
    implements HttpRequest {
        private Request request;

        public OkHttpRequestAdapter(Request request) {
            this.request = Objects.requireNonNull(request, "request cannot be null");
        }

        public String getMethod() {
            return this.request.method();
        }

        public String getRequestUrl() {
            return this.request.urlString();
        }

        public void setRequestUrl(String url) {
            throw new UnsupportedOperationException("Request URL cannot be modified");
        }

        public void setHeader(String name, String value) {
            this.request = this.request.newBuilder().addHeader(name, value).build();
        }

        public String getHeader(String name) {
            return this.request.header(name);
        }

        public Map<String, String> getAllHeaders() {
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String header : this.request.headers().names()) {
                headers.put(header, this.request.headers().get(header));
            }
            return headers;
        }

        public InputStream getMessagePayload() throws IOException {
            RequestBody body = this.request.body();
            if (body == null) {
                return null;
            }
            Buffer buf = new Buffer();
            body.writeTo((BufferedSink)buf);
            return buf.inputStream();
        }

        public String getContentType() {
            RequestBody body = this.request.body();
            if (body == null) {
                return null;
            }
            MediaType contentType = body.contentType();
            return contentType == null ? null : contentType.toString();
        }

        public Object unwrap() {
            return this.request;
        }
    }

    private static class OkHttpOAuthConsumer
    extends AbstractOAuthConsumer {
        private static final long serialVersionUID = -585335662715371444L;

        public OkHttpOAuthConsumer(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
            super(consumerKey, consumerSecret);
            this.setTokenWithSecret(accessToken, accessTokenSecret);
        }

        protected HttpRequest wrap(Object request) {
            Preconditions.checkArgument((boolean)(request instanceof Request), (Object)"An OkHttp request is required");
            return new OkHttpRequestAdapter((Request)request);
        }
    }
}

