/*
 * Decompiled with CFR 0.152.
 */
package com.abiquo.apiclient.domain.exception;

import com.abiquo.apiclient.domain.exception.HttpException;
import com.abiquo.model.transport.error.ErrorDto;
import com.abiquo.model.transport.error.ErrorsDto;
import java.util.function.Predicate;

public class AbiquoException
extends HttpException {
    private static final long serialVersionUID = 3417635717730170489L;
    private final ErrorsDto errors;

    public AbiquoException(int code, ErrorDto error) {
        super(code, error.toString());
        this.errors = new ErrorsDto();
        this.errors.add((Object)error);
    }

    public AbiquoException(int code, ErrorsDto errors) {
        super(code, errors.toString());
        this.errors = errors;
    }

    public ErrorsDto getErrors() {
        return this.errors;
    }

    public boolean hasError(String code) {
        return this.errors.getCollection().stream().anyMatch(AbiquoException.sameCode(code));
    }

    public ErrorDto getError(String code) {
        return this.errors.getCollection().stream().filter(AbiquoException.sameCode(code)).findFirst().orElseThrow(() -> new HttpException(404, "Error with code " + code + "not found"));
    }

    public ErrorDto firstError() {
        return (ErrorDto)this.errors.getCollection().get(0);
    }

    private static Predicate<ErrorDto> sameCode(final String code) {
        return new Predicate<ErrorDto>(){

            @Override
            public boolean test(ErrorDto input) {
                return input.getCode().equals(code);
            }
        };
    }
}

