/**
 * Copyright (C) 2008 Abiquo Holdings S.L.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.abiquo.apiclient.stream;

import java.util.List;

import com.abiquo.tracing.model.Trace;

public class StreamClientExample
{
    public static void main(final String[] args) throws Exception
    {
        String endpoint = "http://localhost";
        // add value for username
        String username = "";
        // add value for password
        String password = "";

        try (StreamClient client = StreamClient.builder(endpoint + "/m", endpoint + "/api")//
            .basicAuth(username, password)//
            .addCallback((t) -> {
                System.err.println(
                    StreamClient.dateFormat.format(t.getTimestamp()) + ":" + t.getMessage());
            })//
            .reconnect()//
            .afterReconnect(StreamClientExample::customReconnect).build())
        {
            client.connect();

            Thread.sleep(Long.MAX_VALUE);
        }
    }

    static void customReconnect(final StreamClient sc)
    {
        // default implementation
        List<Trace> eventsFromApi = sc.getEventsFromApiAndProcessCallback(sc);

        // custom things to do with the events from the reconnection
        System.err.println("Reconnection process " + eventsFromApi.size() + " from api");
    }

}
