/*
 * Decompiled with CFR 0.152.
 */
package com.actigence.aal;

import com.actigence.aal.HttpRequestCachingWrapper;
import com.actigence.aal.HttpResponseCachingWrapper;
import com.actigence.aal.aws.SQSClient;
import com.actigence.aal.dto.ApiAccessLog;
import com.actigence.aal.dto.NameValue;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAccessLoggingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ApiAccessLoggingFilter.class);
    private final SQSClient sqsClient;
    private String clientId;

    public ApiAccessLoggingFilter() {
        this.sqsClient = new SQSClient();
    }

    public ApiAccessLoggingFilter(SQSClient sqsClient) {
        this.sqsClient = sqsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ZonedDateTime requestStartTime = ZonedDateTime.now();
        HttpRequestCachingWrapper requestWrapper = new HttpRequestCachingWrapper((HttpServletRequest)request);
        HttpResponseCachingWrapper responseWrapper = new HttpResponseCachingWrapper((HttpServletResponse)response);
        try {
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            response.getOutputStream().write(responseWrapper.getBytes());
        }
        finally {
            this.generateEvent(requestWrapper, responseWrapper, requestStartTime);
        }
    }

    private void generateEvent(HttpRequestCachingWrapper requestWrapper, HttpResponseCachingWrapper responseWrapper, ZonedDateTime startTime) {
        try {
            ApiAccessLog apiInvocationEvent = ApiAccessLog.builder().logId(UUID.randomUUID().toString()).clientId(this.clientId).requestStartTime(startTime).requestEndTime(ZonedDateTime.now()).requestUri(requestWrapper.getRequestURI()).requestQueryString(requestWrapper.getQueryString()).requestBody(requestWrapper.getBody()).requestHeaders(this.requestHeaders(requestWrapper)).responseBody(new String(responseWrapper.getBytes())).responseHttpStatus(responseWrapper.getStatusCode()).build();
            this.sqsClient.publish(apiInvocationEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<NameValue> requestHeaders(HttpRequestCachingWrapper requestCachingWrapper) {
        return Collections.list(requestCachingWrapper.getHeaderNames()).stream().map(it -> new NameValue((String)it, requestCachingWrapper.getHeader((String)it))).collect(Collectors.toList());
    }

    public void init(FilterConfig filterConfig) {
        try {
            this.clientId = filterConfig.getInitParameter("clientId");
        }
        catch (Exception e) {
            this.clientId = null;
        }
    }

    public void destroy() {
    }
}

