/*
 * Decompiled with CFR 0.152.
 */
package com.actigence.aal.aws;

import com.actigence.aal.dto.ApiAccessLog;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.google.gson.Gson;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQSClient {
    private static final Logger log = LoggerFactory.getLogger(SQSClient.class);
    private static final String QUEUE_NAME_ENV = "AAL_QUEUE_NAME";
    private static final String QUEUE_NAME_SYS_PROP = "all.queue_name";
    private static final String CLIENT_ID_ENV = "AAL_CLIENT_ID";
    private static final String CLIENT_ID_SYS_PROP = "aal.client_id";
    private static final String DEFAULT_QUEUE_NAME = "aal_inbound_request_logging_queue";
    private final Gson gson;
    private final String queueUrl;
    private final AmazonSQS sqs = this.initSQSClient();

    public SQSClient() {
        this.queueUrl = this.initQueue();
        this.gson = new Gson();
    }

    public void publish(ApiAccessLog apiAccessLog) {
        apiAccessLog.setClientId(this.getClientId());
        SendMessageRequest send_msg_request = new SendMessageRequest().withQueueUrl(this.queueUrl).withMessageBody(this.gson.toJson((Object)apiAccessLog));
        this.sqs.sendMessage(send_msg_request);
        log.debug("Message sent successfully: {}", (Object)apiAccessLog.getLogId());
    }

    private AmazonSQS initSQSClient() {
        AmazonSQS sqs = AmazonSQSClientBuilder.defaultClient();
        return sqs;
    }

    private String initQueue() {
        String queueName = this.getQueueName();
        log.debug("Connecting to SQS queue name: {}", (Object)queueName);
        try {
            CreateQueueResult createQueueResult = this.sqs.createQueue(queueName);
        }
        catch (AmazonSQSException e) {
            if (!e.getErrorCode().equals("QueueAlreadyExists")) {
                log.error("Error creating queue with name: {}", (Object)queueName);
                throw e;
            }
            log.debug("Queue already exists with name: {}", (Object)queueName);
        }
        String queueUrl = this.sqs.getQueueUrl(queueName).getQueueUrl();
        log.debug("Connected to SQS queue url: {}", (Object)queueUrl);
        return queueUrl;
    }

    private String getQueueName() {
        return Optional.ofNullable(System.getenv(QUEUE_NAME_ENV)).orElseGet(() -> Optional.ofNullable(System.getProperty(QUEUE_NAME_SYS_PROP)).orElse(DEFAULT_QUEUE_NAME));
    }

    private String getClientId() {
        return Optional.ofNullable(System.getenv(CLIENT_ID_ENV)).orElseGet(() -> Optional.ofNullable(System.getProperty(CLIENT_ID_SYS_PROP)).orElse(null));
    }
}

