/*
 * Decompiled with CFR 0.152.
 */
package com.addicticks.net.httpsupload;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLUtils {
    private static final Logger LOGGER = Logger.getLogger(SSLUtils.class.getName());
    private static final HostnameVerifier ALLHOSTSVALID_HOSTNAMEVERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    private SSLUtils() {
    }

    private static TrustManager[] getNonValidatingTrustManagers(String[] acceptedIssuers) {
        CustomX509TrustManager x509TrustManager = new CustomX509TrustManager(acceptedIssuers);
        return new TrustManager[]{x509TrustManager};
    }

    public static void setNoValidate(HttpsURLConnection connection, String[] acceptedIssuers) {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, SSLUtils.getNonValidatingTrustManagers(acceptedIssuers), new SecureRandom());
            connection.setSSLSocketFactory(sc.getSocketFactory());
            connection.setHostnameVerifier(ALLHOSTSVALID_HOSTNAMEVERIFIER);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.log(Level.SEVERE, "Algorithm SSL not found.", ex);
        }
        catch (KeyManagementException ex) {
            LOGGER.log(Level.SEVERE, "Error initializing SSL security context.", ex);
        }
    }

    public static void setNoValidate(HttpsURLConnection connection) {
        SSLUtils.setNoValidate(connection, null);
    }

    private static class CustomX509TrustManager
    implements X509TrustManager {
        private final String[] acceptedIssuers;

        public CustomX509TrustManager(String[] acceptedIssuers) {
            this.acceptedIssuers = acceptedIssuers;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            if (certs == null || certs.length == 0) {
                throw new IllegalArgumentException("certs parameter cannot be null or zero length");
            }
            if (authType == null || authType.length() == 0) {
                throw new IllegalArgumentException("authType parameter cannot be null or zero length");
            }
            boolean accepted = false;
            String serverCertIssuer = null;
            if (this.acceptedIssuers != null) {
                if (certs[0].getIssuerX500Principal() == null || certs[0].getIssuerX500Principal().getName() == null) {
                    throw new CertificateException("Certificate at endpoint can't be trusted. Has no issuer information. Cannot validate against list of accepted issuers.");
                }
                try {
                    List<Rdn> rdns = new LdapName(certs[0].getIssuerX500Principal().getName()).getRdns();
                    boolean orgFound = false;
                    for (Rdn rdn : rdns) {
                        if (!rdn.getType().equals("O")) continue;
                        orgFound = true;
                        if (rdn.getValue() == null) {
                            throw new CertificateException("Certificate's Issuer Organization (O) field is empty. Cannot validate against list of accepted issuers.");
                        }
                        serverCertIssuer = (String)rdn.getValue();
                        if (!Arrays.asList(this.acceptedIssuers).contains(serverCertIssuer)) continue;
                        accepted = true;
                        break;
                    }
                    if (!orgFound) {
                        throw new CertificateException("No Organization (0) field found in the issuer section of server's certificate. Cannot validate against list of accepted issuers.");
                    }
                    if (!accepted) {
                        throw new CertificateException("Certificate at endpoint can't be trusted. It is issued by \"" + serverCertIssuer + "\" which is not on the list of accepted issuers.");
                    }
                }
                catch (InvalidNameException ex) {
                    throw new CertificateException("Certificate at endpoint can't be trusted (LDAP name syntax violation). Cannot validate against list of accepted issuers.", ex);
                }
            }
        }
    }
}

