/*
 * Decompiled with CFR 0.152.
 */
package com.addicticks.net.httpsupload;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Utils {
    private static final BigDecimal BDEC_KB = new BigDecimal(1024L);
    private static final BigDecimal BDEC_MB = new BigDecimal(0x100000L);
    private static final BigDecimal BDEC_GB = new BigDecimal(0x40000000L);

    private Utils() {
    }

    public static String fileSizeAsStr(long size) {
        BigDecimal bd = BigDecimal.valueOf(size);
        if (size < 1024L) {
            if (size == 1L) {
                return "1 byte";
            }
            return size + " bytes";
        }
        if (size < 0x100000L) {
            return bd.divide(BDEC_KB, 0, RoundingMode.HALF_UP).toPlainString() + " KB";
        }
        if (size < 0x40000000L) {
            return bd.divide(BDEC_MB, 1, RoundingMode.HALF_UP).toPlainString() + " MB";
        }
        return bd.divide(BDEC_GB, 2, RoundingMode.HALF_UP).toPlainString() + " GB";
    }

    public static String stripHtml(String inp) {
        boolean intag = false;
        boolean tagHasEnded = false;
        StringBuilder outp = new StringBuilder();
        StringBuilder tagName = new StringBuilder();
        boolean ignoreContents = false;
        for (int i = 0; i < inp.length(); ++i) {
            char ch = inp.charAt(i);
            if (!intag && ch == '<') {
                intag = true;
                tagHasEnded = false;
                continue;
            }
            if (intag) {
                if (ch == '/' || ch == ' ' || ch == '>') {
                    tagHasEnded = true;
                }
                if (!tagHasEnded) {
                    tagName.append(ch);
                }
            }
            if (intag && inp.charAt(i) == '>') {
                intag = false;
                String tName = tagName.toString();
                if (tName.equalsIgnoreCase("br") || tName.equalsIgnoreCase("p") || tName.equalsIgnoreCase("h1") || tName.equalsIgnoreCase("h2") || tName.equalsIgnoreCase("h3")) {
                    outp.append(System.lineSeparator());
                }
                ignoreContents = tName.equalsIgnoreCase("style");
                tagName.setLength(0);
                continue;
            }
            if (intag || ignoreContents) continue;
            outp = outp.append(ch);
        }
        return outp.toString();
    }
}

