/*
 * Decompiled with CFR 0.152.
 */
package com.addicticks.net.httpsupload;

import com.addicticks.net.httpsupload.HttpsFileUploaderConfig;
import com.addicticks.net.httpsupload.HttpsFileUploaderResult;
import com.addicticks.net.httpsupload.SSLUtils;
import com.addicticks.net.httpsupload.UploadItem;
import com.addicticks.net.httpsupload.UploadItemFile;
import com.addicticks.net.httpsupload.UploadProgress;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;

public class HttpsFileUploader {
    private static final int CHUNK_SIZE_IN_BYTES = 8192;
    private static final String CRLF = "\r\n";
    private static final String TWOHYPHENS = "--";
    private static final String MULTIPART_BOUNDARY = "*****X99611299X******";

    private HttpsFileUploader() {
    }

    public static HttpsFileUploaderResult upload(HttpsFileUploaderConfig config, Map<String, ? extends UploadItem> uploadFiles, Map<String, String> otherFields, UploadProgress progressNotifier) throws IOException {
        Serializable mpFooters;
        Serializable mpFooters2;
        boolean byteSizeIsKnown = HttpsFileUploader.byteSizeIsKnown(uploadFiles.values());
        HttpURLConnection httpsUrlConnection = HttpsFileUploader.setup(config);
        long totalBytes = 0L;
        ArrayList<Object> uploadFilesX = new ArrayList<Object>();
        ArrayList<UploadOtherField> uploadFieldsX = new ArrayList<UploadOtherField>();
        String globalFooter = "--*****X99611299X******--\r\n";
        for (String uploadFormFieldName : uploadFiles.keySet()) {
            String mimeType = uploadFiles.get(uploadFormFieldName).getMimeType();
            String hintFilename = uploadFiles.get(uploadFormFieldName).getHintFilename();
            ArrayList<String> mpHeaders = new ArrayList<String>();
            mpFooters2 = new ArrayList<String>();
            mpHeaders.add("--*****X99611299X******\r\n");
            mpHeaders.add("Content-Disposition: form-data; name=\"" + uploadFormFieldName + "\";filename=\"" + hintFilename + "\"" + CRLF);
            mpHeaders.add("Content-Type: " + mimeType + CRLF);
            mpHeaders.add(CRLF);
            ((ArrayList)mpFooters2).add(CRLF);
            UploadFile uploadFile = new UploadFile(uploadFormFieldName, uploadFiles.get(uploadFormFieldName), mpHeaders, (ArrayList<String>)mpFooters2);
            uploadFilesX.add(uploadFile);
            totalBytes += uploadFile.getTotalByteSize();
        }
        if (otherFields != null) {
            for (String otherField : otherFields.keySet()) {
                ArrayList<String> mpHeaders = new ArrayList<String>();
                mpFooters = new ArrayList();
                mpHeaders.add("--*****X99611299X******\r\n");
                mpHeaders.add("Content-Disposition: form-data; name=\"" + otherField + "\"" + CRLF);
                mpHeaders.add(CRLF);
                ((ArrayList)mpFooters).add(CRLF);
                UploadOtherField uploadOtherField = new UploadOtherField(otherField, otherFields.get(otherField), mpHeaders, (ArrayList<String>)mpFooters);
                uploadFieldsX.add(uploadOtherField);
                totalBytes += uploadOtherField.getTotalByteSize();
            }
        }
        totalBytes += (long)globalFooter.length();
        if (byteSizeIsKnown) {
            httpsUrlConnection.setFixedLengthStreamingMode(totalBytes);
        }
        long startTime = System.currentTimeMillis();
        DataOutputStream out = new DataOutputStream(httpsUrlConnection.getOutputStream());
        mpFooters = null;
        try {
            long totalDataBytes = 0L;
            for (UploadFile uploadFile : uploadFilesX) {
                totalDataBytes += uploadFile.getUploadItem().getSizeInBytes() == -1L ? 0L : uploadFile.getUploadItem().getSizeInBytes();
            }
            if (progressNotifier != null) {
                progressNotifier.uploadStart(uploadFilesX.size(), totalDataBytes);
            }
            long totalDataBytesSent = 0L;
            for (UploadFile uploadFile : uploadFilesX) {
                for (String string : uploadFile.getMpHeaders()) {
                    out.writeBytes(string);
                }
                Throwable throwable = null;
                try (InputStream is = uploadFile.getUploadItem().getInputStream();){
                    int bytes_read;
                    byte[] buffer = new byte[8192];
                    int total_written = 0;
                    int filesize = (int)uploadFile.getUploadItem().getSizeInBytes();
                    int notif_size_total = (int)(uploadFile.getUploadItem().getSizeInBytes() == -1L ? 524288L : uploadFile.getUploadItem().getSizeInBytes());
                    int notif_size = notif_size_total / 100;
                    long last_notif = 0L;
                    int prevPct = -1;
                    prevPct = HttpsFileUploader.notifyProgress(progressNotifier, uploadFile.getUploadItem().getFile(), 0, filesize, prevPct);
                    while ((bytes_read = is.read(buffer)) != -1) {
                        out.write(buffer, 0, bytes_read);
                        if ((long)(total_written += bytes_read) - last_notif < (long)notif_size) continue;
                        prevPct = HttpsFileUploader.notifyProgress(progressNotifier, uploadFile.getUploadItem().getFile(), total_written, filesize, prevPct);
                        last_notif = total_written;
                    }
                    HttpsFileUploader.notifyProgress(progressNotifier, uploadFile.getUploadItem().getFile(), filesize, filesize, prevPct);
                    totalDataBytesSent += (long)total_written;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                for (String string : uploadFile.getMpFooters()) {
                    out.writeBytes(string);
                }
                out.flush();
            }
            for (UploadOtherField uploadOtherField : uploadFieldsX) {
                for (String string : uploadOtherField.getMpHeaders()) {
                    out.writeBytes(string);
                }
                out.writeBytes(uploadOtherField.getFieldValue());
                for (String string : uploadOtherField.getMpFooters()) {
                    out.writeBytes(string);
                }
            }
            out.writeBytes(globalFooter);
            if (progressNotifier != null) {
                progressNotifier.uploadEnd(totalDataBytesSent, System.currentTimeMillis() - startTime);
            }
        }
        catch (Throwable totalDataBytes) {
            mpFooters = totalDataBytes;
            throw totalDataBytes;
        }
        finally {
            if (out != null) {
                if (mpFooters != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable totalDataBytes) {
                        ((Throwable)mpFooters).addSuppressed(totalDataBytes);
                    }
                } else {
                    out.close();
                }
            }
        }
        int httpStatus = httpsUrlConnection.getResponseCode();
        StringBuilder stringBuilder = null;
        if (httpStatus != 401) {
            try {
                BufferedReader responseStreamReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(httpsUrlConnection.getInputStream())));
                mpFooters2 = null;
                try {
                    String line;
                    stringBuilder = new StringBuilder();
                    while ((line = responseStreamReader.readLine()) != null) {
                        stringBuilder.append(line).append(System.lineSeparator());
                    }
                }
                catch (Throwable throwable) {
                    mpFooters2 = throwable;
                    throw throwable;
                }
                finally {
                    if (responseStreamReader != null) {
                        if (mpFooters2 != null) {
                            try {
                                responseStreamReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)mpFooters2).addSuppressed(throwable);
                            }
                        } else {
                            responseStreamReader.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                try (BufferedReader responseStreamReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(httpsUrlConnection.getErrorStream())));){
                    String string;
                    stringBuilder = new StringBuilder();
                    while ((string = responseStreamReader.readLine()) != null) {
                        stringBuilder.append(string).append(System.lineSeparator());
                    }
                }
            }
        }
        String responseText = null;
        if (stringBuilder != null) {
            responseText = stringBuilder.toString();
        }
        return new HttpsFileUploaderResult(httpStatus, responseText);
    }

    public static HttpsFileUploaderResult upload(HttpsFileUploaderConfig config, File uploadFile) throws IOException {
        HashMap<String, UploadItemFile> map = new HashMap<String, UploadItemFile>();
        map.put("file", new UploadItemFile(uploadFile));
        return HttpsFileUploader.upload(config, map, null, null);
    }

    private static boolean byteSizeIsKnown(Collection<? extends UploadItem> uploadItems) {
        for (UploadItem uploadItem : uploadItems) {
            if (uploadItem.getSizeInBytes() != -1L) continue;
            return false;
        }
        return true;
    }

    private static HttpURLConnection setup(HttpsFileUploaderConfig config) throws MalformedURLException, IOException {
        HttpURLConnection httpUrlConnection;
        boolean isHttps = false;
        URL url = config.getURL();
        if (url.getProtocol().equalsIgnoreCase("https")) {
            isHttps = true;
        }
        if (config.usesProxy()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxyAddress(), config.getProxyPort()));
            httpUrlConnection = (HttpURLConnection)url.openConnection(proxy);
        } else {
            httpUrlConnection = (HttpURLConnection)url.openConnection();
        }
        if (!config.isValidateCertificates() && isHttps) {
            SSLUtils.setNoValidate((HttpsURLConnection)httpUrlConnection, config.getAcceptedIssuers());
        }
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setConnectTimeout(config.getConnectTimeoutMs());
        httpUrlConnection.setReadTimeout(config.getReadTimeoutMs());
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Connection", "Keep-Alive");
        httpUrlConnection.setRequestProperty("Cache-Control", "no-cache");
        httpUrlConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****X99611299X******");
        if (config.getAdditionalHeaders() != null) {
            for (Map.Entry entry : config.getAdditionalHeaders().entrySet()) {
                httpUrlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (config.endpointRequiresAuthentication()) {
            String authString = config.getEndpointUsername() + ":" + config.getEndpointPassword();
            String string = DatatypeConverter.printBase64Binary((byte[])authString.getBytes());
            httpUrlConnection.setRequestProperty("Authorization", "Basic " + string);
        }
        return httpUrlConnection;
    }

    private static int getBytesSize(ArrayList<String> arr) {
        int count = 0;
        for (String str : arr) {
            count += str.length();
        }
        return count;
    }

    private static int notifyProgress(UploadProgress notifier, File file, int bytesWritten, int bytesTotal, int prevPct) {
        if (notifier != null) {
            int pct = (int)((long)bytesWritten * 100L / (long)bytesTotal);
            if (prevPct != pct) {
                notifier.uploadProgress(file, bytesTotal, pct);
                return pct;
            }
            return prevPct;
        }
        return prevPct;
    }

    private static class UploadOtherField {
        private final ArrayList<String> mpFooters;
        private final ArrayList<String> mpHeaders;
        private final String formFieldName;
        private final String fieldValue;

        public UploadOtherField(String formFieldName, String fieldValue, ArrayList<String> mpHeaders, ArrayList<String> mpFooters) {
            this.mpHeaders = mpHeaders;
            this.mpFooters = mpFooters;
            this.formFieldName = formFieldName;
            this.fieldValue = fieldValue == null ? "" : fieldValue;
        }

        public ArrayList<String> getMpFooters() {
            return this.mpFooters;
        }

        public ArrayList<String> getMpHeaders() {
            return this.mpHeaders;
        }

        public String getFormFieldName() {
            return this.formFieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public long getTotalByteSize() {
            return HttpsFileUploader.getBytesSize(this.mpHeaders) + this.fieldValue.length() + HttpsFileUploader.getBytesSize(this.mpFooters);
        }
    }

    private static class UploadFile {
        private final UploadItem uploadItem;
        private final ArrayList<String> mpFooters;
        private final ArrayList<String> mpHeaders;
        private final String formFieldName;

        public UploadFile(String formFieldName, UploadItem uploadItem, ArrayList<String> mpHeaders, ArrayList<String> mpFooters) {
            this.uploadItem = uploadItem;
            this.mpHeaders = mpHeaders;
            this.mpFooters = mpFooters;
            this.formFieldName = formFieldName;
        }

        public UploadItem getUploadItem() {
            return this.uploadItem;
        }

        public ArrayList<String> getMpFooters() {
            return this.mpFooters;
        }

        public ArrayList<String> getMpHeaders() {
            return this.mpHeaders;
        }

        public String getFormFieldName() {
            return this.formFieldName;
        }

        public long getTotalByteSize() {
            return (long)HttpsFileUploader.getBytesSize(this.mpHeaders) + this.uploadItem.getSizeInBytes() + (long)HttpsFileUploader.getBytesSize(this.mpFooters);
        }
    }
}

