/*
 * Decompiled with CFR 0.152.
 */
package com.addicticks.net.httpsupload;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpsFileUploaderConfig {
    private static final String[] RESTRICTED_HTTP_HEADERS = new String[]{"Connection", "Cache-Control", "Content-Type", "Content-Length", "Authorization"};
    private String endpointUsername = null;
    private String endpointPassword;
    private boolean validateCertificates = true;
    private String[] acceptedIssuers = null;
    private String proxyAddress = null;
    private int proxyPort = 8080;
    private final URL url;
    private Map<String, String> additionalHeaders;
    private int connectTimeoutMs = 10000;
    private int readTimeoutMs = 5000;
    public static final int CONNECT_TIMEOUT_MS = 10000;
    public static final int READ_TIMEOUT_MS = 5000;

    public HttpsFileUploaderConfig(URL url) {
        this.url = url;
    }

    public String getEndpointUsername() {
        return this.endpointUsername;
    }

    public void setEndpointUsername(String endpointUsername) {
        this.endpointUsername = endpointUsername;
    }

    public String getEndpointPassword() {
        return this.endpointPassword;
    }

    public void setEndpointPassword(String endpointPassword) {
        this.endpointPassword = endpointPassword;
    }

    public boolean isValidateCertificates() {
        return this.validateCertificates;
    }

    public void setValidateCertificates(boolean validateCertificates) {
        this.validateCertificates = validateCertificates;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean usesProxy() {
        return this.proxyAddress != null;
    }

    public boolean endpointRequiresAuthentication() {
        return this.endpointUsername != null;
    }

    public URL getURL() {
        return this.url;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public void setReadTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }

    public String[] getAcceptedIssuers() {
        return this.acceptedIssuers;
    }

    public void setAcceptedIssuers(String[] acceptedIssuers) {
        this.acceptedIssuers = acceptedIssuers;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> e : additionalHeaders.entrySet()) {
            boolean found = false;
            for (String restrictedHeaderField : RESTRICTED_HTTP_HEADERS) {
                if (!e.getKey().equalsIgnoreCase(restrictedHeaderField)) continue;
                found = true;
                break;
            }
            if (found) continue;
            newMap.put(e.getKey(), e.getValue());
        }
        this.additionalHeaders = newMap;
    }
}

