/*
 * Decompiled with CFR 0.152.
 */
package com.addicticks.net.httpsupload;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    private static final BigDecimal BDEC_KB = new BigDecimal(1024L);
    private static final BigDecimal BDEC_MB = new BigDecimal(0x100000L);
    private static final BigDecimal BDEC_GB = new BigDecimal(0x40000000L);

    private Utils() {
    }

    public static String fileSizeAsStr(long size) {
        BigDecimal bd = BigDecimal.valueOf(size);
        if (size < 1024L) {
            if (size == 1L) {
                return "1 byte";
            }
            return size + " bytes";
        }
        if (size < 0x100000L) {
            return bd.divide(BDEC_KB, 0, RoundingMode.HALF_UP).toPlainString() + " KB";
        }
        if (size < 0x40000000L) {
            return bd.divide(BDEC_MB, 1, RoundingMode.HALF_UP).toPlainString() + " MB";
        }
        return bd.divide(BDEC_GB, 2, RoundingMode.HALF_UP).toPlainString() + " GB";
    }

    public static String stripHtml(String str) {
        boolean intag = false;
        boolean tagHasEnded = false;
        StringBuilder outp = new StringBuilder();
        StringBuilder tagName = new StringBuilder();
        boolean ignoreContents = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!intag && ch == '<') {
                intag = true;
                tagHasEnded = false;
                continue;
            }
            if (intag) {
                if (ch == '/' || ch == ' ' || ch == '>') {
                    tagHasEnded = true;
                }
                if (!tagHasEnded) {
                    tagName.append(ch);
                }
            }
            if (intag && str.charAt(i) == '>') {
                intag = false;
                String tName = tagName.toString();
                if (tName.equalsIgnoreCase("br") || tName.equalsIgnoreCase("p") || tName.equalsIgnoreCase("h1") || tName.equalsIgnoreCase("h2") || tName.equalsIgnoreCase("h3")) {
                    outp.append(System.lineSeparator());
                }
                ignoreContents = tName.equalsIgnoreCase("style");
                tagName.setLength(0);
                continue;
            }
            if (intag || ignoreContents) continue;
            outp = outp.append(ch);
        }
        return outp.toString();
    }

    public static String getHttpStatusCodeText(int sc) {
        HttpStatusCode sCode = HttpStatusCode.fromNumStatusCode(sc);
        if (sCode == null) {
            return sc + " <unknown status code>";
        }
        return sCode.toString();
    }

    public static enum HttpStatusCode {
        HTTP_CONTINUE(100, "Continue "),
        HTTP_SWITCHING_PROTOCOLS(101, "Switching Protocols "),
        HTTP_PROCESSING(102, "Processing "),
        HTTP_OK(200, "OK "),
        HTTP_CREATED(201, "Created "),
        HTTP_ACCEPTED(202, "Accepted "),
        HTTP_NON_AUTHORITATIVE_INFORMATION(203, "Non Authoritative Information "),
        HTTP_NO_CONTENT(204, "No Content "),
        HTTP_RESET_CONTENT(205, "Reset Content "),
        HTTP_PARTIAL_CONTENT(206, "Partial Content "),
        HTTP_MULTI_STATUS(207, "Multi-Status  or Partial Update OK"),
        HTTP_MULTIPLE_CHOICES(300, "Multiple Choices "),
        HTTP_MOVED_PERMANENTLY(301, "Moved Permanently "),
        HTTP_MOVED_TEMPORARILY(302, "Moved Temporarily  "),
        HTTP_SEE_OTHER(303, "See Other "),
        HTTP_NOT_MODIFIED(304, "Not Modified "),
        HTTP_USE_PROXY(305, "Use Proxy "),
        HTTP_TEMPORARY_REDIRECT(307, "Temporary Redirect "),
        HTTP_BAD_REQUEST(400, "Bad Request "),
        HTTP_UNAUTHORIZED(401, "Unauthorized "),
        HTTP_PAYMENT_REQUIRED(402, "Payment Required "),
        HTTP_FORBIDDEN(403, "Forbidden "),
        HTTP_NOT_FOUND(404, "Not Found "),
        HTTP_METHOD_NOT_ALLOWED(405, "Method Not Allowed "),
        HTTP_NOT_ACCEPTABLE(406, "Not Acceptable "),
        HTTP_PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required "),
        HTTP_REQUEST_TIMEOUT(408, "Request Timeout"),
        HTTP_CONFLICT(409, "Conflict "),
        HTTP_GONE(410, "Gone "),
        HTTP_LENGTH_REQUIRED(411, "Length Required "),
        HTTP_PRECONDITION_FAILED(412, "Precondition Failed "),
        HTTP_REQUEST_TOO_LONG(413, "Request Entity Too Large"),
        HTTP_REQUEST_URI_TOO_LONG(414, "Request-URI Too Long "),
        HTTP_UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type "),
        HTTP_REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable "),
        HTTP_EXPECTATION_FAILED(417, "Expectation Failed "),
        HTTP_INSUFFICIENT_SPACE_ON_RESOURCE(419, "Insufficient Space on Resource"),
        HTTP_METHOD_FAILURE(420, "Method Failure"),
        HTTP_UNPROCESSABLE_ENTITY(422, "Unprocessable Entity "),
        HTTP_LOCKED(423, "Locked "),
        HTTP_FAILED_DEPENDENCY(424, "Failed Dependency "),
        HTTP_INTERNAL_SERVER_ERROR(500, "Server Error "),
        HTTP_NOT_IMPLEMENTED(501, "Not Implemented "),
        HTTP_BAD_GATEWAY(502, "Bad Gateway "),
        HTTP_SERVICE_UNAVAILABLE(503, "Service Unavailable "),
        HTTP_GATEWAY_TIMEOUT(504, "Gateway Timeout "),
        HTTP_HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version Not Supported "),
        HTTP_INSUFFICIENT_STORAGE(507, "Insufficient Storage ");

        private final int sc;
        private final String txt;
        private static final Map<Integer, HttpStatusCode> map;

        private HttpStatusCode(int sc, String txt) {
            this.sc = sc;
            this.txt = txt;
        }

        public int getStatusCode() {
            return this.sc;
        }

        public String getText() {
            return this.txt;
        }

        public static HttpStatusCode fromNumStatusCode(int sc) {
            return map.get(sc);
        }

        public String toString() {
            return this.sc + " " + this.txt;
        }

        static {
            map = new HashMap<Integer, HttpStatusCode>();
            for (HttpStatusCode sCode : HttpStatusCode.values()) {
                if (map.put(sCode.sc, sCode) == null) continue;
                throw new RuntimeException("Status code " + sCode.sc + " already exists in this enum. Please remove duplicate");
            }
        }
    }
}

