/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.CallableNode;
import com.aegisql.java_path.ClassRegistry;
import com.aegisql.java_path.JavaPathRuntimeException;
import com.aegisql.java_path.NoPathElement;
import com.aegisql.java_path.PathElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CallTree {
    private static final Map<Class, CallTree> cache = new HashMap<Class, CallTree>();
    private final ClassRegistry classRegistry;
    private final Map<String, Map<Class<?>, CallableNode>> namesMap = new HashMap();
    private final Map<String, CallableNode> fieldsMap = new HashMap<String, CallableNode>();
    private final Class<?> aClass;
    private final Set<String> knownLabels = new HashSet<String>();

    public CallTree() {
        this.classRegistry = new ClassRegistry();
        this.aClass = null;
    }

    private CallTree(Class<?> c, ClassRegistry classRegistry) {
        Class<?> sClass;
        this.classRegistry = classRegistry;
        this.aClass = c;
        Arrays.stream(c.getDeclaredFields()).forEach(this::addField);
        Arrays.stream(c.getDeclaredMethods()).forEach(this::addMethod);
        if (!Modifier.isAbstract(c.getModifiers())) {
            Arrays.stream(c.getDeclaredConstructors()).forEach(this::addConstructor);
        }
        if ((sClass = c.getSuperclass()) != null && sClass != Object.class) {
            CallTree inner = new CallTree(sClass, classRegistry);
            inner.knownLabels.forEach(l -> {
                if (this.knownLabels.contains(l)) {
                    throw new JavaPathRuntimeException("Found duplicate label " + l + " in " + c.getSimpleName() + " conflicting with " + sClass.getSimpleName());
                }
                this.knownLabels.add((String)l);
            });
            this.namesMap.putAll(inner.namesMap);
            this.fieldsMap.putAll(inner.fieldsMap);
        }
    }

    public static CallTree forClass(Class<?> c) {
        return cache.computeIfAbsent(c, cls -> new CallTree(c, new ClassRegistry()));
    }

    public static CallTree forClass(Class<?> c, ClassRegistry classRegistry) {
        return cache.computeIfAbsent(c, cls -> new CallTree(c, classRegistry));
    }

    private void addConstructor(Constructor constructor) {
        Map parameterMap = this.namesMap.computeIfAbsent("new", n -> new HashMap());
        LinkedList<Class> args = new LinkedList<Class>();
        args.addAll(Arrays.asList(constructor.getParameterTypes()));
        if (constructor.getParameterCount() == 0) {
            CallableNode callableNode = parameterMap.computeIfAbsent(null, p -> new CallableNode(this.aClass, 0, this.classRegistry));
            callableNode.addNode(new LinkedList<Class>(), constructor);
        } else {
            Class pClass = (Class)args.pollFirst();
            CallableNode callableNode = parameterMap.computeIfAbsent(pClass, p -> new CallableNode(this.aClass, 0, this.classRegistry));
            callableNode.addNode(args, constructor);
        }
    }

    private void addField(Field f) {
        String name = f.getName();
        NoPathElement noPathElement = f.getAnnotation(NoPathElement.class);
        PathElement pathElement = f.getAnnotation(PathElement.class);
        if (noPathElement != null) {
            if (pathElement == null) {
                return;
            }
            throw new JavaPathRuntimeException("Field " + String.valueOf(f) + " has both @Label and @NoLabel annotations. Please remove one.");
        }
        CallableNode callableNode = this.fieldsMap.computeIfAbsent(name, p -> new CallableNode(f.getType(), 0, this.classRegistry));
        callableNode.addNode(f);
        if (pathElement != null) {
            Arrays.stream(pathElement.value()).forEach(l -> {
                if (this.knownLabels.contains(l)) {
                    throw new JavaPathRuntimeException("Duplicated label " + l + " found for field " + String.valueOf(f));
                }
                this.knownLabels.add((String)l);
                CallableNode labeledNode = this.fieldsMap.computeIfAbsent((String)l, p -> new CallableNode(f.getType(), 0, this.classRegistry));
                labeledNode.addNode(f);
            });
        }
    }

    public void addMethod(Method method) {
        String name = method.getName();
        NoPathElement noPathElement = method.getAnnotation(NoPathElement.class);
        PathElement pathElement = method.getAnnotation(PathElement.class);
        if (noPathElement != null) {
            if (pathElement == null) {
                return;
            }
            throw new JavaPathRuntimeException("Method " + String.valueOf(method) + " has both @Label and @NoLabel annotations. Please remove one.");
        }
        Map parameterMap = this.namesMap.computeIfAbsent(name, n -> new HashMap());
        LinkedList args = new LinkedList();
        args.addAll(Arrays.asList(method.getParameterTypes()));
        if (method.getParameterCount() == 0) {
            CallableNode callableNode = parameterMap.computeIfAbsent(null, p -> new CallableNode(this.aClass, 0, this.classRegistry));
            callableNode.addNode(new LinkedList(), method);
        } else {
            Class pClass = (Class)args.pollFirst();
            CallableNode callableNode = parameterMap.computeIfAbsent(pClass, p -> new CallableNode(this.aClass, 0, this.classRegistry));
            callableNode.addNode(args, method);
        }
        if (pathElement != null) {
            Arrays.stream(pathElement.value()).filter(l -> !l.equals(name)).peek(l -> {
                if (this.knownLabels.contains(l) || this.namesMap.containsKey(l) && parameterMap != this.namesMap.get(l)) {
                    throw new JavaPathRuntimeException("Method " + String.valueOf(method) + " labeled as '" + l + "' already has entry with the same name: " + String.valueOf(this.namesMap.get(l)));
                }
                this.knownLabels.add((String)l);
            }).forEach(l -> this.namesMap.put((String)l, parameterMap));
        }
    }

    public Method findMethod(String name, Class<?> ... args) {
        LinkedList argList = new LinkedList();
        if (args != null) {
            argList.addAll(Arrays.asList(args));
        }
        if (this.namesMap.containsKey(name)) {
            Map<Class<?>, CallableNode> parameterMap = this.namesMap.get(name);
            if (argList.size() == 0 && parameterMap.containsKey(null)) {
                return parameterMap.get(null).getMethod();
            }
            Class first = (Class)argList.pollFirst();
            if (parameterMap.containsKey(first)) {
                CallableNode callableNode = parameterMap.get(first);
                return callableNode.findMethod(argList);
            }
            for (Class<?> cls : parameterMap.keySet()) {
                if (!this.isAssignableFrom(cls, first)) continue;
                CallableNode callableNode = parameterMap.get(cls);
                Method method = callableNode.findMethod(argList);
                parameterMap.put(first, callableNode);
                return method;
            }
        }
        return null;
    }

    public Constructor findConstructor(Class<?> ... args) {
        LinkedList argList = new LinkedList();
        if (args != null) {
            argList.addAll(Arrays.asList(args));
        }
        if (this.namesMap.containsKey("new")) {
            Map<Class<?>, CallableNode> parameterMap = this.namesMap.get("new");
            if (argList.size() == 0 && parameterMap.containsKey(null)) {
                return parameterMap.get(null).getConstructor();
            }
            Class first = (Class)argList.pollFirst();
            if (parameterMap.containsKey(first)) {
                CallableNode callableNode = parameterMap.get(first);
                return callableNode.findConstructor(argList);
            }
            for (Class<?> cls : parameterMap.keySet()) {
                if (!this.isAssignableFrom(cls, first)) continue;
                CallableNode callableNode = parameterMap.get(cls);
                Constructor constructor = callableNode.findConstructor(argList);
                parameterMap.put(first, callableNode);
                return constructor;
            }
        }
        return null;
    }

    public Field findField(String name) {
        CallableNode callableNode = this.fieldsMap.get(name);
        if (callableNode == null) {
            return null;
        }
        Field field = callableNode.getField();
        if (field != null) {
            return field;
        }
        return null;
    }

    public Set<Method> findMethodCandidates(String name, Class<?> ... args) {
        LinkedList<Method> candidates = new LinkedList<Method>();
        LinkedList argList = new LinkedList();
        if (args != null) {
            argList.addAll(Arrays.asList(args));
        }
        if (this.namesMap.containsKey(name)) {
            Map<Class<?>, CallableNode> parameterMap = this.namesMap.get(name);
            if (argList.size() == 0 && parameterMap.containsKey(null)) {
                candidates.add(parameterMap.get(null).getMethod());
            } else {
                Class first = (Class)argList.pollFirst();
                if (first == null) {
                    List collect = parameterMap.values().stream().map(CallableNode::getMethod).collect(Collectors.toList());
                    candidates.addAll(collect);
                } else {
                    CallableNode callableNode = parameterMap.get(first);
                    if (callableNode != null) {
                        callableNode.findMethodCandidates(argList, candidates);
                    } else {
                        for (Class<?> cls : parameterMap.keySet()) {
                            if (!this.isAssignableFrom(cls, first)) continue;
                            callableNode = parameterMap.get(cls);
                            parameterMap.put(first, callableNode);
                            callableNode.findMethodCandidates(argList, candidates);
                            return new HashSet<Method>(candidates);
                        }
                    }
                }
            }
        }
        return new HashSet<Method>(candidates);
    }

    public Set<Constructor> findConstructorCandidates(Class<?> ... args) {
        LinkedList<Constructor> candidates = new LinkedList<Constructor>();
        LinkedList argList = new LinkedList();
        if (args != null) {
            argList.addAll(Arrays.asList(args));
        }
        if (this.namesMap.containsKey("new")) {
            Map<Class<?>, CallableNode> parameterMap = this.namesMap.get("new");
            if (argList.size() == 0 && parameterMap.containsKey(null)) {
                candidates.add(parameterMap.get(null).getConstructor());
            } else {
                Class first = (Class)argList.pollFirst();
                if (first == null) {
                    List collect = parameterMap.values().stream().map(CallableNode::getConstructor).collect(Collectors.toList());
                    candidates.addAll(collect);
                } else {
                    CallableNode callableNode = parameterMap.get(first);
                    if (callableNode != null) {
                        callableNode.findConstructorCandidates(argList, candidates);
                    } else {
                        for (Class<?> cls : parameterMap.keySet()) {
                            if (!this.isAssignableFrom(cls, first)) continue;
                            callableNode = parameterMap.get(cls);
                            parameterMap.put(first, callableNode);
                            callableNode.findConstructorCandidates(argList, candidates);
                            return new HashSet<Constructor>(candidates);
                        }
                    }
                }
            }
        }
        return new HashSet<Constructor>(candidates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CallTree{");
        sb.append(this.namesMap);
        sb.append('}');
        return sb.toString();
    }

    private boolean isAssignableFrom(Class<?> a, Class<?> b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.isPrimitive()) {
            if (b.isPrimitive()) {
                return a == b;
            }
            return false | (a.equals(Integer.TYPE) && b.equals(Integer.class)) | (a.equals(Long.TYPE) && b.equals(Long.class)) | (a.equals(Short.TYPE) && b.equals(Short.class)) | (a.equals(Byte.TYPE) && b.equals(Byte.class)) | (a.equals(Character.TYPE) && b.equals(Character.class)) | (a.equals(Boolean.TYPE) && b.equals(Boolean.class)) | (a.equals(Double.TYPE) && b.equals(Double.class)) | (a.equals(Float.TYPE) && b.equals(Float.class));
        }
        return a.isAssignableFrom(b);
    }
}

