/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.ClassRegistry;
import com.aegisql.java_path.JavaPathRuntimeException;
import com.aegisql.java_path.StringConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableNode {
    private static final Logger LOG = LoggerFactory.getLogger(CallableNode.class);
    private final ClassRegistry classRegistry;
    private final Class<?> myClass;
    private Map<Class<?>, CallableNode> parameterMap = new HashMap();
    private final int pos;
    private Method method;
    private Field field;
    private Constructor constructor;

    public CallableNode(Class<?> myClass, int pos, ClassRegistry classRegistry) {
        this.myClass = myClass;
        this.pos = pos;
        this.classRegistry = classRegistry;
    }

    public void addNode(LinkedList<Class<?>> classes, Method method) {
        if (classes.size() == 0) {
            this.method = method;
            if (Modifier.isStatic(method.getModifiers()) && method.getParameterCount() == 1 && method.getName().equals("valueOf")) {
                Class<?> returnType = method.getReturnType();
                Class<?> parameterType = method.getParameterTypes()[0];
                if (returnType == this.myClass && parameterType == String.class) {
                    this.classRegistry.getConverter(this.myClass.getName()).orElseGet(() -> this.classRegistry.registerStringConverter(this.myClass, StringConverter.factory(this.myClass, method.getName())));
                }
            }
        } else {
            CallableNode callableNode = this.parameterMap.computeIfAbsent(classes.pollFirst(), k -> new CallableNode((Class<?>)k, this.pos + 1, this.classRegistry));
            callableNode.addNode(classes, method);
        }
    }

    public void addNode(LinkedList<Class> classes, Constructor constructor) {
        if (classes.size() == 0) {
            this.constructor = constructor;
        } else {
            CallableNode callableNode = this.parameterMap.computeIfAbsent(classes.pollFirst(), k -> new CallableNode((Class<?>)k, this.pos + 1, this.classRegistry));
            callableNode.addNode(classes, constructor);
        }
    }

    public void addNode(Field f) {
        this.field = f;
    }

    public Method findMethod(LinkedList<Class<?>> argList) {
        if (argList.size() == 0) {
            return this.method;
        }
        Class<?> next = argList.pollFirst();
        if (this.parameterMap.containsKey(next)) {
            return this.parameterMap.get(next).findMethod(argList);
        }
        for (Class<?> cls : this.parameterMap.keySet()) {
            if (!cls.isAssignableFrom(next)) continue;
            CallableNode callableNode = this.parameterMap.get(cls);
            Method method = callableNode.findMethod(argList);
            this.parameterMap.put(next, callableNode);
            return method;
        }
        throw new JavaPathRuntimeException("findMethod failed to find assignable class " + String.valueOf(next) + " in " + String.valueOf(this.parameterMap.keySet()));
    }

    public Constructor findConstructor(LinkedList<Class<?>> argList) {
        if (argList.size() == 0) {
            return this.constructor;
        }
        Class<?> next = argList.pollFirst();
        if (this.parameterMap.containsKey(next)) {
            return this.parameterMap.get(next).findConstructor(argList);
        }
        for (Class<?> cls : this.parameterMap.keySet()) {
            if (!cls.isAssignableFrom(next)) continue;
            CallableNode callableNode = this.parameterMap.get(cls);
            Constructor constructor = callableNode.findConstructor(argList);
            this.parameterMap.put(next, callableNode);
            return constructor;
        }
        throw new JavaPathRuntimeException("findConstructor failed to find assignable class " + String.valueOf(next) + " in " + String.valueOf(this.parameterMap.keySet()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CallableNode{");
        sb.append("pos=").append(this.pos);
        sb.append(", class=").append(this.myClass);
        sb.append(", parameters=").append(this.parameterMap);
        if (this.method != null) {
            sb.append(", method=").append(this.method);
        }
        if (this.field != null) {
            sb.append(", field=").append(this.field);
        }
        if (this.constructor != null) {
            sb.append(", constructor=").append(this.constructor);
        }
        sb.append('}');
        return sb.toString();
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void findMethodCandidates(LinkedList<Class<?>> argList, List<Method> candidates) {
        if (argList.size() == 0) {
            candidates.add(this.method);
        } else {
            Class<?> next = argList.pollFirst();
            if (next == null) {
                List collect = this.parameterMap.values().stream().map(CallableNode::getMethod).collect(Collectors.toList());
                candidates.addAll(collect);
            } else {
                CallableNode callableNode = this.parameterMap.get(next);
                if (callableNode != null) {
                    callableNode.findMethodCandidates(argList, candidates);
                } else {
                    for (Class<?> cls : this.parameterMap.keySet()) {
                        if (!cls.isAssignableFrom(next)) continue;
                        callableNode = this.parameterMap.get(cls);
                        this.parameterMap.put(next, callableNode);
                        callableNode.findMethodCandidates(argList, candidates);
                        return;
                    }
                    throw new JavaPathRuntimeException("findMethodCandidates failed to find assignable class " + String.valueOf(next) + " in " + String.valueOf(this.parameterMap.keySet()));
                }
            }
        }
    }

    public void findConstructorCandidates(LinkedList<Class<?>> argList, List<Constructor> candidates) {
        if (argList.size() == 0) {
            candidates.add(this.constructor);
        } else {
            Class<?> next = argList.pollFirst();
            if (next == null) {
                List collect = this.parameterMap.values().stream().map(CallableNode::getConstructor).collect(Collectors.toList());
                candidates.addAll(collect);
            } else {
                CallableNode callableNode = this.parameterMap.get(next);
                if (callableNode != null) {
                    callableNode.findConstructorCandidates(argList, candidates);
                } else {
                    for (Class<?> cls : this.parameterMap.keySet()) {
                        if (!cls.isAssignableFrom(next)) continue;
                        callableNode = this.parameterMap.get(cls);
                        this.parameterMap.put(next, callableNode);
                        callableNode.findConstructorCandidates(argList, candidates);
                        return;
                    }
                    throw new JavaPathRuntimeException("findConstructorCandidates failed to find assignable class " + String.valueOf(next) + " in " + String.valueOf(this.parameterMap.keySet()));
                }
            }
        }
    }
}

