/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.JavaPath;
import com.aegisql.java_path.JavaPathRuntimeException;
import com.aegisql.java_path.StringConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;

public class ClassRegistry {
    private static final Map<String, StringConverter<?>> CONVERSION_MAP = new HashMap();
    private static final Map<String, Class<?>> CLASS_MAP = new HashMap();
    final Map<String, StringConverter<?>> conversionMap = new HashMap();
    final Map<String, Class<?>> classMap = new HashMap();
    final StringConverter<Function<?, ?>> defaultSupplier = alias -> type -> {
        Class aClass;
        int modifiers;
        if (type instanceof Class && !Modifier.isInterface(modifiers = (aClass = (Class)type).getModifiers()) && !Modifier.isAbstract(aClass.getModifiers())) {
            return ClassRegistry.newInstance(aClass);
        }
        if (this.classMap.containsKey(type.toString())) {
            return ClassRegistry.newInstance(this.classMap.get(type.toString()));
        }
        if (this.classMap.containsKey(alias)) {
            return ClassRegistry.newInstance(this.classMap.get(alias));
        }
        return ClassRegistry.newInstance(alias);
    };

    private static Object fromConstructor(Class<?> aClass, String val) {
        try {
            Constructor<?> constructor = aClass.getConstructor(String.class);
            return constructor.newInstance(val);
        }
        catch (Exception e) {
            throw new JavaPathRuntimeException(e);
        }
    }

    private static Object fromValueOf(Class<?> aClass, String val) {
        try {
            Method valueOf = aClass.getMethod("valueOf", String.class);
            return valueOf.invoke(null, val);
        }
        catch (Exception e) {
            throw new JavaPathRuntimeException(e);
        }
    }

    private static Object newInstance(String typeName) {
        try {
            return ClassRegistry.newInstance(Class.forName(typeName));
        }
        catch (ClassNotFoundException e) {
            throw new JavaPathRuntimeException("Failed new instance for type name " + typeName, e);
        }
    }

    private static Object newInstance(Class<?> type) {
        try {
            Constructor<?> constructor = type.getConstructor(null);
            return JavaPath.setAccessible(constructor).newInstance(null);
        }
        catch (Exception e) {
            throw new JavaPathRuntimeException(e);
        }
    }

    public ClassRegistry() {
        this.classMap.putAll(CLASS_MAP);
        this.conversionMap.putAll(CONVERSION_MAP);
        this.conversionMap.put("key->new", this.defaultSupplier);
        this.conversionMap.put("new", typeName -> this.defaultSupplier.apply((Function<?, ?>)((Object)typeName)));
    }

    public Optional<StringConverter> getConverter(String ... names) {
        if (names == null || names.length == 0) {
            return Optional.empty();
        }
        for (String name : names) {
            if (!this.conversionMap.containsKey(name)) continue;
            return Optional.of(this.conversionMap.get(name));
        }
        return Optional.empty();
    }

    public void registerClass(Class<?> aClass, String ... names) {
        Objects.requireNonNull(aClass, "Cannot register NULL as a class");
        this.classMap.put(aClass.getName(), aClass);
        if (names != null && names.length > 0) {
            Arrays.stream(names).filter(Objects::nonNull).forEach(name -> this.classMap.computeIfAbsent((String)name, nm -> aClass));
        }
    }

    public static void registerGlobalClass(Class<?> aClass, String ... names) {
        CLASS_MAP.put(aClass.getName(), aClass);
        if (names != null || names.length > 0) {
            Arrays.stream(names).filter(Objects::nonNull).forEach(name -> CLASS_MAP.computeIfAbsent((String)name, nm -> aClass));
        }
    }

    public <T> StringConverter<T> registerStringConverter(Class<?> aClass, StringConverter<T> converter) {
        Objects.requireNonNull(aClass, "registerStringConverter requires non empty class");
        Objects.requireNonNull(converter, "registerStringConverter requires converter for class " + aClass.getSimpleName());
        return this.registerStringConverter(converter, aClass.getName());
    }

    public <T> StringConverter<T> registerStringConverter(StringConverter<T> converter, String ... names) {
        Objects.requireNonNull(names, "registerStringConverter requires non empty class alias names");
        Objects.requireNonNull(converter, "registerStringConverter requires converter for classes " + String.join((CharSequence)",", names));
        Arrays.stream(names).filter(Objects::nonNull).forEach(name -> this.conversionMap.computeIfAbsent((String)name, clsName -> converter));
        return converter;
    }

    public static <T> void registerGlobalStringConverter(Class<T> aClass, StringConverter<T> converter) {
        ClassRegistry.registerGlobalStringConverter(converter, aClass.getName());
    }

    public static <T> void registerGlobalStringConverter(StringConverter<T> converter, String ... names) {
        Objects.requireNonNull(names, "registerStringConverter requires non empty class alias");
        Objects.requireNonNull(converter, "registerStringConverter requires converter for class " + String.join((CharSequence)",", names));
        Arrays.stream(names).filter(Objects::nonNull).forEach(alias -> CONVERSION_MAP.computeIfAbsent((String)alias, name -> converter));
    }

    static {
        ClassRegistry.registerGlobalClass(Void.TYPE, "void");
        ClassRegistry.registerGlobalClass(String.class, String.class.getSimpleName(), "s", "str", "string");
        ClassRegistry.registerGlobalClass(Integer.TYPE, Integer.TYPE.getSimpleName(), "i");
        ClassRegistry.registerGlobalClass(Integer.class, Integer.class.getSimpleName(), "I", "Int");
        ClassRegistry.registerGlobalClass(Long.TYPE, Long.TYPE.getSimpleName(), "l");
        ClassRegistry.registerGlobalClass(Long.class, Long.class.getSimpleName(), "L");
        ClassRegistry.registerGlobalClass(Byte.TYPE, Byte.TYPE.getSimpleName(), "b");
        ClassRegistry.registerGlobalClass(Byte.class, Byte.class.getSimpleName(), "B");
        ClassRegistry.registerGlobalClass(Boolean.TYPE, Boolean.TYPE.getSimpleName(), "bool");
        ClassRegistry.registerGlobalClass(Boolean.class, Boolean.class.getSimpleName(), "Bool");
        ClassRegistry.registerGlobalClass(Character.TYPE, Character.TYPE.getSimpleName(), "c", "ch");
        ClassRegistry.registerGlobalClass(Character.class, Character.class.getSimpleName(), "C", "Ch", "Char");
        ClassRegistry.registerGlobalClass(Short.TYPE, Short.TYPE.getSimpleName());
        ClassRegistry.registerGlobalClass(Short.class, Short.class.getSimpleName());
        ClassRegistry.registerGlobalClass(Double.TYPE, Double.TYPE.getSimpleName(), "d");
        ClassRegistry.registerGlobalClass(Double.class, Double.class.getSimpleName(), "D");
        ClassRegistry.registerGlobalClass(Float.TYPE, Float.TYPE.getSimpleName(), "f");
        ClassRegistry.registerGlobalClass(Float.class, Float.class.getSimpleName(), "F");
        ClassRegistry.registerGlobalClass(Function.class, "new", "key->new");
        ClassRegistry.registerGlobalClass(ArrayList.class, ArrayList.class.getSimpleName(), "list");
        ClassRegistry.registerGlobalClass(LinkedList.class, LinkedList.class.getSimpleName(), "linkedlist");
        ClassRegistry.registerGlobalClass(HashMap.class, HashMap.class.getSimpleName(), "map");
        ClassRegistry.registerGlobalClass(HashSet.class, HashSet.class.getSimpleName(), "set");
        ClassRegistry.registerGlobalClass(TreeMap.class, TreeMap.class.getSimpleName(), "treemap");
        ClassRegistry.registerGlobalClass(TreeSet.class, TreeSet.class.getSimpleName(), "treeset");
        ClassRegistry.registerGlobalClass(JavaPath.Holder.class, new String[0]);
        ClassRegistry.registerGlobalStringConverter(StringConverter.identity(), String.class.getName(), String.class.getSimpleName(), "string", "str", "s");
        ClassRegistry.registerGlobalStringConverter(StringConverter.valueOf(Integer.class), Integer.class.getName(), Integer.class.getSimpleName(), "Int", "I", "integer", "int", "i");
        ClassRegistry.registerGlobalStringConverter(StringConverter.valueOf(Long.class), Long.class.getName(), Long.class.getSimpleName(), "L", "long", "l");
        ClassRegistry.registerGlobalStringConverter(StringConverter.valueOf(Short.class), Short.class.getName(), Short.class.getSimpleName(), "short");
        ClassRegistry.registerGlobalStringConverter(StringConverter.valueOf(Byte.class), Byte.class.getName(), Byte.class.getSimpleName(), "byte", "B", "b");
        ClassRegistry.registerGlobalStringConverter(StringConverter.valueOf(Double.class), Double.class.getName(), Double.class.getSimpleName(), "D", "d", "double");
        ClassRegistry.registerGlobalStringConverter(StringConverter.valueOf(Float.class), Float.class.getName(), Float.class.getSimpleName(), "F", "f", "float");
        ClassRegistry.registerGlobalStringConverter(StringConverter.valueOf(Boolean.class), Boolean.class.getName(), Boolean.class.getSimpleName(), "Bool", "bool", "boolean");
        ClassRegistry.registerGlobalStringConverter(str -> {
            Objects.requireNonNull(str);
            if (str.length() > 1) {
                throw new JavaPathRuntimeException("Cannot convert " + str + " to a single char");
            }
            return Character.valueOf(str.charAt(0));
        }, Character.class.getName(), Character.class.getSimpleName(), "Char", "Ch", "C", "char", "ch", "c");
    }
}

