/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.CallTree;
import com.aegisql.java_path.ClassRegistry;
import com.aegisql.java_path.JavaPathParser;
import com.aegisql.java_path.JavaPathRuntimeException;
import com.aegisql.java_path.ParametrizedPath;
import com.aegisql.java_path.ParametrizedProperty;
import com.aegisql.java_path.PathElement;
import com.aegisql.java_path.ReferenceList;
import com.aegisql.java_path.StringConverter;
import com.aegisql.java_path.TypedPathElement;
import com.aegisql.java_path.TypedValue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPath {
    private static final Logger LOG = LoggerFactory.getLogger(JavaPath.class);
    private Map<String, List<TypedPathElement>> cache = new HashMap<String, List<TypedPathElement>>();
    private final Class<?> aClass;
    private final CallTree callTree;
    private final ClassRegistry classRegistry;
    private final int pathNumber;
    private boolean enableCaching = false;

    private JavaPath(Class<?> aClass, ClassRegistry registry, Map<String, List<TypedPathElement>> cache, int pathNumber) {
        Objects.requireNonNull(aClass, "Builder class is null");
        this.aClass = aClass;
        this.callTree = CallTree.forClass(aClass, registry);
        this.classRegistry = registry;
        this.cache = cache;
        this.pathNumber = pathNumber;
    }

    public JavaPath(Class<?> aClass, ClassRegistry registry) {
        Objects.requireNonNull(aClass, "Builder class is null");
        this.aClass = aClass;
        this.callTree = CallTree.forClass(aClass, registry);
        this.classRegistry = registry;
        this.pathNumber = 0;
    }

    public JavaPath(Class<?> aClass) {
        this(aClass, new ClassRegistry());
    }

    public Object initPath(String path, Object ... values) {
        List<TypedPathElement> parse = this.pack(this.parse(path));
        return this.applyInHolder(parse, values);
    }

    public <T> T initPath(Class<T> rootClass, String path, Object ... values) {
        List<TypedPathElement> parse = this.pack(this.parse(path));
        parse.get(1).setType(rootClass.getName());
        return this.applyInHolder(parse, values);
    }

    public Object evalPath(String path, Object root, Object ... values) {
        List<TypedPathElement> parse = this.parse(path);
        ReferenceList backRefCollection = new ReferenceList(root);
        if (values == null || values.length == 0) {
            backRefCollection.addValue(null);
        } else if (values.length == 1) {
            backRefCollection.addValue(values[0]);
        } else {
            Arrays.stream(values).forEach(backRefCollection::addValue);
        }
        return this.evalPath(parse, backRefCollection);
    }

    public void setEnablePathCaching(boolean enableCaching) {
        this.enableCaching = enableCaching;
    }

    public void setPathAlias(String path, String alias) {
        this.cache.computeIfAbsent(alias, al -> JavaPathParser.parse(path));
    }

    private List<TypedPathElement> parse(String path) {
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        if (this.enableCaching) {
            return this.cache.computeIfAbsent(path, p -> JavaPathParser.parse(p));
        }
        return JavaPathParser.parse(path);
    }

    private <T> T applyInHolder(List<TypedPathElement> path, Object ... values) {
        Holder root = new Holder(this);
        JavaPath pu = new JavaPath(Holder.class, this.classRegistry, this.cache, this.pathNumber);
        pu.setEnablePathCaching(this.enableCaching);
        ReferenceList backRefCollection = new ReferenceList(root);
        if (values != null) {
            Arrays.stream(values).forEach(backRefCollection::addValue);
        }
        LOG.debug("Init from values {} path {}", (Object)backRefCollection, (Object)path.stream().map(tpe -> tpe == null ? ";" : tpe.toString()).collect(Collectors.joining(".")));
        pu.evalPath(path, backRefCollection);
        return (T)root._holder_;
    }

    private List<TypedPathElement> pack(List<TypedPathElement> path) {
        Objects.requireNonNull(path, "Requires path");
        if (path.size() == 0) {
            throw new JavaPathRuntimeException("Requires at least one path element");
        }
        ArrayList<TypedPathElement> newPath = new ArrayList<TypedPathElement>();
        TypedPathElement rootPathElement = new TypedPathElement();
        rootPathElement.setName("");
        rootPathElement.setType(Holder.class.getName());
        TypedPathElement pathElement = path.get(0);
        pathElement.setName("#");
        newPath.add(rootPathElement);
        newPath.addAll(path);
        return newPath;
    }

    private <T> T evalPath(List<TypedPathElement> path, ReferenceList valuesRefsCollection) {
        TypedPathElement optionalPathElement;
        boolean processAsSetter;
        Objects.requireNonNull(path, "Requires path");
        int size = path.size();
        if (size == 0) {
            return (T)valuesRefsCollection.getRoot();
        }
        TypedPathElement rootPathElement = path.get(0);
        if (rootPathElement == null) {
            ReferenceList nextReferenceList = valuesRefsCollection.startNextPath();
            JavaPath nextPath = new JavaPath(nextReferenceList.getRootClass(), this.classRegistry, this.cache, this.pathNumber + 1);
            nextPath.setEnablePathCaching(this.enableCaching);
            return nextPath.evalPath(path.subList(1, path.size()), nextReferenceList);
        }
        if (size == 1) {
            processAsSetter = true;
        } else {
            boolean bl = processAsSetter = path.get(1) == null;
        }
        if (rootPathElement.parametrized()) {
            for (TypedValue tv : rootPathElement.getParameters()) {
                if (!tv.hasPath()) continue;
                if (tv.getBackRefIdx() >= 0) {
                    this.applyBackReference(valuesRefsCollection, tv);
                    continue;
                }
                if (tv.getValueIdx() < 0) continue;
                this.applyValueReference(valuesRefsCollection, tv);
            }
        }
        if (rootPathElement.getOptionalPathElement() != null && (optionalPathElement = rootPathElement.getOptionalPathElement()).parametrized()) {
            for (TypedValue tv : optionalPathElement.getParameters()) {
                if (!tv.hasPath()) continue;
                if (tv.getBackRefIdx() >= 0) {
                    this.applyBackReference(valuesRefsCollection, tv);
                    continue;
                }
                if (tv.getValueIdx() < 0) continue;
                this.applyValueReference(valuesRefsCollection, tv);
            }
        }
        if (rootPathElement.getName().startsWith("@")) {
            if (rootPathElement.getType() == null) {
                return this.evalPath(path.subList(1, path.size()), valuesRefsCollection);
            }
            return this.applyAtSign(path, valuesRefsCollection, rootPathElement);
        }
        if (processAsSetter) {
            T res = this.offerSetter(valuesRefsCollection, rootPathElement).apply(valuesRefsCollection);
            if (size == 1) {
                return res;
            }
            return this.evalPath(path.subList(1, size), valuesRefsCollection);
        }
        return this.offerGetter(path, valuesRefsCollection, rootPathElement);
    }

    private <T> T applyAtSign(List<TypedPathElement> path, ReferenceList valuesRefsCollection, TypedPathElement rootPathElement) {
        Class<?> refClass = this.classRegistry.classMap.get(rootPathElement.getType());
        if (refClass == null) {
            try {
                refClass = Class.forName(rootPathElement.getType());
            }
            catch (ClassNotFoundException e) {
                throw new JavaPathRuntimeException("Cannot find class for " + String.valueOf(rootPathElement), e);
            }
        }
        JavaPath nextUtils = new JavaPath(refClass, this.classRegistry, this.cache, this.pathNumber);
        nextUtils.setEnablePathCaching(this.enableCaching);
        if (rootPathElement.getName().equalsIgnoreCase("@new")) {
            Function<ReferenceList, Object> constructor = nextUtils.offerConstructor(valuesRefsCollection, rootPathElement);
            if (constructor != null) {
                Object nextRef = constructor.apply(valuesRefsCollection);
                valuesRefsCollection.addReference(nextRef);
                return this.evalPath(path.subList(1, path.size()), valuesRefsCollection);
            }
            throw new JavaPathRuntimeException("Expected constructor of class " + String.valueOf(refClass) + " for " + String.valueOf(rootPathElement));
        }
        rootPathElement.setName(rootPathElement.getName().substring(1));
        Function<ReferenceList, Object> getter = nextUtils.offerGetter(valuesRefsCollection, rootPathElement);
        if (getter != null) {
            Object nextRef = getter.apply(valuesRefsCollection);
            valuesRefsCollection.addReference(nextRef);
            return this.evalPath(path.subList(1, path.size()), valuesRefsCollection);
        }
        throw new JavaPathRuntimeException("Expected getter for class " + String.valueOf(refClass) + " for " + String.valueOf(rootPathElement));
    }

    private <T> T offerGetter(List<TypedPathElement> path, ReferenceList valuesRefsCollection, TypedPathElement rootPathElement) {
        Function<ReferenceList, Object> getter = this.offerGetter(valuesRefsCollection, rootPathElement);
        Object nextRoot = getter.apply(valuesRefsCollection);
        if (rootPathElement.getOwnTypedValue().isPreEvaluatedValueSet()) {
            Class<?> nextClass = nextRoot == null ? this.classRegistry.classMap.get(rootPathElement.getType()) : nextRoot.getClass();
            JavaPath nextUtils = new JavaPath(nextClass, this.classRegistry, this.cache, this.pathNumber);
            nextUtils.setEnablePathCaching(this.enableCaching);
            valuesRefsCollection.addRoot(nextRoot);
            return nextUtils.evalPath(path.subList(1, path.size()), valuesRefsCollection);
        }
        if (nextRoot == null && rootPathElement.getOptionalPathElement() != null) {
            this.offerGetter(valuesRefsCollection, rootPathElement.getOptionalPathElement()).apply(valuesRefsCollection);
            nextRoot = getter.apply(valuesRefsCollection);
        }
        Objects.requireNonNull(nextRoot, "Object for path element '" + rootPathElement.getName() + "' is not initialized!");
        JavaPath nextUtils = new JavaPath(nextRoot.getClass(), this.classRegistry, this.cache, this.pathNumber);
        nextUtils.setEnablePathCaching(this.enableCaching);
        valuesRefsCollection.addRoot(nextRoot);
        return nextUtils.evalPath(path.subList(1, path.size()), valuesRefsCollection);
    }

    private void applyValueReference(ReferenceList valuesRefsCollection, TypedValue tv) {
        ArrayList<TypedPathElement> typedPathElements = new ArrayList<TypedPathElement>(tv.getTypedPathElements());
        Object pathRoot = valuesRefsCollection.getValue(tv.getValueIdx());
        Class<?> pathRootClass = pathRoot.getClass();
        ReferenceList rl = new ReferenceList(pathRoot);
        ((TypedPathElement)typedPathElements.get(typedPathElements.size() - 1)).getOwnTypedValue().setPreEvaluatedValueSet(true);
        TypedPathElement term = new TypedPathElement();
        term.setName("@");
        typedPathElements.add(term);
        JavaPath javaPath = new JavaPath(pathRootClass, this.classRegistry, this.cache, this.pathNumber);
        tv.setPreEvaluatedValueSet(true);
        Object res = javaPath.evalPath(typedPathElements, rl);
        tv.setPreEvaluatedValue(res);
        tv.setType(res == null ? tv.getType() : res.getClass().getName());
        tv.setValueIdx(-1);
    }

    private void applyBackReference(ReferenceList valuesRefsCollection, TypedValue tv) {
        ArrayList<TypedPathElement> typedPathElements = new ArrayList<TypedPathElement>(tv.getTypedPathElements());
        Object pathRoot = valuesRefsCollection.getReference(tv.getBackRefIdx());
        Class<?> pathRootClass = pathRoot.getClass();
        ReferenceList rl = new ReferenceList(pathRoot);
        valuesRefsCollection.getValues().forEach(rl::addValue);
        ((TypedPathElement)typedPathElements.get(typedPathElements.size() - 1)).getOwnTypedValue().setPreEvaluatedValueSet(true);
        TypedPathElement term = new TypedPathElement();
        term.setName("@");
        typedPathElements.add(term);
        JavaPath javaPath = new JavaPath(pathRootClass, this.classRegistry, this.cache, this.pathNumber);
        tv.setPreEvaluatedValueSet(true);
        Object res = javaPath.evalPath(typedPathElements, rl);
        tv.setPreEvaluatedValue(res);
        tv.setType(res == null ? tv.getType() : res.getClass().getName());
        tv.setBackRefIdx(-1);
    }

    private Function<ReferenceList, Object> offerConstructor(ReferenceList backReferences, TypedPathElement javaPath) {
        ParametrizedPath pl = new ParametrizedPath(this.classRegistry, javaPath);
        Constructor constructor = null;
        Class<?>[] classesForGetter = pl.getClassesForGetter(backReferences);
        Set<Constructor> constructors = this.callTree.findConstructorCandidates(classesForGetter);
        if (constructors.size() > 1) {
            throw new JavaPathRuntimeException("More than one constructor candidates found for " + String.valueOf(pl) + "; " + String.valueOf(constructors));
        }
        if (constructors.size() == 1) {
            constructor = constructors.iterator().next();
        }
        if (constructor != null) {
            Constructor finalConstructor = constructor;
            return b -> {
                Object[] propertiesForGetter = pl.getPropertiesForGetter((ReferenceList)b);
                return this.invoke(finalConstructor, propertiesForGetter);
            };
        }
        String msg = Arrays.stream(classesForGetter).map(cls -> cls == null ? "NULL" : cls.getSimpleName()).collect(Collectors.joining(",", "[", "]"));
        throw new JavaPathRuntimeException("Could not find constructor for " + String.valueOf(javaPath));
    }

    private Function<ReferenceList, Object> offerGetter(ReferenceList backReferences, TypedPathElement javaPath) {
        ParametrizedPath pl = new ParametrizedPath(this.classRegistry, javaPath);
        Method method = null;
        Class<?>[] classesForGetter = pl.getClassesForGetter(backReferences);
        Set<Method> methods = this.callTree.findMethodCandidates(pl.getLabel(), classesForGetter);
        if (methods.size() > 1) {
            throw new JavaPathRuntimeException("More than one getter method candidates found for " + String.valueOf(pl) + "; " + String.valueOf(methods));
        }
        if (methods.size() == 1) {
            method = methods.iterator().next();
        }
        if (method != null) {
            Method finalMethod = method;
            return b -> {
                Object[] propertiesForGetter = pl.getPropertiesForGetter((ReferenceList)b);
                return this.invoke(finalMethod, b.getRoot(), propertiesForGetter);
            };
        }
        String label = pl.getLabel();
        Field field = CallTree.forClass(this.aClass, this.classRegistry).findField(pl.getLabel());
        if (field == null) {
            return b -> b.getRoot();
        }
        return b -> this.get(backReferences, pl, field, b.getRoot());
    }

    private <T> Function<ReferenceList, T> offerSetter(ReferenceList backReferences, TypedPathElement javaPath) {
        ParametrizedPath pl = new ParametrizedPath(this.classRegistry, javaPath);
        Method method = null;
        Class<?>[] classesForSetter = pl.getClassesForSetter(backReferences);
        Set<Method> methods = this.callTree.findMethodCandidates(pl.getLabel(), classesForSetter);
        if (methods.size() > 1) {
            throw new JavaPathRuntimeException("More than one setter method candidates found for " + String.valueOf(pl) + "; " + String.valueOf(methods));
        }
        if (methods.size() == 1) {
            method = methods.iterator().next();
        }
        if (method != null) {
            Method finalMethod = method;
            if (method.getParameterCount() == 0) {
                return b -> this.invoke(finalMethod, b.getRoot(), null);
            }
            return b -> this.invoke(finalMethod, b.getRoot(), pl.getPropertiesForSetter((ReferenceList)b));
        }
        int pos = pl.getLabelProperties().size() == 0 ? this.pathNumber : pl.getLabelProperties().get(0).getValueIdx();
        Object value = null;
        if (pos >= 0) {
            value = backReferences.getValue(pos);
        } else {
            Object[] propertiesForSetter = pl.getPropertiesForSetter(backReferences);
            if (propertiesForSetter.length != 0) {
                value = propertiesForSetter[0];
            }
        }
        Object finalValue = value;
        return b -> this.fieldSetter(pl).apply((ReferenceList)b, finalValue);
    }

    private Object invoke(Method method, Object builder, Object ... params) {
        try {
            return JavaPath.setAccessible(method).invoke(builder, params);
        }
        catch (IllegalAccessException e) {
            throw new JavaPathRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new JavaPathRuntimeException(e);
        }
    }

    private Object invoke(Constructor constructor, Object ... params) {
        try {
            return JavaPath.setAccessible(constructor).newInstance(params);
        }
        catch (Exception e) {
            throw new JavaPathRuntimeException(e);
        }
    }

    private Object get(ReferenceList backReferences, ParametrizedPath pl, Field field, Object builder) {
        try {
            Object o = JavaPath.setAccessible(field).get(builder);
            if (o == null) {
                ParametrizedProperty labelProperty = pl.getParametrizedProperty();
                if (labelProperty.isPreEvaluatedValueSet()) {
                    Object preEvaluatedValue = labelProperty.getPreEvaluatedValue();
                    JavaPath.setAccessible(field).set(builder, preEvaluatedValue);
                    return preEvaluatedValue;
                }
                Class<?> fieldType = labelProperty.getTypeAlias() != null && labelProperty.getPropertyType() != null ? labelProperty.getPropertyType() : field.getType();
                Class<?>[] classesForGetter = pl.getClassesForGetter(backReferences);
                Object[] propertiesForGetter = pl.getPropertiesForGetter(backReferences);
                CallTree.forClass(fieldType, this.classRegistry);
                String factory = pl.getPathElement().getFactory();
                if (factory == null || "new".equals(factory)) {
                    StringConverter stringConverter = this.classRegistry.getConverter(fieldType.getName(), fieldType.getSimpleName(), labelProperty.getTypeAlias(), "valueOf").orElse(null);
                    if (factory == null && classesForGetter.length == 1 && classesForGetter[0] == String.class && stringConverter != null) {
                        Object newInstance = stringConverter.apply(propertiesForGetter[0]);
                        JavaPath.setAccessible(field).set(builder, newInstance);
                        return newInstance;
                    }
                    Constructor<?> constructor = fieldType.getConstructor(classesForGetter);
                    Object newInstance = JavaPath.setAccessible(constructor).newInstance(propertiesForGetter);
                    JavaPath.setAccessible(field).set(builder, newInstance);
                    return newInstance;
                }
                Method method = fieldType.getMethod(factory, classesForGetter);
                Object newInstance = JavaPath.setAccessible(method).invoke(null, propertiesForGetter);
                JavaPath.setAccessible(field).set(builder, newInstance);
                return newInstance;
            }
            return o;
        }
        catch (Exception e) {
            throw new JavaPathRuntimeException("Failed instantiating " + String.valueOf(pl), e);
        }
    }

    private void set(Field field, Object builder, Object val) {
        try {
            JavaPath.setAccessible(field).set(builder, val);
        }
        catch (IllegalAccessException e) {
            throw new JavaPathRuntimeException(e);
        }
    }

    private <T> BiFunction<ReferenceList, Object, T> fieldSetter(ParametrizedPath pl) {
        String label = pl.getLabel();
        Field field = CallTree.forClass(this.aClass, this.classRegistry).findField(pl.getLabel());
        if (field != null) {
            return (b, v) -> {
                this.set(field, b.getRoot(), v);
                return v;
            };
        }
        return (b, v) -> {
            throw new JavaPathRuntimeException("No setter found for " + label);
        };
    }

    public static Constructor setAccessible(Constructor constructor) {
        int classModifiers = constructor.getDeclaringClass().getModifiers();
        int constructorModifiers = constructor.getModifiers();
        if (!Modifier.isPublic(constructorModifiers) || Modifier.isAbstract(classModifiers) || Modifier.isFinal(classModifiers)) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static Method setAccessible(Method method) {
        int classModifiers = method.getDeclaringClass().getModifiers();
        int methodModifiers = method.getModifiers();
        if (!Modifier.isPublic(methodModifiers) || Modifier.isAbstract(classModifiers) || Modifier.isFinal(classModifiers)) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Field setAccessible(Field field) {
        int classModifiers = field.getDeclaringClass().getModifiers();
        int fieldModifiers = field.getModifiers();
        if (!Modifier.isPublic(fieldModifiers) || Modifier.isFinal(fieldModifiers) || Modifier.isAbstract(classModifiers) || Modifier.isFinal(classModifiers)) {
            field.setAccessible(true);
        }
        return field;
    }

    class Holder {
        @PathElement(value={"#"})
        Object _holder_;

        Holder(JavaPath this$0) {
        }
    }
}

