/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.JavaPathRuntimeException;
import com.aegisql.java_path.TypedPathElement;
import com.aegisql.java_path.TypedValue;
import com.aegisql.java_path.parser.ASTcomma;
import com.aegisql.java_path.parser.ASTfullPath;
import com.aegisql.java_path.parser.ASTlParenthesis;
import com.aegisql.java_path.parser.ASToption;
import com.aegisql.java_path.parser.ASTparameters;
import com.aegisql.java_path.parser.ASTparse;
import com.aegisql.java_path.parser.ASTpathElement;
import com.aegisql.java_path.parser.ASTpathSeparator;
import com.aegisql.java_path.parser.ASTrParenthesis;
import com.aegisql.java_path.parser.CCJavaPathParser;
import com.aegisql.java_path.parser.CCJavaPathParserVisitor;
import com.aegisql.java_path.parser.ParseException;
import com.aegisql.java_path.parser.SimpleNode;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPathParser {
    private static final Logger LOG = LoggerFactory.getLogger(JavaPathParser.class);

    public static List<TypedPathElement> parse(String path) {
        LOG.debug("parsing {}", (Object)path);
        LinkedList<TypedPathElement> elements = new LinkedList<TypedPathElement>();
        Visitor visitor = new Visitor(elements);
        CCJavaPathParser parser = new CCJavaPathParser(JavaPathParser.r(path));
        SimpleNode sn = null;
        try {
            sn = parser.parse();
            sn.jjtAccept(visitor, elements);
        }
        catch (ParseException e) {
            throw new JavaPathRuntimeException("Failed parsing JavaPath '" + path + "'", e);
        }
        LOG.debug("parsing of {} complete: {} found paths: {}", new Object[]{path, elements, visitor.pathNumber + 1});
        return Collections.unmodifiableList(elements);
    }

    private static StringReader r(String s) {
        StringReader sr = new StringReader(s);
        return sr;
    }

    private static class Visitor
    implements CCJavaPathParserVisitor {
        private LinkedList<LinkedList<TypedPathElement>> stack = new LinkedList();
        private LinkedList<TypedPathElement> rootPath;
        private LinkedList<TypedPathElement> currentPath;
        private int maxBackRef = 0;
        private boolean option;
        private int pathNumber = 0;

        public Visitor(LinkedList<TypedPathElement> rootPath) {
            this.rootPath = rootPath;
            this.currentPath = rootPath;
        }

        private String toString(Object o) {
            return o == null ? null : o.toString();
        }

        @Override
        public Object visit(SimpleNode node, Object data) {
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTcomma node, Object data) {
            if (this.stack.size() > 0) {
                this.currentPath = this.stack.pop();
            }
            LOG.trace("parse:, current: {} stack: {}", this.currentPath, this.stack);
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTlParenthesis node, Object data) {
            if (this.stack.size() > 0) {
                this.stack.push(this.currentPath);
            }
            LOG.trace("parse:( current: {} stack: {}", this.currentPath, this.stack);
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTrParenthesis node, Object data) {
            if (this.stack.size() > 0) {
                this.currentPath = this.stack.pop();
            }
            LOG.trace("parse:) current: {} stack: {}", this.currentPath, this.stack);
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASToption node, Object data) {
            this.option = (Boolean)node.jjtGetValue();
            LOG.trace("parse:? current: {} stack: {}", this.currentPath, this.stack);
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTpathSeparator node, Object data) {
            LOG.trace("parse:; current: {} stack: {}", this.currentPath, this.stack);
            ++this.pathNumber;
            this.rootPath.add(null);
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTparse node, Object data) {
            TypedPathElement typedPathElement = (TypedPathElement)node.jjtGetValue();
            if (typedPathElement != null) {
                this.currentPath.add(typedPathElement);
            }
            LOG.trace("parse:parse {}, {} stack: {}", new Object[]{node.jjtGetValue(), typedPathElement, this.stack});
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTfullPath node, Object data) {
            this.currentPath = this.rootPath;
            this.stack.clear();
            TypedPathElement typedPathElement = new TypedPathElement();
            String fullType = this.toString(node.jjtGetValue());
            String type = null;
            String factory = null;
            if (fullType != null) {
                String[] pair = fullType.split("::", 2);
                type = pair[0];
                if (pair.length == 2) {
                    factory = pair[1];
                }
            }
            typedPathElement.setType(type);
            typedPathElement.setFactory(factory);
            if (this.option) {
                this.currentPath.getLast().setOptionalPathElement(typedPathElement);
            } else {
                this.currentPath.add(typedPathElement);
            }
            LOG.trace("parse:fullPath type: '{}' {} current: {}", new Object[]{fullType, typedPathElement, this.currentPath});
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTpathElement node, Object data) {
            TypedPathElement typedPathElement = null;
            if (this.stack.size() > 0) {
                typedPathElement = new TypedPathElement();
                TypedPathElement last = this.option ? this.rootPath.getLast().getOptionalPathElement() : this.rootPath.getLast();
                typedPathElement.setType(last.getParameters().getLast().getType());
                this.currentPath.add(typedPathElement);
            } else {
                typedPathElement = this.option ? this.currentPath.getLast().getOptionalPathElement() : this.currentPath.getLast();
            }
            typedPathElement.setName(this.toString(node.jjtGetValue()));
            ++this.maxBackRef;
            LOG.trace("parse:pathElement '{}' maxBackRef {} current: {} stack: {}", new Object[]{node.jjtGetValue(), this.maxBackRef, this.currentPath, this.stack});
            return node.childrenAccept(this, data);
        }

        @Override
        public Object visit(ASTparameters node, Object data) {
            TypedValue typedValue = (TypedValue)node.jjtGetValue();
            TypedPathElement typedPathElement = this.option ? this.currentPath.getLast().getOptionalPathElement() : this.currentPath.getLast();
            typedPathElement.addParameter(typedValue);
            if (typedValue.isHashSign()) {
                if (typedValue.getBackRefIdx() >= this.maxBackRef) {
                    throw new JavaPathRuntimeException("Back reference #" + typedValue.getBackRefIdx() + " is not visible at position " + this.maxBackRef);
                }
                this.stack.push(this.currentPath);
                this.currentPath = typedValue.getTypedPathElements();
            } else if (typedValue.isDollarSign()) {
                this.stack.push(this.currentPath);
                this.currentPath = typedValue.getTypedPathElements();
            }
            LOG.trace("parse:parameters '{}' current: {} stack: {}", new Object[]{typedValue, this.currentPath, this.stack});
            return node.childrenAccept(this, data);
        }
    }
}

