/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.ClassRegistry;
import com.aegisql.java_path.ParametrizedProperty;
import com.aegisql.java_path.ReferenceList;
import com.aegisql.java_path.TypedPathElement;
import com.aegisql.java_path.TypedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParametrizedPath {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final ClassRegistry classRegistry;
    private final TypedPathElement pathElement;
    private final String label;
    private boolean hasValueType = false;
    private final List<ParametrizedProperty> labelProperties;
    private final ParametrizedProperty parametrizedProperty;

    public ParametrizedPath(ClassRegistry classRegistry, TypedPathElement javaPath) {
        this.classRegistry = classRegistry == null ? new ClassRegistry() : classRegistry;
        this.pathElement = javaPath;
        this.label = javaPath.getName();
        this.parametrizedProperty = new ParametrizedProperty(this.classRegistry, this.pathElement.getOwnTypedValue(), true);
        if (this.pathElement.parametrized()) {
            this.labelProperties = new ArrayList<ParametrizedProperty>();
            for (TypedValue tv : this.pathElement.getParameters()) {
                ParametrizedProperty parametrizedProperty = new ParametrizedProperty(this.classRegistry, tv, false);
                if (parametrizedProperty.isValue() && parametrizedProperty.getPropertyType() != null) {
                    this.hasValueType = true;
                }
                this.labelProperties.add(parametrizedProperty);
            }
        } else {
            this.labelProperties = Collections.EMPTY_LIST;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public Object[] getPropertiesForGetter(ReferenceList backRefObjects) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (ParametrizedProperty lp : this.labelProperties) {
            if (lp.isPreEvaluatedValueSet()) {
                objects.add(lp.getPreEvaluatedValue());
                continue;
            }
            if (lp.isBuilder()) {
                objects.add(backRefObjects.getReference(lp.getBackReferenceIdx()));
                continue;
            }
            if (lp.isValue()) {
                objects.add(backRefObjects.getValue(lp.getValueIdx()));
                continue;
            }
            if (lp.isBackReferenceIdx()) {
                objects.add(backRefObjects.getReference(lp.getBackReferenceIdx()));
                continue;
            }
            objects.add(lp.getProperty());
        }
        return objects.toArray(EMPTY_OBJECT_ARRAY);
    }

    public Object[] getPropertiesForSetter(ReferenceList backRefObjects) {
        boolean valueNotSet = true;
        ArrayList<Object> objects = new ArrayList<Object>();
        for (ParametrizedProperty lp : this.labelProperties) {
            if (lp.isPreEvaluatedValueSet()) {
                objects.add(lp.getPreEvaluatedValue());
                if (!lp.isValue()) continue;
                valueNotSet = false;
                continue;
            }
            if (lp.isBuilder()) {
                objects.add(backRefObjects.getRoot());
                continue;
            }
            if (lp.isValue()) {
                objects.add(backRefObjects.getValue(lp.getValueIdx()));
                valueNotSet = false;
                continue;
            }
            if (lp.isBackReferenceIdx()) {
                objects.add(backRefObjects.getReference(lp.getBackReferenceIdx()));
                continue;
            }
            objects.add(lp.getProperty());
        }
        if (valueNotSet) {
            objects.add(backRefObjects.getValue(0));
        }
        return objects.toArray(EMPTY_OBJECT_ARRAY);
    }

    public Class<?>[] getClassesForGetter(ReferenceList backReferences) {
        ArrayList classes = new ArrayList();
        for (ParametrizedProperty lp : this.labelProperties) {
            if (lp.isBuilder()) {
                classes.add(backReferences.getReferenceClass(lp.getBackReferenceIdx()));
                continue;
            }
            if (lp.isValue()) {
                classes.add(lp.getPropertyType() == null ? backReferences.getValueClass(lp.getValueIdx()) : lp.getPropertyType());
                continue;
            }
            if (lp.isBackReferenceIdx()) {
                classes.add(backReferences.getReferenceClass(lp.getBackReferenceIdx()));
                continue;
            }
            classes.add(lp.getPropertyType());
        }
        return classes.toArray(EMPTY_CLASS_ARRAY);
    }

    public Class<?>[] getClassesForSetter(ReferenceList backReferences) {
        boolean valueNotSet = true;
        ArrayList classes = new ArrayList();
        for (ParametrizedProperty lp : this.labelProperties) {
            if (lp.isBuilder()) {
                classes.add(backReferences.getRootClass());
                continue;
            }
            if (lp.isValue()) {
                classes.add(lp.getPropertyType() == null ? backReferences.getValueClass(lp.getValueIdx()) : lp.getPropertyType());
                valueNotSet = false;
                continue;
            }
            if (lp.isBackReferenceIdx()) {
                classes.add(backReferences.getReferenceClass(lp.getBackReferenceIdx()));
                continue;
            }
            classes.add(lp.getPropertyType());
        }
        if (valueNotSet) {
            classes.add(backReferences.getValueClass(0));
        }
        return classes.toArray(EMPTY_CLASS_ARRAY);
    }

    public boolean hasValueType() {
        return this.hasValueType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParametrizedLabel{");
        sb.append(this.pathElement.toString());
        sb.append('}');
        return sb.toString();
    }

    List<ParametrizedProperty> getLabelProperties() {
        return this.labelProperties;
    }

    ParametrizedProperty getParametrizedProperty() {
        return this.parametrizedProperty;
    }

    public TypedPathElement getPathElement() {
        return this.pathElement;
    }
}

