/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.ClassRegistry;
import com.aegisql.java_path.JavaPathRuntimeException;
import com.aegisql.java_path.StringConverter;
import com.aegisql.java_path.TypedValue;
import java.lang.reflect.Method;
import java.util.Objects;

public class ParametrizedProperty {
    private final ClassRegistry classRegistry;
    private final String propertyStr;
    private final Class<?> propertyType;
    private final boolean builder;
    private final boolean value;
    private final int backReferenceIdx;
    private final int valueIdx;
    private final String typeAlias;
    private final Object preEvaluatedValue;
    private final boolean preEvaluatedValueSet;
    private final Method factory;

    private static StringConverter<?> defaultConverter(Class<?> cls) {
        StringConverter<?> constructor = StringConverter.constructor(cls);
        if (constructor != null) {
            return strVal -> constructor.apply(strVal);
        }
        StringConverter<?> converter = StringConverter.valueOf(cls);
        if (converter != null) {
            return strVal -> converter.apply(strVal);
        }
        return strVal -> {
            throw new JavaPathRuntimeException("Failed to find conversion method for string value '" + strVal + "' type " + String.valueOf(cls));
        };
    }

    ParametrizedProperty(ClassRegistry classRegistry, TypedValue typedValue, boolean forField) {
        this.classRegistry = classRegistry;
        this.value = typedValue.isDollarSign();
        this.backReferenceIdx = typedValue.getBackRefIdx();
        this.valueIdx = typedValue.getValueIdx();
        this.preEvaluatedValue = typedValue.getPreEvaluatedValue();
        this.preEvaluatedValueSet = typedValue.isPreEvaluatedValueSet();
        this.propertyStr = typedValue.getValue();
        Class<Object> type = null;
        Objects.requireNonNull(typedValue, "Requires property");
        if (typedValue.parametrized()) {
            this.typeAlias = typedValue.getType();
            if (classRegistry.classMap.containsKey(typedValue.getType())) {
                type = classRegistry.classMap.get(typedValue.getType());
                this.builder = false;
            } else {
                Class<?> aClass = this.toClass(typedValue.getType());
                if (aClass == null) {
                    type = forField ? null : String.class;
                    this.builder = false;
                } else {
                    type = classRegistry.classMap.computeIfAbsent(typedValue.getType(), typeName -> aClass);
                    this.builder = false;
                }
            }
            if (typedValue.getFactory() != null) {
                try {
                    this.factory = type.getMethod(typedValue.getFactory(), String.class);
                    type = this.factory.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    throw new JavaPathRuntimeException("failed to find factory " + typedValue.getFactory() + " for " + this.propertyStr, e);
                }
            } else {
                this.factory = null;
            }
        } else {
            this.typeAlias = null;
            this.factory = null;
            if (typedValue.isHashSign()) {
                type = null;
                this.builder = true;
            } else if (typedValue.isDollarSign()) {
                this.builder = false;
                type = classRegistry.classMap.containsKey(typedValue.getType()) ? classRegistry.classMap.get(typedValue.getType()) : (typedValue.getType() != null ? this.toClass(typedValue.getType()) : null);
            } else {
                type = forField ? null : String.class;
                this.builder = false;
            }
        }
        this.propertyType = type;
    }

    private Class<?> toClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getPropertyStr() {
        return this.propertyStr;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isBuilder() {
        return this.builder;
    }

    public boolean isValue() {
        return this.value;
    }

    public boolean isBackReferenceIdx() {
        return this.backReferenceIdx >= 0;
    }

    public boolean isValueIdx() {
        return this.valueIdx >= 0;
    }

    public int getBackReferenceIdx() {
        return this.backReferenceIdx;
    }

    public int getValueIdx() {
        return this.valueIdx;
    }

    public Object getPreEvaluatedValue() {
        return this.preEvaluatedValue;
    }

    public boolean isPreEvaluatedValueSet() {
        return this.preEvaluatedValueSet;
    }

    public Object getProperty() {
        if (this.propertyType == null) {
            return null;
        }
        if (this.value) {
            return null;
        }
        if (this.factory != null) {
            try {
                return this.factory.invoke(null, this.propertyStr);
            }
            catch (Exception e) {
                throw new JavaPathRuntimeException("Exception in " + String.valueOf(this), e);
            }
        }
        StringConverter supplier = this.classRegistry.getConverter(this.typeAlias, this.propertyType.getName()).orElseGet(() -> this.classRegistry.registerStringConverter(ParametrizedProperty.defaultConverter(this.propertyType), this.typeAlias, this.propertyType.getName()));
        return supplier.apply(this.propertyStr);
    }

    String getTypeAlias() {
        return this.typeAlias;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParametrizedProperty{");
        sb.append("propertyStr='").append(this.propertyStr).append('\'');
        sb.append(", propertyType=").append(this.propertyType);
        sb.append(", typeAlias='").append(this.typeAlias).append('\'');
        sb.append(", builder=").append(this.builder);
        sb.append(", value=").append(this.value);
        if (this.factory != null) {
            sb.append(", factory=").append(this.factory.getName());
        }
        sb.append(", backReferenceIdx=").append(this.backReferenceIdx);
        sb.append(", valueIdx=").append(this.valueIdx);
        sb.append('}');
        return sb.toString();
    }
}

