/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import java.util.ArrayList;
import java.util.List;

public class ReferenceList {
    private final List<Object> references = new ArrayList<Object>();
    private final List<Object> values = new ArrayList<Object>();
    private Object root;
    private final Object firstPathRoot;

    public ReferenceList(Object root) {
        this.firstPathRoot = root;
        this.root = root;
        this.references.add(root);
    }

    public ReferenceList(Object root, Object value) {
        this.firstPathRoot = root;
        this.root = root;
        this.references.add(root);
        this.values.add(value);
    }

    public ReferenceList addRoot(Object nextRoot) {
        if (nextRoot != this.root) {
            this.root = nextRoot;
            this.references.add(nextRoot);
        }
        return this;
    }

    public ReferenceList addValue(Object val) {
        this.values.add(val);
        return this;
    }

    public ReferenceList addReference(Object reference) {
        this.references.add(reference);
        return this;
    }

    public Object getRoot() {
        return this.root;
    }

    public Class<?> getRootClass() {
        return this.root.getClass();
    }

    public Class<?> getFirstPathRootClass() {
        return this.firstPathRoot.getClass();
    }

    public Object getReference(int i) {
        if (i < 0) {
            return this.root;
        }
        return this.references.get(i);
    }

    public Class<?> getReferenceClass(int i) {
        return this.getReference(i).getClass();
    }

    public Object getValue(int i) {
        if (i < 0) {
            return this.values.get(0);
        }
        return this.values.get(i);
    }

    public Class<?> getValueClass(int i) {
        Object val = this.getValue(i);
        if (val == null) {
            return null;
        }
        return val.getClass();
    }

    public List<Object> getReferences() {
        return this.references;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public ReferenceList startNextPath() {
        ReferenceList nextList = new ReferenceList(this.firstPathRoot);
        nextList.values.addAll(this.values);
        return nextList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReferenceList{");
        sb.append("references=").append(this.references);
        if (this.firstPathRoot != this.root) {
            sb.append(", firstPathRoot=").append(this.firstPathRoot);
        }
        sb.append(", root=").append(this.root);
        sb.append(", values=").append(this.values);
        sb.append('}');
        return sb.toString();
    }
}

