/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.JavaPath;
import com.aegisql.java_path.JavaPathRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.function.Function;

@FunctionalInterface
public interface StringConverter<T>
extends Function<String, T> {
    public static StringConverter<String> identity() {
        return str -> str;
    }

    public static <X> StringConverter<X> factory(Class<X> aClass, String methodName) {
        Method valueOf;
        try {
            valueOf = aClass.getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return str -> {
            try {
                return JavaPath.setAccessible(valueOf).invoke(null, str);
            }
            catch (Exception e) {
                throw new JavaPathRuntimeException(e);
            }
        };
    }

    public static <X> StringConverter<X> valueOf(Class<X> aClass) {
        return StringConverter.factory(aClass, "valueOf");
    }

    public static <X> StringConverter<X> constructor(Class<X> aClass) {
        Constructor constructor;
        try {
            System.err.println("Constructor for " + String.valueOf(aClass));
            constructor = aClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return str -> {
            try {
                return JavaPath.setAccessible(constructor).newInstance(str);
            }
            catch (Exception e) {
                throw new JavaPathRuntimeException(e);
            }
        };
    }
}

