/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.TypedValue;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;

public class TypedPathElement {
    private String name;
    private String type;
    private String factory;
    private LinkedList<TypedValue> parameters = new LinkedList();
    private TypedValue typedValue = null;
    private TypedPathElement optionalPathElement;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LinkedList<TypedValue> getParameters() {
        return this.parameters;
    }

    public void addParameter(TypedValue parameter) {
        this.parameters.add(parameter);
    }

    public boolean parametrized() {
        return this.parameters.size() > 0;
    }

    public TypedValue getOwnTypedValue() {
        if (this.typedValue == null) {
            this.typedValue = new TypedValue();
            this.typedValue.setType(this.type);
            this.typedValue.setValue(this.name);
        }
        return this.typedValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedPathElement that = (TypedPathElement)o;
        return this.name.equals(that.name) && Objects.equals(this.type, that.type) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        if (this.type != null) {
            sb.append("(").append(this.type);
            if (this.factory != null) {
                sb.append("::").append(this.factory);
            }
            sb.append(" ");
        }
        sb.append(this.name == null ? "?" : this.name);
        if (this.parameters.size() > 0) {
            sb.append(this.parameters.stream().map(p -> String.valueOf(p)).collect(Collectors.joining(",", "(", ")")));
        }
        if (this.type != null) {
            sb.append(")");
        }
        if (this.optionalPathElement != null) {
            sb.append("?").append(this.optionalPathElement.toString());
        }
        return sb.toString();
    }

    public void setOptionalPathElement(TypedPathElement optionalPathElement) {
        this.optionalPathElement = optionalPathElement;
    }

    public TypedPathElement getOptionalPathElement() {
        return this.optionalPathElement;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }
}

