/*
 * Decompiled with CFR 0.152.
 */
package com.aegisql.java_path;

import com.aegisql.java_path.TypedPathElement;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;

public class TypedValue {
    private String value;
    private String type;
    private int backRefIdx = -1;
    private int valueIdx = -1;
    private LinkedList<TypedPathElement> typedPathElements = new LinkedList();
    private Object preEvaluatedValue = null;
    private boolean preEvaluatedValueSet = false;
    private String factory;

    public String getValue() {
        return this.value;
    }

    private String unEscape(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean escFound = false;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if ((i == 0 || i == chars.length - 1) && (ch == '\'' || ch == '\"')) continue;
            if (ch == '\\' && !escFound) {
                escFound = true;
                continue;
            }
            sb.append(ch);
            escFound = false;
        }
        return sb.toString();
    }

    public void setValue(String value) {
        this.value = this.unEscape(value);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean parametrized() {
        return this.type != null && !"".equals(this.type);
    }

    public boolean isHashSign() {
        return this.value != null && this.value.startsWith("#");
    }

    public boolean isDollarSign() {
        return this.value != null && this.value.startsWith("$");
    }

    public int getBackRefIdx() {
        return this.backRefIdx;
    }

    public void setBackRefIdx(int backRefIdx) {
        this.backRefIdx = backRefIdx;
    }

    public int getValueIdx() {
        return this.valueIdx;
    }

    public void setValueIdx(int valueIdx) {
        this.valueIdx = valueIdx;
    }

    public void setTypedPathElements(LinkedList<TypedPathElement> typedPathElements) {
        this.typedPathElements = typedPathElements;
    }

    public LinkedList<TypedPathElement> getTypedPathElements() {
        return this.typedPathElements;
    }

    public boolean hasPath() {
        return this.typedPathElements.size() > 0;
    }

    public Object getPreEvaluatedValue() {
        return this.preEvaluatedValue;
    }

    public void setPreEvaluatedValue(Object preEvaluatedValue) {
        this.preEvaluatedValue = preEvaluatedValue;
    }

    public boolean isPreEvaluatedValueSet() {
        return this.preEvaluatedValueSet;
    }

    public void setPreEvaluatedValueSet(boolean preEvaluatedValueSet) {
        this.preEvaluatedValueSet = preEvaluatedValueSet;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getFactory() {
        return this.factory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedValue that = (TypedValue)o;
        return this.backRefIdx == that.backRefIdx && this.valueIdx == that.valueIdx && this.preEvaluatedValueSet == that.preEvaluatedValueSet && Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type) && Objects.equals(this.typedPathElements, that.typedPathElements) && Objects.equals(this.preEvaluatedValue, that.preEvaluatedValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type, this.backRefIdx, this.valueIdx, this.typedPathElements, this.preEvaluatedValue, this.preEvaluatedValueSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        if (this.type != null) {
            sb.append(this.type);
            if (this.factory != null) {
                sb.append("::").append(this.factory);
            }
            sb.append(" ");
        }
        if (this.backRefIdx < 0) {
            sb.append(this.value);
        } else {
            sb.append("#").append(this.backRefIdx);
        }
        if (this.typedPathElements.size() > 0) {
            sb.append(this.typedPathElements.stream().map(TypedPathElement::toString).collect(Collectors.joining(",", ".", "")));
        }
        return sb.toString();
    }
}

